/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.Map;
import java.util.Objects;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ConditionalUserAttributeValue
implements ConditionalAuthenticator {
    static final ConditionalUserAttributeValue SINGLETON = new ConditionalUserAttributeValue();

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig().getConfig();
        String attributeName = (String)config.get("attribute_name");
        String attributeValue = (String)config.get("attribute_expected_value");
        boolean includeGroupAttributes = Boolean.parseBoolean((String)config.get("include_group_attributes"));
        boolean negateOutput = Boolean.parseBoolean((String)config.get("not"));
        UserModel user = context.getUser();
        if (user == null) {
            throw new AuthenticationFlowException("Cannot find user for obtaining particular user attributes. Authenticator: conditional-user-attribute", AuthenticationFlowError.UNKNOWN_USER);
        }
        boolean result = user.getAttributeStream(attributeName).anyMatch(attr -> Objects.equals(attr, attributeValue));
        if (!result && includeGroupAttributes) {
            result = KeycloakModelUtils.resolveAttribute((UserModel)user, (String)attributeName, (boolean)true).stream().anyMatch(attr -> Objects.equals(attr, attributeValue));
        }
        return negateOutput != result;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

