/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserProvider;
import org.keycloak.provider.InvalidationHandler;

public class MapUserProviderFactory
extends AbstractMapProviderFactory<MapUserProvider, MapUserEntity, UserModel>
implements UserProviderFactory<MapUserProvider>,
InvalidationHandler {
    public MapUserProviderFactory() {
        super(UserModel.class, MapUserProvider.class);
    }

    @Override
    public MapUserProvider createNew(KeycloakSession session) {
        return new MapUserProvider(session, this.getMapStorage(session));
    }

    public String getHelpText() {
        return "User provider";
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapUserProvider)this.create(session)).preRemove((RealmModel)params[0]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE) {
            ((MapUserProvider)this.create(session)).preRemove((RealmModel)params[0], (RoleModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_SCOPE_BEFORE_REMOVE) {
            ((MapUserProvider)this.create(session)).preRemove((ClientScopeModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_BEFORE_REMOVE) {
            ((MapUserProvider)this.create(session)).preRemove((RealmModel)params[0], (ClientModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.GROUP_BEFORE_REMOVE) {
            ((MapUserProvider)this.create(session)).preRemove((RealmModel)params[0], (GroupModel)params[1]);
        }
    }
}

