/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.GroupAttributeEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.GroupRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.utils.StreamsUtil;

public class GroupAdapter
implements GroupModel,
JpaModel<GroupEntity> {
    protected GroupEntity group;
    protected EntityManager em;
    protected RealmModel realm;

    public GroupAdapter(RealmModel realm, EntityManager em, GroupEntity group) {
        this.em = em;
        this.group = group;
        this.realm = realm;
    }

    @Override
    public GroupEntity getEntity() {
        return this.group;
    }

    public String getId() {
        return this.group.getId();
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String name) {
        this.group.setName(name);
    }

    public GroupModel getParent() {
        String parentId = this.getParentId();
        return parentId == null ? null : this.realm.getGroupById(parentId);
    }

    public String getParentId() {
        return GroupEntity.TOP_PARENT_ID.equals(this.group.getParentId()) ? null : this.group.getParentId();
    }

    public static GroupEntity toEntity(GroupModel model, EntityManager em) {
        if (model instanceof GroupAdapter) {
            return ((GroupAdapter)model).getEntity();
        }
        return (GroupEntity)em.getReference(GroupEntity.class, (Object)model.getId());
    }

    public void setParent(GroupModel parent) {
        if (parent == null) {
            this.group.setParentId(GroupEntity.TOP_PARENT_ID);
        } else if (!parent.getId().equals(this.getId())) {
            GroupEntity parentEntity = GroupAdapter.toEntity(parent, this.em);
            this.group.setParentId(parentEntity.getId());
        }
    }

    public void addChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent((GroupModel)this);
    }

    public void removeChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent(null);
    }

    public Stream<GroupModel> getSubGroupsStream() {
        TypedQuery query = this.em.createNamedQuery("getGroupIdsByParent", String.class);
        query.setParameter("parent", (Object)this.group.getId());
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmModel)this.realm).getGroupById(arg_0)).filter(Objects::nonNull));
    }

    public void setSingleAttribute(String name, String value) {
        boolean found = false;
        ArrayList<GroupAttributeEntity> toRemove = new ArrayList<GroupAttributeEntity>();
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            if (!found) {
                attr.setValue(value);
                found = true;
                continue;
            }
            toRemove.add(attr);
        }
        for (GroupAttributeEntity attr : toRemove) {
            this.em.remove((Object)attr);
            this.group.getAttributes().remove(attr);
        }
        if (found) {
            return;
        }
        this.persistAttributeValue(name, value);
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            this.persistAttributeValue(name, value);
        }
    }

    private void persistAttributeValue(String name, String value) {
        GroupAttributeEntity attr = new GroupAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setGroup(this.group);
        this.em.persist((Object)attr);
        this.group.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<GroupAttributeEntity> it = this.group.getAttributes().iterator();
        while (it.hasNext()) {
            GroupAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getFirstAttribute(String name) {
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Stream<String> getAttributeStream(String name) {
        return this.group.getAttributes().stream().filter(attr -> Objects.equals(attr.getName(), name)).map(GroupAttributeEntity::getValue);
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return result;
    }

    public boolean hasRole(RoleModel role) {
        if (RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role)) {
            return true;
        }
        GroupModel parent = this.getParent();
        return parent != null && parent.hasRole(role);
    }

    protected TypedQuery<GroupRoleMappingEntity> getGroupRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("groupHasRole", GroupRoleMappingEntity.class);
        query.setParameter("group", (Object)this.getEntity());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasDirectRole(role)) {
            return;
        }
        GroupRoleMappingEntity entity = new GroupRoleMappingEntity();
        entity.setGroup(this.getEntity());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        TypedQuery query = this.em.createNamedQuery("groupRoleMappingIds", String.class);
        query.setParameter("group", (Object)this.getEntity());
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull));
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.group == null || role == null) {
            return;
        }
        TypedQuery<GroupRoleMappingEntity> query = this.getGroupRoleMappingEntityTypedQuery(role);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (GroupRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GroupModel)) {
            return false;
        }
        GroupModel that = (GroupModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

