/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.config;

import io.quarkus.datasource.common.runtime.DatabaseKind;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum DatabaseOrmCompatibilityVersion {
    V5_6("5.6"){

        @Override
        public Map<String, String> settings(Optional<String> dbKind) {
            HashMap<String, String> result = new HashMap<String, String>(Map.of("hibernate.id.db_structure_naming_strategy", "legacy", "hibernate.type.preferred_duration_jdbc_type", "BIGINT", "hibernate.type.preferred_instant_jdbc_type", "TIMESTAMP", "hibernate.timezone.default_storage", "NORMALIZE"));
            if (dbKind.isPresent() && !DatabaseOrmCompatibilityVersion.usedToSupportUuid(dbKind.get())) {
                result.put("hibernate.type.preferred_uuid_jdbc_type", "BINARY");
            }
            return result;
        }
    }
    ,
    LATEST("latest"){

        @Override
        public Map<String, String> settings(Optional<String> dbKind) {
            return Map.of();
        }
    };

    public final String externalRepresentation;

    private static boolean usedToSupportUuid(String dbKind) {
        return DatabaseKind.isPostgreSQL((String)dbKind);
    }

    private DatabaseOrmCompatibilityVersion(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public String toString() {
        return this.externalRepresentation;
    }

    public abstract Map<String, String> settings(Optional<String> var1);

    public static class Converter
    implements org.eclipse.microprofile.config.spi.Converter<DatabaseOrmCompatibilityVersion> {
        public DatabaseOrmCompatibilityVersion convert(String value) {
            String normalizedValue = value.trim().toLowerCase(Locale.ROOT);
            for (DatabaseOrmCompatibilityVersion candidate : DatabaseOrmCompatibilityVersion.values()) {
                if (!candidate.externalRepresentation.equals(normalizedValue)) continue;
                return candidate;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid ORM compatibility version: %1$s. Valid versions are: %2$s.", value, Arrays.stream(DatabaseOrmCompatibilityVersion.values()).map(v -> v.externalRepresentation).collect(Collectors.toList())));
        }
    }
}

