/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashSet;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;

public class SearchUndeclaredLocalVariableVisitor
extends AbstractJavaSyntaxVisitor {
    protected HashSet<AbstractLocalVariable> variables = new HashSet();
    protected boolean containsLineNumber;

    public void init() {
        this.variables.clear();
        this.containsLineNumber = false;
    }

    public HashSet<AbstractLocalVariable> getVariables() {
        return this.variables;
    }

    public boolean containsLineNumber() {
        return this.containsLineNumber;
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        AbstractLocalVariable lv;
        if (expression.getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && expression.getOperator().equals("=") && !(lv = ((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable()).isDeclared()) {
            this.variables.add(lv);
        }
        expression.getLeftExpression().accept(this);
        expression.getRightExpression().accept(this);
    }

    @Override
    public void visit(DoWhileStatement statement) {
        this.safeAccept(statement.getCondition());
    }

    @Override
    public void visit(ExpressionStatement statement) {
        this.containsLineNumber |= statement.getExpression().getLineNumber() > 0;
        statement.getExpression().accept(this);
    }

    @Override
    public void visit(ForEachStatement statement) {
        statement.getExpression().accept(this);
    }

    @Override
    public void visit(ForStatement statement) {
        this.safeAccept(statement.getDeclaration());
        this.safeAccept(statement.getInit());
        this.safeAccept(statement.getCondition());
        this.safeAccept(statement.getUpdate());
    }

    @Override
    public void visit(IfStatement statement) {
        statement.getCondition().accept(this);
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.getCondition().accept(this);
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        this.containsLineNumber |= statement.getExpression().getLineNumber() > 0;
        statement.getExpression().accept(this);
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getCondition().accept(this);
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        statement.getMonitor().accept(this);
    }

    @Override
    public void visit(TryStatement statement) {
    }

    @Override
    public void visit(WhileStatement statement) {
        statement.getCondition().accept(this);
    }
}

