/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.deobf.DeobfClsInfo;
import jadx.core.deobf.Deobfuscator;
import jadx.core.deobf.PackageNode;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeobfPresets {
    private static final Logger LOG = LoggerFactory.getLogger(DeobfPresets.class);
    private static final Charset MAP_FILE_CHARSET = StandardCharsets.UTF_8;
    private final Deobfuscator deobfuscator;
    private final Path deobfMapFile;
    private final Map<String, String> clsPresetMap = new HashMap<String, String>();
    private final Map<String, String> fldPresetMap = new HashMap<String, String>();
    private final Map<String, String> mthPresetMap = new HashMap<String, String>();

    public DeobfPresets(Deobfuscator deobfuscator, Path deobfMapFile) {
        this.deobfuscator = deobfuscator;
        this.deobfMapFile = deobfMapFile;
    }

    public void load() {
        if (!Files.exists(this.deobfMapFile, new LinkOption[0])) {
            return;
        }
        LOG.info("Loading obfuscation map from: {}", (Object)this.deobfMapFile.toAbsolutePath());
        try {
            List<String> lines = Files.readAllLines(this.deobfMapFile, MAP_FILE_CHARSET);
            for (String l : lines) {
                String[] va;
                if ((l = l.trim()).isEmpty() || l.startsWith("#") || (va = DeobfPresets.splitAndTrim(l)).length != 2) continue;
                String origName = va[0];
                String alias = va[1];
                if (l.startsWith("p ")) {
                    this.deobfuscator.addPackagePreset(origName, alias);
                    continue;
                }
                if (l.startsWith("c ")) {
                    this.clsPresetMap.put(origName, alias);
                    continue;
                }
                if (l.startsWith("f ")) {
                    this.fldPresetMap.put(origName, alias);
                    continue;
                }
                if (!l.startsWith("m ")) continue;
                this.mthPresetMap.put(origName, alias);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to load deobfuscation map file '{}'", (Object)this.deobfMapFile.toAbsolutePath(), (Object)e);
        }
    }

    private static String[] splitAndTrim(String str) {
        String[] v = str.substring(2).split("=");
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i].trim();
        }
        return v;
    }

    public void save(boolean forceSave) {
        try {
            if (Files.exists(this.deobfMapFile, new LinkOption[0])) {
                if (forceSave) {
                    this.dumpMapping();
                } else {
                    LOG.warn("Deobfuscation map file '{}' exists. Use command line option '--deobf-rewrite-cfg' to rewrite it", (Object)this.deobfMapFile.toAbsolutePath());
                }
            } else {
                this.dumpMapping();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to load deobfuscation map file '{}'", (Object)this.deobfMapFile.toAbsolutePath(), (Object)e);
        }
    }

    private void dumpMapping() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (PackageNode p : this.deobfuscator.getRootPackage().getInnerPackages()) {
            for (PackageNode pp : p.getInnerPackages()) {
                DeobfPresets.dfsPackageName(list, p.getName(), pp);
            }
            if (!p.hasAlias()) continue;
            list.add(String.format("p %s = %s", p.getName(), p.getAlias()));
        }
        for (DeobfClsInfo deobfClsInfo : this.deobfuscator.getClsMap().values()) {
            if (deobfClsInfo.getAlias() == null) continue;
            list.add(String.format("c %s = %s", deobfClsInfo.getCls().getClassInfo().makeRawFullName(), deobfClsInfo.getAlias()));
        }
        for (FieldInfo fld : this.deobfuscator.getFldMap().keySet()) {
            list.add(String.format("f %s = %s", fld.getRawFullId(), fld.getAlias()));
        }
        for (MethodInfo mth : this.deobfuscator.getMthMap().keySet()) {
            list.add(String.format("m %s = %s", mth.getRawFullId(), mth.getAlias()));
        }
        Collections.sort(list);
        Files.write(this.deobfMapFile, list, MAP_FILE_CHARSET, new OpenOption[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deobfuscation map file saved as: {}", (Object)this.deobfMapFile);
        }
    }

    private static void dfsPackageName(List<String> list, String prefix, PackageNode node) {
        for (PackageNode pp : node.getInnerPackages()) {
            DeobfPresets.dfsPackageName(list, prefix + '.' + node.getName(), pp);
        }
        if (node.hasAlias()) {
            list.add(String.format("p %s.%s = %s", prefix, node.getName(), node.getAlias()));
        }
    }

    public String getForCls(ClassInfo cls) {
        return this.clsPresetMap.get(cls.makeRawFullName());
    }

    public String getForFld(FieldInfo fld) {
        return this.fldPresetMap.get(fld.getRawFullId());
    }

    public String getForMth(MethodInfo mth) {
        return this.mthPresetMap.get(mth.getRawFullId());
    }

    public void clear() {
        this.clsPresetMap.clear();
        this.fldPresetMap.clear();
        this.mthPresetMap.clear();
    }

    public Map<String, String> getClsPresetMap() {
        return this.clsPresetMap;
    }

    public Map<String, String> getFldPresetMap() {
        return this.fldPresetMap;
    }

    public Map<String, String> getMthPresetMap() {
        return this.mthPresetMap;
    }
}

