/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.EventData;
import org.traccar.forward.EventForwarder;
import org.traccar.forward.ResultHandler;

public class EventForwarderMqtt
implements EventForwarder {
    private final Mqtt5AsyncClient client;
    private final ObjectMapper objectMapper;
    private final String topic;

    public EventForwarderMqtt(Config config, ObjectMapper objectMapper) {
        URI url;
        try {
            url = new URI(config.getString(Keys.EVENT_FORWARD_URL));
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        String userInfo = url.getUserInfo();
        Mqtt5SimpleAuth simpleAuth = null;
        if (userInfo != null) {
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                throw new IllegalArgumentException("Wrong credentials. Should be in format \"username:password\"");
            }
            simpleAuth = ((Mqtt5SimpleAuthBuilder.Complete)((Mqtt5SimpleAuthBuilder.Complete)Mqtt5SimpleAuth.builder().username(userInfo.substring(0, delimiter++))).password(userInfo.substring(delimiter).getBytes())).build();
        }
        String host = url.getHost();
        int port = url.getPort();
        this.client = ((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().identifier("traccar-" + UUID.randomUUID())).serverHost(host)).serverPort(port)).simpleAuth(simpleAuth).automaticReconnectWithDefaultConfig()).buildAsync();
        ((CompletableFuture)this.client.connectWith().send()).whenComplete((message, e) -> {
            if (e != null) {
                throw new RuntimeException((Throwable)e);
            }
        });
        this.objectMapper = objectMapper;
        this.topic = config.getString(Keys.EVENT_FORWARD_TOPIC);
    }

    @Override
    public void forward(EventData eventData, ResultHandler resultHandler) {
        byte[] payload;
        try {
            payload = this.objectMapper.writeValueAsString((Object)eventData).getBytes();
        }
        catch (JsonProcessingException e2) {
            resultHandler.onResult(false, e2);
            return;
        }
        ((CompletableFuture)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)((Mqtt5PublishBuilder.Send.Complete)this.client.publishWith().topic(this.topic)).qos(MqttQos.AT_LEAST_ONCE)).payload(payload)).send()).whenComplete((message, e) -> resultHandler.onResult(e == null, (Throwable)e));
    }
}

