/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.util.TimeHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelloMessagePreparator<T extends HelloMessage>
extends HandshakeMessagePreparator<HandshakeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HelloMessage msg;

    public HelloMessagePreparator(Chooser chooser, HelloMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    protected void prepareRandom() {
        byte[] random;
        if (this.chooser.getConfig().isUseFreshRandom().booleanValue()) {
            random = new byte[28];
            this.chooser.getContext().getRandom().nextBytes(random);
            this.msg.setUnixTime(ArrayConverter.longToUint32Bytes((long)TimeHelper.getTime()));
            random = ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])this.msg.getUnixTime().getValue(), random});
        } else {
            random = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT ? this.chooser.getClientRandom() : this.chooser.getServerRandom();
        }
        this.msg.setRandom(random);
        LOGGER.debug("Random: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getRandom().getValue())));
    }

    protected void prepareSessionIDLength() {
        this.msg.setSessionIdLength(((byte[])this.msg.getSessionId().getValue()).length);
        LOGGER.debug("SessionIdLength: " + this.msg.getSessionIdLength().getValue());
    }
}

