from typing import overload, ByteString, Union
import os

import osmium.index
import osmium.io

StrPath = Union[str, 'os.PathLike[str]']

class InvalidLocationError(Exception): ...

class NodeLocationsForWays:
    def __init__(self, locations: osmium.index.LocationTable) -> None: ...
    def ignore_errors(self) -> None: ...

class BaseHandler: ...

class SimpleHandler(BaseHandler):
    def __init__(self) -> None: ...
    def apply_buffer(self, buffer: Union[ByteString, str], format: str, locations: bool = ..., idx: str = ...) -> None: ...
    def apply_file(self, filename: StrPath, locations: bool = ..., idx: str = ...) -> None: ...

class MergeInputReader:
    def __init__(self) -> None: ...
    def add_buffer(self, buffer: Union[ByteString, str], format: str) -> int: ...
    def add_file(self, file: str) -> int: ...
    def apply(self, handler: BaseHandler, idx: str = ..., simplify: bool = ...) -> None: ...
    def apply_to_reader(self, reader: osmium.io.Reader, writer: osmium.io.Writer, with_history: bool = ...) -> None: ...

class WriteHandler(BaseHandler):
    @overload
    def __init__(self, filename: str, bufsz: int, filetype: str) -> None: ...
    @overload
    def __init__(self, filename: str, bufsz: int) -> None: ...
    @overload
    def __init__(self, filename: str) -> None: ...
    def close(self) -> None: ...

class SimpleWriter:
    @overload
    def __init__(self, filename: str, bufsz: int, header: osmium.io.Header) -> None: ...
    @overload
    def __init__(self, filename: str, bufsz: int) -> None: ...
    @overload
    def __init__(self, filename: str) -> None: ...
    def add_node(self, node: object) -> None: ...
    def add_relation(self, relation: object) -> None: ...
    def add_way(self, way: object) -> None: ...
    def close(self) -> None: ...

@overload
def apply(reader: osmium.io.Reader, handler: BaseHandler) -> None: ...
@overload
def apply(reader: osmium.io.Reader, node_handler: NodeLocationsForWays) -> None: ...
@overload
def apply(reader: osmium.io.Reader, node_handler: NodeLocationsForWays, handler: BaseHandler) -> None: ...
