/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneOrientedBoxBoundMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSE;
    public static final int EXTENTS;

    public XrSceneOrientedBoxBoundMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneOrientedBoxBoundMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef pose() {
        return XrSceneOrientedBoxBoundMSFT.npose(this.address());
    }

    public XrVector3f extents() {
        return XrSceneOrientedBoxBoundMSFT.nextents(this.address());
    }

    public XrSceneOrientedBoxBoundMSFT pose(XrPosef value) {
        XrSceneOrientedBoxBoundMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneOrientedBoxBoundMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneOrientedBoxBoundMSFT extents(XrVector3f value) {
        XrSceneOrientedBoxBoundMSFT.nextents(this.address(), value);
        return this;
    }

    public XrSceneOrientedBoxBoundMSFT extents(Consumer<XrVector3f> consumer) {
        consumer.accept(this.extents());
        return this;
    }

    public XrSceneOrientedBoxBoundMSFT set(XrPosef pose, XrVector3f extents) {
        this.pose(pose);
        this.extents(extents);
        return this;
    }

    public XrSceneOrientedBoxBoundMSFT set(XrSceneOrientedBoxBoundMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneOrientedBoxBoundMSFT malloc() {
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneOrientedBoxBoundMSFT calloc() {
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneOrientedBoxBoundMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneOrientedBoxBoundMSFT create(long address) {
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneOrientedBoxBoundMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneOrientedBoxBoundMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneOrientedBoxBoundMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneOrientedBoxBoundMSFT malloc(MemoryStack stack) {
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneOrientedBoxBoundMSFT calloc(MemoryStack stack) {
        return (XrSceneOrientedBoxBoundMSFT)XrSceneOrientedBoxBoundMSFT.wrap(XrSceneOrientedBoxBoundMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneOrientedBoxBoundMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrVector3f nextents(long struct) {
        return XrVector3f.create(struct + (long)EXTENTS);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nextents(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENTS), (long)XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSceneOrientedBoxBoundMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneOrientedBoxBoundMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrSceneOrientedBoxBoundMSFT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSE = layout.offsetof(0);
        EXTENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneOrientedBoxBoundMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneOrientedBoxBoundMSFT ELEMENT_FACTORY = XrSceneOrientedBoxBoundMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneOrientedBoxBoundMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef pose() {
            return XrSceneOrientedBoxBoundMSFT.npose(this.address());
        }

        public XrVector3f extents() {
            return XrSceneOrientedBoxBoundMSFT.nextents(this.address());
        }

        public Buffer pose(XrPosef value) {
            XrSceneOrientedBoxBoundMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer extents(XrVector3f value) {
            XrSceneOrientedBoxBoundMSFT.nextents(this.address(), value);
            return this;
        }

        public Buffer extents(Consumer<XrVector3f> consumer) {
            consumer.accept(this.extents());
            return this;
        }
    }
}

