/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.user;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Keyword;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.jboss.logging.Logger;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserConsentEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserCredentialEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserFederatedIdentityEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@Indexed
@ProtoDoc(value="schema-version: 1")
public class HotRodUserEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @IgnoreForEntityImplementationGenerator
    private static final Logger LOG = Logger.getLogger(HotRodUserEntity.class);
    @Basic(projectable=true)
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @Basic(projectable=true, sortable=true)
    @ProtoField(number=2)
    public String id;
    @Basic(sortable=true)
    @ProtoField(number=3)
    public String realmId;
    @Basic(sortable=true)
    @ProtoField(number=4)
    public String username;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=5)
    public String usernameLowercase;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=6)
    public String firstName;
    @ProtoField(number=7)
    public Long createdTimestamp;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=8)
    public String lastName;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=9)
    public String email;
    @Basic(sortable=true)
    @ProtoField(number=10)
    public Boolean enabled;
    @Basic(sortable=true)
    @ProtoField(number=11)
    public Boolean emailVerified;
    @ProtoField(number=12)
    public String emailConstraint;
    @Basic(sortable=true)
    @ProtoField(number=13)
    public Set<HotRodAttributeEntity> attributes;
    @ProtoField(number=14)
    public Set<String> requiredActions;
    @ProtoField(number=15)
    public List<HotRodUserCredentialEntity> credentials;
    @Basic(sortable=true)
    @ProtoField(number=16)
    public Set<HotRodUserFederatedIdentityEntity> federatedIdentities;
    @Basic(sortable=true)
    @ProtoField(number=17)
    public Set<HotRodUserConsentEntity> userConsents;
    @Basic(sortable=true)
    @ProtoField(number=18)
    public Set<String> groupsMembership = new HashSet<String>();
    @Basic(sortable=true)
    @ProtoField(number=19)
    public Set<String> rolesMembership = new HashSet<String>();
    @Basic(sortable=true)
    @ProtoField(number=20)
    public String federationLink;
    @Basic(sortable=true)
    @ProtoField(number=21)
    public String serviceAccountClientLink;
    @ProtoField(number=22)
    public Long notBefore;

    public boolean equals(Object o) {
        return HotRodUserEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodUserEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodUserEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodUserEntity>
    implements MapUserEntity {
        public String getId() {
            return ((HotRodUserEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodUserEntity entity = (HotRodUserEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setEmail(String email, boolean duplicateEmailsAllowed) {
            this.setEmail(email);
            this.setEmailConstraint(email == null || duplicateEmailsAllowed ? KeycloakModelUtils.generateId() : email);
        }

        public void setUsername(String username) {
            HotRodUserEntity entity = (HotRodUserEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.username, username);
            entity.username = username;
            entity.usernameLowercase = username == null ? null : username.toLowerCase();
        }

        @Override
        public boolean isUpdated() {
            return ((HotRodUserEntity)this.getHotRodEntity()).updated || Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            ((HotRodUserEntity)this.getHotRodEntity()).updated = false;
            Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        public Boolean moveCredential(String credentialId, String newPreviousCredentialId) {
            int toMoveIndex;
            List<HotRodUserCredentialEntity> credentialsList = ((HotRodUserEntity)this.getHotRodEntity()).credentials;
            int ourCredentialIndex = -1;
            int newPreviousCredentialIndex = -1;
            HotRodUserCredentialEntity ourCredential = null;
            int i = 0;
            for (HotRodUserCredentialEntity credential : credentialsList) {
                if (credentialId.equals(credential.id)) {
                    ourCredentialIndex = i;
                    ourCredential = credential;
                } else if (newPreviousCredentialId != null && newPreviousCredentialId.equals(credential.id)) {
                    newPreviousCredentialIndex = i;
                }
                ++i;
            }
            if (ourCredentialIndex == -1) {
                LOG.warnf("Not found credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            if (newPreviousCredentialId != null && newPreviousCredentialIndex == -1) {
                LOG.warnf("Can't move up credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            int n = toMoveIndex = newPreviousCredentialId == null ? 0 : newPreviousCredentialIndex + 1;
            if (toMoveIndex == ourCredentialIndex) {
                return true;
            }
            credentialsList.add(toMoveIndex, ourCredential);
            int indexToRemove = toMoveIndex < ourCredentialIndex ? ourCredentialIndex + 1 : ourCredentialIndex;
            credentialsList.remove(indexToRemove);
            ((HotRodUserEntity)this.getHotRodEntity()).updated = true;
            return true;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodUserEntity.class, HotRodUserConsentEntity.class, HotRodUserCredentialEntity.class, HotRodUserFederatedIdentityEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodUserEntitySchema
    extends GeneratedSchema {
        public static final HotRodUserEntitySchema INSTANCE = new HotRodUserEntitySchemaImpl();
    }
}

