/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.SingleUseObjectMapStorage;
import org.keycloak.models.map.storage.hotRod.HotRodCrudOperations;
import org.keycloak.models.map.storage.hotRod.HotRodMapStorageProviderFactory;
import org.keycloak.models.map.storage.hotRod.SingleUseObjectHotRodCrudOperations;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.singleUseObject.HotRodSingleUseObjectEntity;
import org.keycloak.models.map.storage.hotRod.singleUseObject.HotRodSingleUseObjectEntityDelegate;
import org.keycloak.models.map.storage.hotRod.transaction.AllAreasHotRodStoresWrapper;
import org.keycloak.models.map.storage.hotRod.transaction.HotRodRemoteTransactionWrapper;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionMapStorage;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;

public class HotRodMapStorageProvider
implements MapStorageProvider {
    private final KeycloakSession session;
    private final HotRodMapStorageProviderFactory factory;
    private final boolean jtaEnabled;
    private final long lockTimeout;
    private AllAreasHotRodStoresWrapper storesWrapper;

    public HotRodMapStorageProvider(KeycloakSession session, HotRodMapStorageProviderFactory factory, boolean jtaEnabled, long lockTimeout) {
        this.session = session;
        this.factory = factory;
        this.jtaEnabled = jtaEnabled;
        this.lockTimeout = lockTimeout;
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getMapStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        if (this.storesWrapper == null) {
            this.initializeTransactionWrapper(modelType);
        }
        if (modelType == UserSessionModel.class) {
            this.getMapStorage(AuthenticatedClientSessionModel.class, flags);
        }
        return this.storesWrapper.getOrCreateStoreForModel(modelType, () -> this.createHotRodMapStorage(this.session, modelType, flags));
    }

    private void initializeTransactionWrapper(Class<?> modelType) {
        this.storesWrapper = new AllAreasHotRodStoresWrapper();
        this.session.getTransactionManager().enlistPrepare((KeycloakTransaction)this.storesWrapper);
        if (!this.jtaEnabled) {
            HotRodConnectionProvider connectionProvider = (HotRodConnectionProvider)this.session.getProvider(HotRodConnectionProvider.class);
            HotRodEntityDescriptor<?, ?> entityDescriptor = this.factory.getEntityDescriptor(modelType);
            RemoteCache remoteCache = connectionProvider.getRemoteCache(entityDescriptor.getCacheName());
            this.session.getTransactionManager().enlist((KeycloakTransaction)new HotRodRemoteTransactionWrapper(remoteCache.getTransactionManager()));
        }
    }

    private <K, E extends AbstractHotRodEntity, V extends HotRodEntityDelegate<E> & AbstractEntity, M> ConcurrentHashMapStorage<K, V, M, ?> createHotRodMapStorage(KeycloakSession session, Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        HotRodConnectionProvider connectionProvider = (HotRodConnectionProvider)session.getProvider(HotRodConnectionProvider.class);
        HotRodEntityDescriptor<HotRodSingleUseObjectEntity, HotRodSingleUseObjectEntityDelegate> entityDescriptor = this.factory.getEntityDescriptor(modelType);
        Map fieldPredicates = MapFieldPredicates.getPredicates(entityDescriptor.getModelTypeClass());
        StringKeyConverter.StringKey kc = StringKeyConverter.StringKey.INSTANCE;
        if (modelType == SingleUseObjectValueModel.class) {
            return new SingleUseObjectMapStorage((CrudOperations)new SingleUseObjectHotRodCrudOperations(session, (RemoteCache<String, HotRodSingleUseObjectEntity>)connectionProvider.getRemoteCache(entityDescriptor.getCacheName()), (StringKeyConverter<String>)kc, entityDescriptor, HotRodMapStorageProviderFactory.CLONER, (Long)this.lockTimeout), (StringKeyConverter)kc, HotRodMapStorageProviderFactory.CLONER, fieldPredicates);
        }
        if (modelType == AuthenticatedClientSessionModel.class) {
            return new ConcurrentHashMapStorage(new HotRodCrudOperations(session, connectionProvider.getRemoteCache(entityDescriptor.getCacheName()), kc, entityDescriptor, HotRodMapStorageProviderFactory.CLONER, this.lockTimeout), (StringKeyConverter)kc, HotRodMapStorageProviderFactory.CLONER, HotRodMapStorageProviderFactory.CLIENT_SESSION_PREDICATES);
        }
        if (modelType == UserSessionModel.class) {
            return new HotRodUserSessionMapStorage(new HotRodCrudOperations(session, connectionProvider.getRemoteCache(entityDescriptor.getCacheName()), kc, entityDescriptor, HotRodMapStorageProviderFactory.CLONER, this.lockTimeout), kc, HotRodMapStorageProviderFactory.CLONER, fieldPredicates, (ConcurrentHashMapStorage<String, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel, CrudOperations<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel>>)this.storesWrapper.getOrCreateStoreForModel(AuthenticatedClientSessionModel.class, () -> this.createHotRodMapStorage(session, AuthenticatedClientSessionModel.class, flags)));
        }
        return new ConcurrentHashMapStorage(new HotRodCrudOperations(session, connectionProvider.getRemoteCache(entityDescriptor.getCacheName()), kc, entityDescriptor, HotRodMapStorageProviderFactory.CLONER, this.lockTimeout), (StringKeyConverter)kc, HotRodMapStorageProviderFactory.CLONER, fieldPredicates);
    }

    public void close() {
    }
}

