/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Dot11LinkAdaptationControl
implements Serializable {
    private static final long serialVersionUID = 7735461000002622072L;
    public static final byte ASELI = 14;
    private final boolean vhtMfb;
    private final boolean trq;
    private final boolean aseli;
    private final Mai mai;
    private final byte mfsi;
    private final Byte mfb;
    private final Aselc aselc;

    public static Dot11LinkAdaptationControl newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11LinkAdaptationControl(rawData, offset, length);
    }

    private Dot11LinkAdaptationControl(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a Dot11LinkAdaptationControl (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        byte first = rawData[offset];
        byte second = rawData[offset + 1];
        this.vhtMfb = (first & 1) != 0;
        this.trq = (first & 2) != 0;
        boolean bl = this.aseli = (first >> 2 & 0xF) == 14;
        this.mai = this.aseli ? null : new Mai((first & 4) != 0, (byte)(first >> 3 & 7));
        this.mfsi = (byte)(first >> 6 & 3 | (second & 1) << 2);
        byte mfbAselc = (byte)(second >> 1 & 0x7F);
        this.mfb = mfbAselc;
        this.aselc = new Aselc(mfbAselc);
    }

    private Dot11LinkAdaptationControl(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        if ((builder2.maiOrAseli & 0xF0) != 0) {
            throw new IllegalArgumentException("(builder.maiOrAseli & 0xF0) must be zero. builder.maiOrAseli: " + builder2.maiOrAseli);
        }
        if ((builder2.mfsi & 0xF8) != 0) {
            throw new IllegalArgumentException("(builder.mfsi & 0xF8) must be zero. builder.mfsi: " + builder2.mfsi);
        }
        if ((builder2.mfbOrAselc & 0x80) != 0) {
            throw new IllegalArgumentException("(builder.mfbOrAselc & 0x80) must be zero. builder.mfbOrAselc: " + builder2.mfbOrAselc);
        }
        this.vhtMfb = builder2.vhtMfb;
        this.trq = builder2.trq;
        this.aseli = builder2.maiOrAseli == 14;
        this.mai = this.aseli ? null : new Mai(builder2.maiOrAseli);
        this.mfsi = builder2.mfsi;
        this.mfb = builder2.mfbOrAselc;
        this.aselc = new Aselc(builder2.mfbOrAselc);
    }

    public boolean isVhtMfb() {
        return this.vhtMfb;
    }

    public boolean isTrq() {
        return this.trq;
    }

    public boolean isAselIndicated() {
        return this.aseli;
    }

    public Mai getMai() {
        return this.mai;
    }

    public byte getMfsi() {
        return this.mfsi;
    }

    public int getMfsiAsInt() {
        return this.mfsi;
    }

    public Byte getMfb() {
        if (this.aseli) {
            return null;
        }
        return this.mfb;
    }

    public Integer getMfbAsInteger() {
        if (this.aseli) {
            return null;
        }
        return (int)this.mfb;
    }

    public Aselc getAselc() {
        if (this.aseli) {
            return this.aselc;
        }
        return null;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data2 = new byte[2];
        int maiOrAseli = this.aseli ? 14 : (int)this.mai.getRawData();
        data2[0] = (byte)(this.mfsi << 6 | maiOrAseli << 2);
        if (this.trq) {
            data2[0] = (byte)(data2[0] | 2);
        }
        if (this.vhtMfb) {
            data2[0] = (byte)(data2[0] | 1);
        }
        data2[1] = (byte)(this.mfb << 1);
        if ((this.mfsi & 4) != 0) {
            data2[1] = (byte)(data2[1] | 1);
        }
        return data2;
    }

    public int length() {
        return 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("[VHT_MFB: ").append(this.vhtMfb).append(", TRQ: ").append(this.trq).append(", ASELI: ").append(this.aseli);
        if (!this.aseli) {
            sb.append(", MAI: ").append(this.mai);
        }
        sb.append(", MFSI: ").append(this.mfsi);
        if (this.aseli) {
            sb.append(", ASELC: ").append(this.aselc);
        } else {
            sb.append(", MFB: ").append(this.mfb);
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.mai == null ? 0 : this.mai.hashCode());
        result2 = 31 * result2 + this.mfb.hashCode();
        result2 = 31 * result2 + this.mfsi;
        result2 = 31 * result2 + (this.aseli ? 1231 : 1237);
        result2 = 31 * result2 + (this.vhtMfb ? 1231 : 1237);
        result2 = 31 * result2 + (this.trq ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11LinkAdaptationControl other = (Dot11LinkAdaptationControl)obj;
        if (this.mai == null ? other.mai != null : !this.mai.equals(other.mai)) {
            return false;
        }
        if (!this.mfb.equals(other.mfb)) {
            return false;
        }
        if (this.mfsi != other.mfsi) {
            return false;
        }
        if (this.aseli != other.aseli) {
            return false;
        }
        if (this.vhtMfb != other.vhtMfb) {
            return false;
        }
        return this.trq == other.trq;
    }

    public static final class Builder {
        private boolean vhtMfb;
        private boolean trq;
        private byte maiOrAseli;
        private byte mfsi;
        private byte mfbOrAselc;

        public Builder() {
        }

        private Builder(Dot11LinkAdaptationControl obj) {
            this.vhtMfb = obj.vhtMfb;
            this.trq = obj.trq;
            this.maiOrAseli = obj.mai.getRawData();
            this.mfsi = obj.mfsi;
            this.mfbOrAselc = obj.mfb;
        }

        public Builder vhtMfb(boolean vhtMfb) {
            this.vhtMfb = vhtMfb;
            return this;
        }

        public Builder trq(boolean trq) {
            this.trq = trq;
            return this;
        }

        public Builder maiOrAseli(byte maiOrAseli) {
            this.maiOrAseli = maiOrAseli;
            return this;
        }

        public Builder maiOrAseli(Mai maiOrAseli) {
            this.maiOrAseli = maiOrAseli.getRawData();
            return this;
        }

        public Builder mfsi(byte mfsi) {
            this.mfsi = mfsi;
            return this;
        }

        public Builder mfbOrAselc(byte mfbOrAselc) {
            this.mfbOrAselc = mfbOrAselc;
            return this;
        }

        public Builder mfbOrAselc(Aselc mfbOrAselc) {
            this.mfbOrAselc = mfbOrAselc.getRawData();
            return this;
        }

        public Dot11LinkAdaptationControl build() {
            return new Dot11LinkAdaptationControl(this);
        }
    }

    public static enum AselCommand {
        TXASSI(0, "TXASSI"),
        TXASSR(1, "TXASSR"),
        RXASSI(2, "RXASSI"),
        RXASSR(3, "RXASSR"),
        SOUNDING_LABEL(4, "Sounding Label"),
        NO_FEEDBACK(5, "No Feedback"),
        TXASSI_CSI(6, "TXASSI-CSI"),
        SEVEN(7, "Reserved");

        private final int value;
        private final String name;

        private AselCommand(int value2, String name) {
            this.value = value2;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static AselCommand getInstance(int value2) {
            for (AselCommand com : AselCommand.values()) {
                if (com.value != value2) continue;
                return com;
            }
            throw new IllegalArgumentException("Invalid value: " + value2);
        }
    }

    public static final class Aselc
    implements Serializable {
        private static final long serialVersionUID = -5404846090809709793L;
        private final AselCommand command;
        private final byte data;

        public Aselc(AselCommand command, byte data2) {
            if (command == null) {
                throw new IllegalArgumentException("command is null.");
            }
            if ((data2 & 0xF0) != 0) {
                throw new IllegalArgumentException("(data & 0xF0) must be zero. data: " + data2);
            }
            this.command = command;
            this.data = data2;
        }

        public Aselc(byte rawData) {
            this.command = AselCommand.getInstance(rawData & 7);
            this.data = (byte)(rawData >> 3 & 0xF);
        }

        public AselCommand getCommand() {
            return this.command;
        }

        public byte getData() {
            return this.data;
        }

        public byte getRawData() {
            return (byte)(this.command.value << 4 | this.data);
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.command.hashCode();
            result2 = 31 * result2 + this.data;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Aselc other = (Aselc)obj;
            if (this.command != other.command) {
                return false;
            }
            return this.data == other.data;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("[ASEL Command: ").append((Object)this.command).append(", ASEL Data: ").append(this.data).append("]");
            return sb.toString();
        }
    }

    public static final class Mai
    implements Serializable {
        private static final long serialVersionUID = -7417614720576047794L;
        private final boolean mrq;
        private final byte msi;

        public Mai(boolean mrq, byte msi) {
            if (msi < 0 || msi > 6) {
                throw new IllegalArgumentException("msi must be between 0 and 6 but is actually: " + msi);
            }
            this.mrq = mrq;
            this.msi = msi;
        }

        public Mai(byte rawData) {
            this.mrq = (rawData & 1) != 0;
            this.msi = (byte)(rawData >> 1 & 7);
        }

        public boolean isMrq() {
            return this.mrq;
        }

        public byte getMsi() {
            return this.msi;
        }

        public byte getRawData() {
            if (this.mrq) {
                return (byte)(this.msi << 1 | 1);
            }
            return (byte)(this.msi << 1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("[MRQ: ").append(this.mrq).append(", MSI: ").append(this.msi).append("]");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.mrq ? 1231 : 1237);
            result2 = 31 * result2 + this.msi;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mai other = (Mai)obj;
            if (this.mrq != other.mrq) {
                return false;
            }
            return this.msi == other.msi;
        }
    }
}

