/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.Closeable;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;

public abstract class DataImporter
implements Closeable {
    public abstract String getVersion() throws IOException;

    public abstract long getLastUpdateTime() throws IOException;

    public abstract long getStep() throws IOException;

    public abstract int getDsCount() throws IOException;

    public abstract int getArcCount() throws IOException;

    public abstract String getDsName(int var1) throws IOException;

    public abstract DsType getDsType(int var1) throws IOException;

    public abstract long getHeartbeat(int var1) throws IOException;

    public abstract double getMinValue(int var1) throws IOException;

    public abstract double getMaxValue(int var1) throws IOException;

    public abstract double getLastValue(int var1) throws IOException;

    public abstract double getAccumValue(int var1) throws IOException;

    public abstract long getNanSeconds(int var1) throws IOException;

    public abstract ConsolFun getConsolFun(int var1) throws IOException;

    public abstract double getXff(int var1) throws IOException;

    public abstract int getSteps(int var1) throws IOException;

    public abstract int getRows(int var1) throws IOException;

    public abstract double getStateAccumValue(int var1, int var2) throws IOException;

    public abstract int getStateNanSteps(int var1, int var2) throws IOException;

    public abstract double[] getValues(int var1, int var2) throws IOException;

    protected long getEstimatedSize() throws IOException {
        int dsCount = this.getDsCount();
        int arcCount = this.getArcCount();
        int rowCount = 0;
        for (int i = 0; i < arcCount; ++i) {
            rowCount += this.getRows(i);
        }
        String[] dsNames = new String[this.getDsCount()];
        for (int i = 0; i < dsNames.length; ++i) {
            dsNames[i] = this.getDsName(i);
        }
        return RrdDef.calculateSize(dsCount, arcCount, rowCount, dsNames);
    }

    void release() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.release();
    }
}

