"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPageHeaderContent", {
  enumerable: true,
  get: function get() {
    return _page_header_content.EuiPageHeaderContent;
  }
});
exports.OuiPageHeaderContent = exports.ALIGN_ITEMS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../../icon");

var _tabs = require("../../tabs");

var _flex = require("../../flex");

var _spacer = require("../../spacer");

var _title = require("../../title");

var _text = require("../../text");

var _hooks = require("../../../services/hooks");

var _page_header_content = require("../../../eui_components/page/page_header/page_header_content");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var ALIGN_ITEMS = ['top', 'bottom', 'center', 'stretch']; // Gets all the tab props including the button or link props

exports.ALIGN_ITEMS = ALIGN_ITEMS;

var OuiPageHeaderContent = function OuiPageHeaderContent(_ref) {
  var className = _ref.className,
      pageTitle = _ref.pageTitle,
      iconType = _ref.iconType,
      iconProps = _ref.iconProps,
      tabs = _ref.tabs,
      tabsProps = _ref.tabsProps,
      description = _ref.description,
      _ref$alignItems = _ref.alignItems,
      alignItems = _ref$alignItems === void 0 ? 'top' : _ref$alignItems,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? true : _ref$responsive,
      rightSideItems = _ref.rightSideItems,
      rightSideGroupProps = _ref.rightSideGroupProps,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "pageTitle", "iconType", "iconProps", "tabs", "tabsProps", "description", "alignItems", "responsive", "rightSideItems", "rightSideGroupProps", "children"]);
  var isResponsiveBreakpoint = (0, _hooks.useIsWithinBreakpoints)(['xs', 's'], !!responsive);
  var classes = (0, _classnames.default)('ouiPageHeaderContent');
  var descriptionNode;

  if (description) {
    descriptionNode = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (pageTitle || tabs) && /*#__PURE__*/_react.default.createElement(_spacer.OuiSpacer, null), /*#__PURE__*/_react.default.createElement(_text.OuiText, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("p", null, description)));
  }

  var pageTitleNode;

  if (pageTitle) {
    var icon = iconType ? /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, (0, _extends2.default)({
      size: "xl"
    }, iconProps, {
      type: iconType,
      className: (0, _classnames.default)('ouiPageHeaderContent__titleIcon', iconProps === null || iconProps === void 0 ? void 0 : iconProps.className)
    })) : undefined;
    pageTitleNode = /*#__PURE__*/_react.default.createElement(_title.OuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", null, icon, pageTitle));
  }

  var tabsNode;

  if (tabs) {
    var renderTabs = function renderTabs() {
      return tabs.map(function (tab, index) {
        var label = tab.label,
            tabRest = (0, _objectWithoutProperties2.default)(tab, ["label"]);
        return /*#__PURE__*/_react.default.createElement(_tabs.OuiTab, (0, _extends2.default)({
          key: index
        }, tabRest), label);
      });
    };

    tabsNode = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pageTitleNode && /*#__PURE__*/_react.default.createElement(_spacer.OuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tabs.OuiTabs, (0, _extends2.default)({}, tabsProps, {
      display: "condensed",
      size: "l"
    }), renderTabs()));
  }

  var childrenNode = children && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spacer.OuiSpacer, null), children);

  var bottomContentNode;

  if (childrenNode || tabsNode && pageTitleNode) {
    bottomContentNode = /*#__PURE__*/_react.default.createElement("div", {
      className: "ouiPageHeaderContent__bottom"
    }, childrenNode, pageTitleNode && tabsNode);
  }
  /**
   * The left side order depends on if a `pageTitle` was supplied.
   * If not, but there are `tabs`, then the tabs become the page title
   */


  var leftSideOrder;

  if (tabsNode && !pageTitleNode) {
    leftSideOrder = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tabsNode, descriptionNode);
  } else {
    leftSideOrder = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pageTitleNode, descriptionNode);
  }

  var rightSideFlexItem;

  if (rightSideItems && rightSideItems.length) {
    var wrapWithFlex = function wrapWithFlex() {
      return rightSideItems.map(function (item, index) {
        return /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
          grow: false,
          key: index
        }, item);
      });
    };

    rightSideFlexItem = /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, (0, _extends2.default)({
      wrap: true,
      responsive: false
    }, rightSideGroupProps, {
      className: (0, _classnames.default)('ouiPageHeaderContent__rightSideItems', rightSideGroupProps === null || rightSideGroupProps === void 0 ? void 0 : rightSideGroupProps.className)
    }), wrapWithFlex()));
  }

  return alignItems === 'top' || isResponsiveBreakpoint ? /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
    responsive: !!responsive,
    className: "ouiPageHeaderContent__top",
    alignItems: "flexStart",
    gutterSize: "l"
  }, isResponsiveBreakpoint && responsive === 'reverse' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rightSideFlexItem, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, null, leftSideOrder)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, null, leftSideOrder), rightSideFlexItem)), bottomContentNode) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
    responsive: !!responsive,
    className: "ouiPageHeaderContent__top",
    alignItems: alignItems === 'bottom' ? 'flexEnd' : alignItems,
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, null, leftSideOrder, bottomContentNode), rightSideFlexItem));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPageHeaderContent = OuiPageHeaderContent;
OuiPageHeaderContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Wrapped in an `H1` so choose appropriately.
     * A simple string is best
     */
  pageTitle: _propTypes.default.node,

  /**
     * Optional icon to place to the left of the title
     * @deprecated The `iconType` prop is deprecated and will be removed in the future.
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "push", "questionInCircle", "quote", "radius", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * Additional OuiIcon props to apply to the optional icon
     * @deprecated The `iconProps` prop is deprecated and will be removed in the future.
     */
  iconProps: _propTypes.default.any,

  /**
     * In-app navigation presented as large borderless tabs.
     * Accepts an array of `OuiTab` objects;
     * HELP: This is evaluating to `any[]` in the props table
     */
  tabs: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Visible text of the tab
       */
    label: _propTypes.default.node.isRequired
  }).isRequired),

  /**
     * Any extras to apply to the outer tabs container.
     * Extends `OuiTabs`
     */
  tabsProps: _propTypes.default.any,

  /**
       * Position is dependent on existing with a `pageTitle` or `tabs`
       * Automatically get wrapped in a single paragraph tag inside an OuiText block
       */
  description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),

  /**
       * Set to false if you don't want the children to stack at small screen sizes.
       * Set to `reverse` to display the right side content first for the sack of hierarchy (like global time)
       */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["reverse"])]),

  /**
       * Vertical alignment of the left and right side content;
       * Default is `middle` for custom content, but `top` for when `pageTitle` or `tabs` are included
       */
  alignItems: _propTypes.default.any,

  /**
       * Pass custom an array of content to this side usually up to 3 buttons.
       * The first button should be primary, usually with `fill` and will be visually displayed as the last item,
       * but first in the tab order
       */
  rightSideItems: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),

  /**
       * Additional OuiFlexGroup props to pass to the container of the `rightSideItems`
       */
  rightSideGroupProps: _propTypes.default.any,

  /**
       * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
       */
  children: _propTypes.default.node
};