/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Consumer;

public class MultiMap<K, V> {
    public static final int DEFAULT_MAP_SIZE = 6;
    private static final int ENTRY_LIST_SIZE = 3;
    private final Map<K, List<V>> map;

    public MultiMap() {
        this(6);
    }

    public MultiMap(int size) {
        this(new LinkedHashMap(size));
    }

    private MultiMap(Map<K, List<V>> map) {
        this.map = map;
    }

    public int size() {
        int size = 0;
        for (List<V> list : this.map.values()) {
            size += list.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value2) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(value2)) continue;
            return true;
        }
        return false;
    }

    public V getFirst(K key) {
        List<V> res = this.getAll(key);
        if (res.isEmpty()) {
            return null;
        }
        return res.iterator().next();
    }

    public List<V> getAll(K key) {
        List<Object> res = this.map.get(key);
        if (res == null) {
            res = Collections.emptyList();
        }
        return res;
    }

    public boolean put(K key, V value2) {
        return this.putInternal(key, list -> list.add(value2));
    }

    public boolean putFirst(K key, V value2) {
        return this.putInternal(key, list -> list.add(0, value2));
    }

    private boolean putInternal(K key, Consumer<List<V>> valueListConsumer) {
        boolean keyExisted;
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>(3);
            this.map.put(key, list);
            keyExisted = false;
        } else {
            keyExisted = true;
        }
        valueListConsumer.accept(list);
        return keyExisted;
    }

    public V remove(K key) {
        List<V> res = this.map.remove(key);
        if (res == null) {
            return null;
        }
        assert (!res.isEmpty());
        return res.iterator().next();
    }

    public boolean removeOne(K key, V value2) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        boolean res = list.remove(value2);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return res;
    }

    public List<V> remove(K key, int num) {
        List<V> values2 = this.map.get(key);
        if (values2 == null) {
            return Collections.emptyList();
        }
        int resultSize = values2.size() > num ? num : values2.size();
        ArrayList<V> result2 = new ArrayList<V>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            result2.add(values2.get(0));
        }
        if (values2.isEmpty()) {
            this.map.remove(key);
        }
        return result2;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList<V> values2 = new ArrayList<V>(this.size());
        for (List<V> list : this.map.values()) {
            values2.addAll(list);
        }
        return values2;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>(this.size());
        for (Map.Entry<K, List<V>> entries : this.map.entrySet()) {
            K key = entries.getKey();
            for (V value2 : entries.getValue()) {
                entrySet.add(new SimpleMapEntry(key, value2));
            }
        }
        return entrySet;
    }

    public MultiMap<K, V> asUnmodifiableMultiMap() {
        LinkedHashMap<K, List<V>> mapCopy = new LinkedHashMap<K, List<V>>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> values2 = entry.getValue();
            mapCopy.put(key, Collections.unmodifiableList(values2));
        }
        return new MultiMap(Collections.unmodifiableMap(mapCopy));
    }

    public MultiMap<K, V> clone() {
        LinkedHashMap clonedMap = new LinkedHashMap(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            ArrayList clonedList = CollectionUtil.newListWith((Collection)entry.getValue());
            clonedMap.put(entry.getKey(), clonedList);
        }
        return new MultiMap(clonedMap);
    }

    private static final class SimpleMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private SimpleMapEntry(K key, V value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V tmp = this.value;
            this.value = value2;
            return tmp;
        }
    }
}

