/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0004\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0015"}, d2={"days", "Ljava/time/Duration;", "", "getDays", "(Ljava/lang/Number;)Ljava/time/Duration;", "hours", "getHours", "mins", "getMins", "ms", "getMs", "nanos", "getNanos", "secs", "getSecs", "div", "", "other", "times", "x", "", "jitsi-utils"})
public final class DurationKt {
    @NotNull
    public static final Duration getNanos(@NotNull Number $this$nanos) {
        Intrinsics.checkNotNullParameter($this$nanos, "<this>");
        Duration duration = Duration.ofNanos($this$nanos.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofNanos(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration getMs(@NotNull Number $this$ms) {
        Intrinsics.checkNotNullParameter($this$ms, "<this>");
        Duration duration = Duration.ofMillis($this$ms.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration getSecs(@NotNull Number $this$secs) {
        Intrinsics.checkNotNullParameter($this$secs, "<this>");
        Duration duration = Duration.ofSeconds($this$secs.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofSeconds(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration getHours(@NotNull Number $this$hours) {
        Intrinsics.checkNotNullParameter($this$hours, "<this>");
        Duration duration = Duration.ofHours($this$hours.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofHours(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration getMins(@NotNull Number $this$mins) {
        Intrinsics.checkNotNullParameter($this$mins, "<this>");
        Duration duration = Duration.ofMinutes($this$mins.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofMinutes(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration getDays(@NotNull Number $this$days) {
        Intrinsics.checkNotNullParameter($this$days, "<this>");
        Duration duration = Duration.ofDays($this$days.longValue());
        Intrinsics.checkNotNullExpressionValue(duration, "ofDays(this.toLong())");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, int x) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Duration duration = Duration.ofNanos($this$times.toNanos() * (long)x);
        Intrinsics.checkNotNullExpressionValue(duration, "ofNanos(toNanos() * x)");
        return duration;
    }

    public static final double div(@NotNull Duration $this$div, @NotNull Duration other) {
        Intrinsics.checkNotNullParameter($this$div, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return (double)$this$div.toNanos() / (double)other.toNanos();
    }
}

