/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.ImplementedBy;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.binders.BeanListProvider;
import org.sonatype.guice.bean.binders.BeanMapProvider;
import org.sonatype.guice.bean.binders.BeanProvider;
import org.sonatype.guice.bean.binders.NamedBeanMapProvider;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.PlaceholderBeanProvider;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImportBinder {
    private static final Map<String, String> DEFAULT_PROPERTIES = Collections.emptyMap();
    private static final String[] DEFAULT_ARGUMENTS = new String[0];
    private final Binder binder;

    ImportBinder(Binder binder) {
        this.binder = binder;
    }

    public void bind(Set<Key<?>> importedKeys) {
        for (Key<?> key : importedKeys) {
            Class<?> clazz = key.getTypeLiteral().getRawType();
            if (ParameterKeys.PROPERTIES.equals(key)) {
                this.binder.bind(ParameterKeys.PROPERTIES).toInstance(DEFAULT_PROPERTIES);
                continue;
            }
            if (Map.class == clazz) {
                this.bindMapImport(key);
                continue;
            }
            if (List.class == clazz) {
                this.bindListImport(key);
                continue;
            }
            if (ParameterKeys.ARGUMENTS.equals(key)) {
                this.binder.bind(ParameterKeys.ARGUMENTS).toInstance(DEFAULT_ARGUMENTS);
                continue;
            }
            if (ImportBinder.isRestricted(clazz)) continue;
            this.bindBeanImport(key);
        }
    }

    private void bindMapImport(Key<?> key) {
        TypeLiteral<?>[] parameters = TypeParameters.get(key.getTypeLiteral());
        if (2 == parameters.length && null == key.getAnnotation()) {
            Class<?> qualifierType = parameters[0].getRawType();
            Class<?> bindingType = parameters[1].getRawType();
            if (qualifierType == String.class) {
                this.binder.bind(key).toProvider(new NamedBeanMapProvider(bindingType));
            } else if (qualifierType.isAnnotationPresent(Qualifier.class)) {
                this.binder.bind(key).toProvider(new BeanMapProvider(Key.get(bindingType, qualifierType)));
            }
        }
    }

    private void bindListImport(Key<?> key) {
        TypeLiteral<?>[] parameters = TypeParameters.get(key.getTypeLiteral());
        if (1 == parameters.length && null == key.getAnnotation()) {
            Class<?> bindingType = parameters[0].getRawType();
            this.binder.bind(key).toProvider(new BeanListProvider(Key.get(bindingType)));
        }
    }

    private <T> void bindBeanImport(Key<T> key) {
        Annotation qualifier = key.getAnnotation();
        String name = qualifier instanceof Named ? ((Named)qualifier).value() : "CUSTOM";
        Class<T> bindingType = key.getTypeLiteral().getRawType();
        if (name.contains("${")) {
            this.binder.bind(key).toProvider((Provider<T>)new PlaceholderBeanProvider<T>(key.ofType(bindingType)));
        } else if (name.length() == 0) {
            this.binder.bind(key).toProvider((Provider<T>)new BeanProvider<T>(Key.get(bindingType, Named.class)));
        } else if (!ImportBinder.isImplicit(key)) {
            this.binder.bind(key).toProvider((Provider<T>)new BeanProvider<T>(key.ofType(bindingType)));
        }
    }

    private static boolean isRestricted(Class<?> clazz) {
        return clazz.getName().startsWith("com.google.inject");
    }

    private static boolean isImplicit(Key<?> key) {
        if (null != key.getAnnotationType()) {
            return false;
        }
        Class<?> clazz = key.getTypeLiteral().getRawType();
        if (clazz.getName().equals("org.slf4j.Logger")) {
            return true;
        }
        if (clazz.isInterface()) {
            return clazz.isAnnotationPresent(ImplementedBy.class) || clazz.isAnnotationPresent(ProvidedBy.class);
        }
        return !Modifier.isAbstract(clazz.getModifiers());
    }
}

