/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Options;

public class CreateDhcpOptions
extends BaseCmd {
    private String[] keyValuePairs;
    private Map<String, List<String>> options = new LinkedHashMap<String, List<String>>();

    public CreateDhcpOptions(String[] args) {
        super("ec2adddopt", "ec2-create-dhcp-options");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "NAME=VALUE[,VALUE...] [ NAME=VALUE[,VALUE...] ... ]";
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a set of DHCP options that you can then associate with one or more");
        System.out.println("     VPCs, causing all existing and new instances that you launch in those VPCs");
        System.out.println("     to use the set of DHCP options. The following lists the individual DHCP");
        System.out.println("     options can be specified:");
        System.out.println("");
        System.out.println("     domain-name");
        System.out.println("          A domain name of your choice.");
        System.out.println("     domain-name-servers");
        System.out.println("          The IP address of a domain name server.");
        System.out.println("     ntp-servers");
        System.out.println("          The IP address of a Network Time Protocol (NTP) server.");
        System.out.println("     netbios-name-servers");
        System.out.println("          The IP address of a NetBIOS name server.");
        System.out.println("     netbios-node-type");
        System.out.println("          Value indicating the NetBIOS node type (1, 2, 4, or 8); see RFC2132.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.createDhcpOptions(this.options);
        out.output(System.out, (DhcpOptionsDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        this.keyValuePairs = this.getNonOptions();
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NAME=VALUE");
        for (int i = 0; i < this.keyValuePairs.length; ++i) {
            String keyValuePair = this.keyValuePairs[i];
            if (keyValuePair == null || "".equals(keyValuePair)) {
                throw new GeneralError("Name-value definition must not be empty.");
            }
            int index = keyValuePair.indexOf(61);
            if (index <= 0) {
                throw new GeneralError("Key-value definition must be of the form NAME=VALUE.");
            }
            String key = keyValuePair.substring(0, index);
            List<String> values = this.options.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.options.put(key, values);
            }
            values.add(keyValuePair.substring(index + 1));
        }
    }

    public static void main(String[] args) {
        new CreateDhcpOptions(args).invoke();
    }
}

