/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import org.traccar.config.Config;
import org.traccar.config.ConfigKey;
import org.traccar.model.ExtendedModel;

public class PropertiesProvider {
    private Config config;
    private ExtendedModel extendedModel;

    public PropertiesProvider(Config config) {
        this.config = config;
    }

    public PropertiesProvider(ExtendedModel extendedModel) {
        this.extendedModel = extendedModel;
    }

    public String getString(ConfigKey<String> key) {
        if (this.config != null) {
            return this.config.getString(key);
        }
        String result = this.extendedModel.getString(key.getKey());
        return result != null ? result : key.getDefaultValue();
    }

    public int getInteger(ConfigKey<Integer> key) {
        if (this.config != null) {
            return this.config.getInteger(key);
        }
        Object result = this.extendedModel.getAttributes().get(key.getKey());
        if (result != null) {
            return result instanceof String ? Integer.parseInt((String)result) : (Integer)result;
        }
        return key.getDefaultValue();
    }

    public Boolean getBoolean(ConfigKey<Boolean> key) {
        if (this.config != null) {
            if (this.config.hasKey(key)) {
                return this.config.getBoolean(key);
            }
            return null;
        }
        Object result = this.extendedModel.getAttributes().get(key.getKey());
        if (result != null) {
            return result instanceof String ? Boolean.valueOf((String)result) : (Boolean)result;
        }
        return null;
    }
}

