/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.traccar.model.Device;
import org.traccar.model.Group;

public class GroupTree {
    private final Map<Long, TreeNode> groupMap = new HashMap<Long, TreeNode>();

    public GroupTree(Collection<Group> groups, Collection<Device> devices) {
        for (Group group : groups) {
            this.groupMap.put(group.getId(), new TreeNode(group));
        }
        for (TreeNode node : this.groupMap.values()) {
            if (node.getGroup().getGroupId() == 0L) continue;
            node.setParent(this.groupMap.get(node.getGroup().getGroupId()));
        }
        HashMap<Long, TreeNode> deviceMap = new HashMap<Long, TreeNode>();
        for (Device device : devices) {
            deviceMap.put(device.getId(), new TreeNode(device));
        }
        for (TreeNode node : deviceMap.values()) {
            if (node.getDevice().getGroupId() == 0L) continue;
            node.setParent(this.groupMap.get(node.getDevice().getGroupId()));
        }
    }

    public Collection<Group> getGroups(long groupId) {
        HashSet<TreeNode> results = new HashSet<TreeNode>();
        this.getNodes(results, this.groupMap.get(groupId));
        ArrayList<Group> groups = new ArrayList<Group>();
        for (TreeNode node : results) {
            if (node.getGroup() == null) continue;
            groups.add(node.getGroup());
        }
        return groups;
    }

    public Collection<Device> getDevices(long groupId) {
        HashSet<TreeNode> results = new HashSet<TreeNode>();
        this.getNodes(results, this.groupMap.get(groupId));
        ArrayList<Device> devices = new ArrayList<Device>();
        for (TreeNode node : results) {
            if (node.getDevice() == null) continue;
            devices.add(node.getDevice());
        }
        return devices;
    }

    private void getNodes(Set<TreeNode> results, TreeNode node) {
        if (node != null) {
            for (TreeNode child : node.getChildren()) {
                results.add(child);
                this.getNodes(results, child);
            }
        }
    }

    private static class TreeNode {
        private Group group;
        private Device device;
        private Collection<TreeNode> children = new HashSet<TreeNode>();

        TreeNode(Group group) {
            this.group = group;
        }

        TreeNode(Device device) {
            this.device = device;
        }

        public int hashCode() {
            if (this.group != null) {
                return (int)this.group.getId();
            }
            return (int)this.device.getId();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TreeNode)) {
                return false;
            }
            TreeNode other = (TreeNode)obj;
            if (other == this) {
                return true;
            }
            if (this.group != null && other.group != null) {
                return this.group.getId() == other.group.getId();
            }
            if (this.device != null && other.device != null) {
                return this.device.getId() == other.device.getId();
            }
            return false;
        }

        public Group getGroup() {
            return this.group;
        }

        public Device getDevice() {
            return this.device;
        }

        public void setParent(TreeNode parent) {
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public Collection<TreeNode> getChildren() {
            return this.children;
        }
    }
}

