/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.nio;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Internal;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ContentLengthStrategy;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpResponse;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.config.CharCodingConfig;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.config.Http1Config;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.Http1StreamListener;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestWriterFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.nio.DefaultHttpResponseParserFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public final class ClientHttp1StreamDuplexerFactory {
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final Http1StreamListener streamListener;

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, Http1StreamListener streamListener) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : new DefaultHttpResponseParserFactory(http1Config);
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, Http1StreamListener streamListener) {
        this(httpProcessor, http1Config, charCodingConfig, connectionReuseStrategy, responseParserFactory, requestWriterFactory, null, null, streamListener);
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, Http1StreamListener streamListener) {
        this(httpProcessor, http1Config, charCodingConfig, null, null, null, streamListener);
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig) {
        this(httpProcessor, http1Config, charCodingConfig, null);
    }

    public ClientHttp1StreamDuplexer create(ProtocolIOSession ioSession) {
        return new ClientHttp1StreamDuplexer(ioSession, this.httpProcessor, this.http1Config, this.charCodingConfig, this.connectionReuseStrategy, this.responseParserFactory.create(), this.requestWriterFactory.create(), this.incomingContentStrategy, this.outgoingContentStrategy, this.streamListener);
    }
}

