/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.LDAPConstants;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.vault.VaultCharSecret;

public final class LDAPContextManager
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LDAPContextManager.class);
    private final KeycloakSession session;
    private final LDAPConfig ldapConfig;
    private StartTlsResponse tlsResponse;
    private VaultCharSecret vaultCharSecret = new VaultCharSecret(){

        public Optional<CharBuffer> get() {
            return Optional.empty();
        }

        public Optional<char[]> getAsArray() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private LdapContext ldapContext;

    public LDAPContextManager(KeycloakSession session, LDAPConfig connectionProperties) {
        this.session = session;
        this.ldapConfig = connectionProperties;
    }

    public static LDAPContextManager create(KeycloakSession session, LDAPConfig connectionProperties) {
        return new LDAPContextManager(session, connectionProperties);
    }

    private void createLdapContext() throws NamingException {
        LDAPUtils.setLDAPHostnameToKeycloakSession(this.session, this.ldapConfig);
        Hashtable<Object, Object> connProp = this.getConnectionProperties(this.ldapConfig);
        if (!"none".equals(this.ldapConfig.getAuthType())) {
            this.vaultCharSecret = this.getVaultSecret();
            if (this.vaultCharSecret != null && !this.ldapConfig.isStartTls()) {
                connProp.put("java.naming.security.credentials", this.vaultCharSecret.getAsArray().orElse(this.ldapConfig.getBindCredential() != null ? this.ldapConfig.getBindCredential().toCharArray() : null));
            }
        }
        this.ldapContext = new InitialLdapContext(connProp, null);
        if (this.ldapConfig.isStartTls()) {
            SSLSocketFactory sslSocketFactory = null;
            String useTruststoreSpi = this.ldapConfig.getUseTruststoreSpi();
            if (useTruststoreSpi != null && useTruststoreSpi.equals("always")) {
                TruststoreProvider provider = (TruststoreProvider)this.session.getProvider(TruststoreProvider.class);
                sslSocketFactory = provider.getSSLSocketFactory();
            }
            this.tlsResponse = LDAPContextManager.startTLS(this.ldapContext, this.ldapConfig.getAuthType(), this.ldapConfig.getBindDN(), this.vaultCharSecret.getAsArray().orElse(this.ldapConfig.getBindCredential() != null ? this.ldapConfig.getBindCredential().toCharArray() : null), sslSocketFactory);
            if (this.tlsResponse == null) {
                throw new NamingException("Wasn't able to establish LDAP connection through StartTLS");
            }
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        if (this.ldapContext == null) {
            this.createLdapContext();
        }
        return this.ldapContext;
    }

    private VaultCharSecret getVaultSecret() {
        return "none".equals(this.ldapConfig.getAuthType()) ? null : this.session.vault().getCharSecret(this.ldapConfig.getBindCredential());
    }

    public static StartTlsResponse startTLS(LdapContext ldapContext, String authType, String bindDN, char[] bindCredential, SSLSocketFactory sslSocketFactory) throws NamingException {
        StartTlsResponse tls = null;
        try {
            tls = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            tls.negotiate(sslSocketFactory);
            ldapContext.addToEnvironment("java.naming.security.authentication", authType);
            if (!"none".equals(authType)) {
                ldapContext.addToEnvironment("java.naming.security.principal", bindDN);
                ldapContext.addToEnvironment("java.naming.security.credentials", bindCredential);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not negotiate TLS", (Throwable)e);
            throw new AuthenticationException("Could not negotiate TLS");
        }
        ldapContext.lookup("");
        return tls;
    }

    private Hashtable<Object, Object> getConnectionProperties(LDAPConfig ldapConfig) {
        Hashtable<Object, Object> env = LDAPContextManager.getNonAuthConnectionProperties(ldapConfig);
        if (!ldapConfig.isStartTls()) {
            String authType = ldapConfig.getAuthType();
            env.put("java.naming.security.authentication", authType);
            String bindDN = ldapConfig.getBindDN();
            char[] bindCredential = null;
            if (ldapConfig.getBindCredential() != null) {
                bindCredential = ldapConfig.getBindCredential().toCharArray();
            }
            if (!"none".equals(authType)) {
                env.put("java.naming.security.principal", bindDN);
                env.put("java.naming.security.credentials", bindCredential);
            }
        }
        if (logger.isDebugEnabled()) {
            Hashtable<Object, Object> copyEnv = new Hashtable<Object, Object>(env);
            if (copyEnv.containsKey("java.naming.security.credentials")) {
                copyEnv.put("java.naming.security.credentials", "**************************************");
            }
            logger.debugf("Creating LdapContext using properties: [%s]", copyEnv);
        }
        return env;
    }

    public static Hashtable<Object, Object> getNonAuthConnectionProperties(LDAPConfig ldapConfig) {
        Properties additionalProperties;
        String readTimeout;
        String connectionTimeout;
        String connectionPooling;
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", ldapConfig.getFactoryName());
        String url = ldapConfig.getConnectionUrl();
        if (url != null) {
            env.put("java.naming.provider.url", url);
        } else {
            logger.warn((Object)"LDAP URL is null. LDAPOperationManager won't work correctly");
        }
        if (!ldapConfig.isStartTls()) {
            String useTruststoreSpi = ldapConfig.getUseTruststoreSpi();
            LDAPConstants.setTruststoreSpiIfNeeded((String)useTruststoreSpi, (String)url, env);
        }
        if ((connectionPooling = ldapConfig.getConnectionPooling()) != null) {
            env.put("com.sun.jndi.ldap.connect.pool", connectionPooling);
        }
        if ((connectionTimeout = ldapConfig.getConnectionTimeout()) != null && !connectionTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
        }
        if ((readTimeout = ldapConfig.getReadTimeout()) != null && !readTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        }
        if ((additionalProperties = ldapConfig.getAdditionalConnectionProperties()) != null) {
            for (Object object : additionalProperties.keySet()) {
                env.put(object.toString(), additionalProperties.getProperty(object.toString()));
            }
        }
        StringBuilder binaryAttrsBuilder = new StringBuilder();
        if (ldapConfig.isObjectGUID()) {
            binaryAttrsBuilder.append("objectGUID").append(" ");
        }
        if (ldapConfig.isEdirectory()) {
            binaryAttrsBuilder.append("guid").append(" ");
        }
        for (String attrName : ldapConfig.getBinaryAttributeNames()) {
            binaryAttrsBuilder.append(attrName).append(" ");
        }
        String string = binaryAttrsBuilder.toString().trim();
        if (!string.isEmpty()) {
            env.put("java.naming.ldap.attributes.binary", string);
        }
        return new Hashtable<Object, Object>(env);
    }

    @Override
    public void close() {
        if (this.vaultCharSecret != null) {
            this.vaultCharSecret.close();
        }
        if (this.tlsResponse != null) {
            try {
                this.tlsResponse.close();
            }
            catch (IOException e) {
                logger.error((Object)"Could not close Ldap tlsResponse.", (Throwable)e);
            }
        }
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Could not close Ldap context.", (Throwable)e);
            }
        }
    }
}

