/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CSocketOutputStreamWrapper
extends NetOutputStream {
    private static final int MAX_BUFFER_SIZE = 2048;
    private NetOutputStream os = null;
    private byte[] buffer = new byte[2048];
    int bIndex = 0;
    private final SessionAtts session;

    T4CSocketOutputStreamWrapper(NetOutputStream netOutputStream, SessionAtts sessionAtts) throws IOException {
        this.os = netOutputStream;
        this.session = sessionAtts;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.bIndex + 1 >= 2048) {
            this.flush();
        }
        this.buffer[this.bIndex++] = (byte)(n2 & 0xFF);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            if (n3 > 2048) {
                this.flush();
                this.os.write(byArray, n2, n3);
            } else if (this.bIndex + n3 < 2048) {
                System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
                this.bIndex += n3;
            } else {
                this.flush();
                System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
                this.bIndex += n3;
            }
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean bl) throws IOException {
        try {
            if (this.bIndex > 0) {
                this.os.write(this.buffer, 0, this.bIndex);
                this.bIndex = 0;
            }
            if (bl) {
                this.os.flush();
            }
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.os.close();
            super.close();
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        this.flush(true);
        try {
            this.os.writeZeroCopyIO(byArray, n2, n3);
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }

    @Override
    public void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        if (bl) {
            this.flush(true);
        }
        try {
            this.os.writeZeroCopyIOHeader(bl, n2, bl2);
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }

    @Override
    public void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.os.writeZeroCopyIOData(byArray, n2, n3);
        }
        catch (NetException netException) {
            netException.setNetConnectionId(this.session.getNetConnectionId());
            throw netException;
        }
    }
}

