/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.JarResult;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.remote.DefaultRemoteDevClient;
import io.quarkus.deployment.dev.remote.RemoteDevClient;
import io.quarkus.deployment.dev.remote.RemoteDevClientProvider;
import io.quarkus.deployment.mutability.DevModeTask;
import io.quarkus.deployment.steps.ClassTransformingBuildStep;
import io.quarkus.dev.spi.DeploymentFailedStartHandler;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.dev.spi.RemoteDevState;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import io.quarkus.runtime.util.HashUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class IsolatedRemoteDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger(IsolatedRemoteDevModeMain.class);
    private volatile DevModeContext context;
    private final List<HotReplacementSetup> hotReplacementSetups = new ArrayList<HotReplacementSetup>();
    static volatile Throwable deploymentProblem;
    static volatile RemoteDevClient remoteDevClient;
    static volatile Closeable remoteDevClientSession;
    private static volatile CuratedApplication curatedApplication;
    private static volatile AugmentAction augmentAction;
    private static volatile Map<String, String> currentHashes;
    private static volatile Path appRoot;
    private static volatile Map<DevModeContext.ModuleInfo, Set<String>> copiedStaticResources;

    static RemoteDevClient createClient(CuratedApplication curatedApplication) {
        ServiceLoader<RemoteDevClientProvider> providers = ServiceLoader.load(RemoteDevClientProvider.class, (ClassLoader)curatedApplication.getAugmentClassLoader());
        RemoteDevClient client = null;
        for (RemoteDevClientProvider provider : providers) {
            Optional<RemoteDevClient> opt = provider.getClient();
            if (!opt.isPresent()) continue;
            client = opt.get();
            break;
        }
        if (client == null) {
            client = new DefaultRemoteDevClient();
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JarResult generateApplication() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            AugmentResult start = augmentAction.createProductionApplication();
            if (!start.getJar().getType().equalsIgnoreCase("mutable-jar")) {
                throw new RuntimeException("remote-dev can only be used with mutable applications generated with the fast-jar format");
            }
            DevModeTask.extractDevModeClasses(start.getJar().getPath().getParent(), curatedApplication.getApplicationModel(), null);
            JarResult jarResult = start.getJar();
            return jarResult;
        }
        catch (Throwable t) {
            deploymentProblem = t;
            log.error((Object)"Failed to generate Quarkus application", t);
            JarResult jarResult = null;
            return jarResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context, Path applicationRoot) throws Exception {
        if (!context.getAllModules().isEmpty()) {
            QuarkusCompiler compiler;
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getAllModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            try {
                compiler = new QuarkusCompiler(curatedApplication, compilationProviders, context);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                return null;
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(applicationRoot, context, compiler, DevModeType.REMOTE_LOCAL_SIDE, this::regenerateApplication, new BiConsumer<DevModeContext.ModuleInfo, String>(){

                @Override
                public void accept(DevModeContext.ModuleInfo moduleInfo, String s) {
                    copiedStaticResources.computeIfAbsent(moduleInfo, ss -> new HashSet()).add(s);
                }
            }, new BiFunction<String, byte[], byte[]>(){

                @Override
                public byte[] apply(String s, byte[] bytes) {
                    return ClassTransformingBuildStep.transform(s, bytes);
                }
            }, null);
            for (HotReplacementSetup hotReplacementSetup : ServiceLoader.load(HotReplacementSetup.class, (ClassLoader)curatedApplication.getBaseRuntimeClassLoader())) {
                this.hotReplacementSetups.add(hotReplacementSetup);
                hotReplacementSetup.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(hotReplacementSetup);
            }
            for (final DeploymentFailedStartHandler deploymentFailedStartHandler : ServiceLoader.load(DeploymentFailedStartHandler.class, (ClassLoader)curatedApplication.getAugmentClassLoader())) {
                processor.addDeploymentFailedStartHandler(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)curatedApplication.getAugmentClassLoader());
                            deploymentFailedStartHandler.handleFailedInitialStart();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                    }
                });
            }
            return processor;
        }
        return null;
    }

    void regenerateApplication(Set<String> ignore, ClassScanResult ignore2) {
        this.generateApplication();
    }

    @Override
    public void close() {
        try {
            try {
                RuntimeUpdatesProcessor.INSTANCE.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close compiler", (Throwable)e);
            }
            for (HotReplacementSetup i : this.hotReplacementSetups) {
                i.close();
            }
            if (remoteDevClientSession != null) {
                try {
                    remoteDevClientSession.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close client", (Throwable)e);
                }
            }
        }
        finally {
            curatedApplication.close();
        }
    }

    @Override
    public void accept(CuratedApplication o, Map<String, Object> o2) {
        LoggingSetupRecorder.handleFailedStart();
        Timing.staticInitStarted((ClassLoader)o.getBaseRuntimeClassLoader(), (boolean)false);
        try {
            JarResult result;
            curatedApplication = o;
            Object potentialContext = o2.get(DevModeContext.class.getName());
            if (potentialContext instanceof DevModeContext) {
                this.context = (DevModeContext)potentialContext;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(potentialContext);
                this.context = (DevModeContext)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            augmentAction = new AugmentActionImpl(curatedApplication);
            RuntimeUpdatesProcessor.INSTANCE = this.setupRuntimeCompilation(this.context, appRoot);
            if (RuntimeUpdatesProcessor.INSTANCE != null) {
                RuntimeUpdatesProcessor.INSTANCE.checkForFileChange();
                RuntimeUpdatesProcessor.INSTANCE.checkForChangedClasses(true);
            }
            if ((result = this.generateApplication()) != null) {
                appRoot = result.getPath().getParent();
                currentHashes = IsolatedRemoteDevModeMain.createHashes(appRoot);
            }
            remoteDevClient = IsolatedRemoteDevModeMain.createClient(curatedApplication);
            remoteDevClientSession = this.doConnect();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<DevModeMain> clazz = DevModeMain.class;
                    synchronized (DevModeMain.class) {
                        try {
                            IsolatedRemoteDevModeMain.this.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }, "Quarkus Shutdown Thread"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Closeable doConnect() {
        return remoteDevClient.sendConnectRequest(new RemoteDevState(currentHashes, deploymentProblem), new Function<Set<String>, Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> apply(Set<String> fileNames) {
                HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
                for (String i : fileNames) {
                    try {
                        Path resolvedPath = appRoot.resolve(i);
                        if (Files.isDirectory(resolvedPath, new LinkOption[0])) continue;
                        ret.put(i, Files.readAllBytes(resolvedPath));
                    }
                    catch (IOException e) {
                        log.error((Object)("Failed to read file " + i), (Throwable)e);
                    }
                }
                return ret;
            }
        }, new Supplier<RemoteDevClient.SyncResult>(){

            @Override
            public RemoteDevClient.SyncResult get() {
                return IsolatedRemoteDevModeMain.this.runSync();
            }
        });
    }

    private RemoteDevClient.SyncResult runSync() {
        final HashSet<String> removed = new HashSet<String>();
        final HashMap<String, byte[]> changed = new HashMap<String, byte[]>();
        try {
            boolean scanResult = RuntimeUpdatesProcessor.INSTANCE.doScan(true);
            if (!scanResult && !copiedStaticResources.isEmpty()) {
                scanResult = true;
                this.regenerateApplication(Collections.emptySet(), new ClassScanResult());
            }
            copiedStaticResources.clear();
            if (scanResult) {
                Map<String, String> newHashes = IsolatedRemoteDevModeMain.createHashes(appRoot);
                HashSet<String> allKeys = new HashSet<String>(newHashes.keySet());
                allKeys.addAll(currentHashes.keySet());
                for (String key : allKeys) {
                    String newHash = newHashes.get(key);
                    String oldHash = currentHashes.get(key);
                    if (newHash == null) {
                        removed.add(key);
                        continue;
                    }
                    if (Objects.equals(newHash, oldHash)) continue;
                    changed.put(key, Files.readAllBytes(appRoot.resolve(key)));
                }
                currentHashes = newHashes;
            }
        }
        catch (IOException e) {
            deploymentProblem = e;
        }
        return new RemoteDevClient.SyncResult(){

            @Override
            public Map<String, byte[]> getChangedFiles() {
                return changed;
            }

            @Override
            public Set<String> getRemovedFiles() {
                return removed;
            }

            @Override
            public Throwable getProblem() {
                return RuntimeUpdatesProcessor.INSTANCE.getDeploymentProblem();
            }
        };
    }

    static Map<String, String> createHashes(final Path appRoot) throws IOException {
        final Path quarkus = appRoot.resolve("quarkus");
        final HashMap<String, String> hashes = new HashMap<String, String>();
        Files.walkFileTree(appRoot, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(quarkus)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                hashes.put(appRoot.relativize(file).toString().replace('\\', '/'), HashUtil.sha1((byte[])Files.readAllBytes(file)));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return hashes;
    }

    static {
        copiedStaticResources = new HashMap<DevModeContext.ModuleInfo, Set<String>>();
    }
}

