/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import com.aayushatharva.brotli4j.encoder.PreparedDictionary;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class Encoder {
    final ByteBuffer inputBuffer;
    private final WritableByteChannel destination;
    private final List<PreparedDictionary> dictionaries;
    private final EncoderJNI.Wrapper encoder;
    boolean closed;
    private ByteBuffer buffer;

    Encoder(WritableByteChannel destination, Parameters params, int inputBufferSize) throws IOException {
        if (inputBufferSize <= 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        if (destination == null) {
            throw new NullPointerException("destination can not be null");
        }
        this.dictionaries = new ArrayList<PreparedDictionary>();
        this.destination = destination;
        this.encoder = new EncoderJNI.Wrapper(inputBufferSize, params.quality, params.lgwin, params.mode);
        this.inputBuffer = this.encoder.getInputBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] data, Parameters params) throws IOException {
        if (data.length == 0) {
            byte[] empty = new byte[]{6};
            return empty;
        }
        EncoderJNI.Wrapper encoder = new EncoderJNI.Wrapper(data.length, params.quality, params.lgwin, params.mode);
        ArrayList<byte[]> output = new ArrayList<byte[]>();
        int totalOutputSize = 0;
        try {
            encoder.getInputBuffer().put(data);
            encoder.push(EncoderJNI.Operation.FINISH, data.length);
            while (true) {
                if (!encoder.isSuccess()) {
                    throw new IOException("encoding failed");
                }
                if (encoder.hasMoreOutput()) {
                    ByteBuffer buffer = encoder.pull();
                    byte[] chunk = new byte[buffer.remaining()];
                    buffer.get(chunk);
                    output.add(chunk);
                    totalOutputSize += chunk.length;
                    continue;
                }
                if (!encoder.isFinished()) {
                    encoder.push(EncoderJNI.Operation.FINISH, 0);
                    continue;
                }
                break;
            }
        }
        finally {
            encoder.destroy();
        }
        if (output.size() == 1) {
            return (byte[])output.get(0);
        }
        byte[] result = new byte[totalOutputSize];
        int offset = 0;
        for (byte[] chunk : output) {
            System.arraycopy(chunk, 0, result, offset, chunk.length);
            offset += chunk.length;
        }
        return result;
    }

    public static byte[] compress(byte[] data) throws IOException {
        return Encoder.compress(data, Parameters.DEFAULT);
    }

    public static PreparedDictionary prepareDictionary(ByteBuffer dictionary, int sharedDictionaryType) {
        return EncoderJNI.prepareDictionary(dictionary, sharedDictionaryType);
    }

    private void fail(String message) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IOException(message);
    }

    public void attachDictionary(PreparedDictionary dictionary) throws IOException {
        if (!this.encoder.attachDictionary(dictionary.getData())) {
            this.fail("failed to attach dictionary");
        }
        this.dictionaries.add(dictionary);
    }

    boolean pushOutput(boolean force) throws IOException {
        while (this.buffer != null) {
            if (this.buffer.hasRemaining()) {
                this.destination.write(this.buffer);
            }
            if (!this.buffer.hasRemaining()) {
                this.buffer = null;
                continue;
            }
            if (force) continue;
            return false;
        }
        return true;
    }

    boolean encode(EncoderJNI.Operation op) throws IOException {
        boolean force;
        boolean bl = force = op != EncoderJNI.Operation.PROCESS;
        if (force) {
            ((Buffer)this.inputBuffer).limit(this.inputBuffer.position());
        } else if (this.inputBuffer.hasRemaining()) {
            return true;
        }
        boolean hasInput = true;
        while (true) {
            if (!this.encoder.isSuccess()) {
                this.fail("encoding failed");
                continue;
            }
            if (!this.pushOutput(force)) {
                return false;
            }
            if (this.encoder.hasMoreOutput()) {
                this.buffer = this.encoder.pull();
                continue;
            }
            if (this.encoder.hasRemainingInput()) {
                this.encoder.push(op, 0);
                continue;
            }
            if (!hasInput) break;
            this.encoder.push(op, this.inputBuffer.limit());
            hasInput = false;
        }
        ((Buffer)this.inputBuffer).clear();
        return true;
    }

    void flush() throws IOException {
        this.encode(EncoderJNI.Operation.FLUSH);
    }

    void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.encode(EncoderJNI.Operation.FINISH);
        }
        finally {
            this.encoder.destroy();
            this.destination.close();
        }
    }

    public static final class Parameters {
        public static final Parameters DEFAULT = new Parameters();
        private int quality = -1;
        private int lgwin = -1;
        private Mode mode;

        public Parameters() {
        }

        private Parameters(Parameters other) {
            this.quality = other.quality;
            this.lgwin = other.lgwin;
            this.mode = other.mode;
        }

        public Parameters setQuality(int quality) {
            if (quality < -1 || quality > 11) {
                throw new IllegalArgumentException("quality should be in range [0, 11], or -1");
            }
            this.quality = quality;
            return this;
        }

        public Parameters setWindow(int lgwin) {
            if (lgwin != -1 && (lgwin < 10 || lgwin > 24)) {
                throw new IllegalArgumentException("lgwin should be in range [10, 24], or -1");
            }
            this.lgwin = lgwin;
            return this;
        }

        public Parameters setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public int quality() {
            return this.quality;
        }

        public int lgwin() {
            return this.lgwin;
        }

        public Mode mode() {
            return this.mode;
        }
    }

    public static enum Mode {
        GENERIC,
        TEXT,
        FONT;


        public static Mode of(int value) {
            return Mode.values()[value];
        }
    }
}

