/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.Type;

public class ArrayExpression
extends AbstractLineNumberTypeExpression {
    protected Expression expression;
    protected Expression index;

    public ArrayExpression(Expression expression, Expression index) {
        super(ArrayExpression.createItemType(expression));
        this.expression = expression;
        this.index = index;
    }

    public ArrayExpression(int lineNumber, Expression expression, Expression index) {
        super(lineNumber, ArrayExpression.createItemType(expression));
        this.expression = expression;
        this.index = index;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getIndex() {
        return this.index;
    }

    public void setIndex(Expression index) {
        this.index = index;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    protected static Type createItemType(Expression expression) {
        Type type;
        int dimension = (type = expression.getType()).getDimension();
        return type.createType(dimension > 0 ? dimension - 1 : 0);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "ArrayExpression{" + this.expression + "[" + this.index + "]}";
    }
}

