/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

class IntroductionManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final PacketBuilder2 _builder2;
    private final Map<Long, PeerState> _outbound;
    private final Map<Long, PeerState> _inbound;
    private final Set<InetAddress> _recentHolePunches;
    private long _lastHolePunchClean;
    private static final int MAX_INBOUND = 20;
    public static final int MAX_OUTBOUND = 100;
    private static final long PUNCH_CLEAN_TIME = 5000L;
    private static final int MAX_PUNCHES = 20;
    private static final long INTRODUCER_EXPIRATION = 4800000L;
    private static final String MIN_IPV6_INTRODUCER_VERSION = "0.9.50";

    public IntroductionManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(IntroductionManager.class);
        this._transport = transport;
        this._builder = transport.getBuilder();
        this._builder2 = transport.getBuilder2();
        this._outbound = new ConcurrentHashMap<Long, PeerState>(100);
        this._inbound = new ConcurrentHashMap<Long, PeerState>(20);
        this._recentHolePunches = new HashSet<InetAddress>(16);
        ctx.statManager().createRateStat("udp.receiveRelayIntro", "How often we get a relayed request for us to talk to someone?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequest", "How often we receive a good request to relay to someone else?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequestBadTag", "Received relay requests with bad/expired tag", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.relayBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
    }

    public void reset() {
        this._inbound.clear();
        this._outbound.clear();
    }

    public void add(PeerState peer) {
        long id2;
        boolean added;
        if (peer == null) {
            return;
        }
        if (peer.getVersion() != 1) {
            return;
        }
        if (!TransportUtil.isValidPort(peer.getRemotePort())) {
            return;
        }
        long id = peer.getWeRelayToThemAs();
        boolean bl = added = id > 0L;
        if (added) {
            this._outbound.put(id, peer);
        }
        if ((id2 = peer.getTheyRelayToUsAs()) > 0L && this._inbound.size() < 20) {
            added = true;
            this._inbound.put(id2, peer);
        }
        if (added && this._log.shouldLog(10)) {
            this._log.debug("adding peer " + peer.getRemotePeer() + ' ' + peer.getRemoteHostId() + ", weRelayToThemAs " + id + ", theyRelayToUsAs " + id2);
        }
    }

    public void remove(PeerState peer) {
        long id2;
        if (peer == null) {
            return;
        }
        long id = peer.getWeRelayToThemAs();
        if (id > 0L) {
            this._outbound.remove(id);
        }
        if ((id2 = peer.getTheyRelayToUsAs()) > 0L) {
            this._inbound.remove(id2);
        }
        if ((id > 0L || id2 > 0L) && this._log.shouldLog(10)) {
            this._log.debug("removing peer " + peer.getRemotePeer() + ' ' + peer.getRemoteHostId() + ", weRelayToThemAs " + id + ", theyRelayToUsAs " + id2);
        }
    }

    public boolean isInboundTagValid(long tag) {
        return this._inbound.containsKey(tag);
    }

    private PeerState get(long id) {
        return this._outbound.get(id);
    }

    public int pickInbound(RouterAddress current, boolean ipv6, Properties ssuOptions, int howMany) {
        int i;
        int start = this._context.random().nextInt();
        if (this._log.shouldLog(10)) {
            this._log.debug("Picking inbound out of " + this._inbound.size());
        }
        if (this._inbound.isEmpty()) {
            return 0;
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._inbound.values());
        int sz = peers.size();
        start %= sz;
        int found = 0;
        long now = this._context.clock().now();
        long inactivityCutoff = now - 600000L;
        if (sz <= howMany + 2) {
            inactivityCutoff -= 300000L;
        }
        ArrayList<Introducer> introducers = new ArrayList<Introducer>(howMany);
        String exp = Long.toString((now + 4800000L) / 1000L);
        if (current != null) {
            UDPAddress ua = new UDPAddress(current);
            for (int i2 = 0; i2 < ua.getIntroducerCount(); ++i2) {
                long tag;
                long lexp = ua.getIntroducerExpiration(i2);
                if (lexp > 0L && lexp < now + 1200000L || !this.isInboundTagValid(tag = ua.getIntroducerTag(i2))) continue;
                introducers.add(new Introducer(ua.getIntroducerHost(i2).getAddress(), ua.getIntroducerPort(i2), ua.getIntroducerKey(i2), tag, Long.toString(ua.getIntroducerExpiration(i2) / 1000L)));
                if (this._log.shouldInfo()) {
                    this._log.info("Reusing introducer: " + ua.getIntroducerHost(i2));
                }
                ++found;
            }
        }
        for (i = 0; i < sz && found < howMany; ++i) {
            PeerState cur = (PeerState)peers.get((start + i) % sz);
            if (cur.isIPv6() != ipv6) continue;
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(cur.getRemotePeer());
            if (ri == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no local routerInfo: " + cur);
                continue;
            }
            List<RouterAddress> ras = this._transport.getTargetAddresses(ri);
            if (ras.isEmpty()) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no SSU address: " + ri);
                continue;
            }
            if (this._context.banlist().isBanlisted(cur.getRemotePeer()) || this._transport.wasUnreachable(cur.getRemotePeer())) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is failing, blocklisted or was unreachable: " + cur);
                continue;
            }
            if (cur.getLastReceiveTime() < inactivityCutoff && cur.getLastSendTime() < inactivityCutoff) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is idle too long: " + cur);
                continue;
            }
            int oldFound = found;
            block4: for (RouterAddress ra : ras) {
                String host;
                byte[] ip = ra.getIP();
                if (ip == null) continue;
                String string = host = ip.length == 4 ? ra.getHost() : Addresses.toString(ip);
                if (host == null) continue;
                for (Introducer intro : introducers) {
                    if (!host.equals(intro.sip)) continue;
                    continue block4;
                }
                int port = ra.getPort();
                if (!this.isValid(ip, port, true)) continue;
                if ((!ipv6 && ip.length == 16 || ipv6 && ip.length == 4) && VersionComparator.comp(ri.getVersion(), MIN_IPV6_INTRODUCER_VERSION) < 0) {
                    if (!this._log.shouldLog(20)) continue;
                    this._log.info("IPv6 intro. for IPv4 or IPv4 intro for IPv6 but he doesn't support it: " + cur);
                    continue;
                }
                cur.setIntroducerTime();
                UDPAddress ura = new UDPAddress(ra);
                byte[] ikey = ura.getIntroKey();
                if (ikey == null) continue;
                introducers.add(new Introducer(ip, port, ikey, cur.getTheyRelayToUsAs(), exp));
                if (++found - oldFound < 2) continue;
                break;
            }
            if (oldFound == found || !this._log.shouldLog(20)) continue;
            this._log.info("Picking introducer: " + cur);
        }
        Collections.sort(introducers);
        for (i = 0; i < found; ++i) {
            Introducer in = (Introducer)introducers.get(i);
            ssuOptions.setProperty("ihost" + i, in.sip);
            ssuOptions.setProperty("iport" + i, in.sport);
            ssuOptions.setProperty("ikey" + i, in.skey);
            ssuOptions.setProperty("itag" + i, in.stag);
            String sexp = in.sexp;
            if (current != null) {
                for (int j = 0; j < 3; ++j) {
                    if (!in.sip.equals(current.getOption("ihost" + j)) || !in.sport.equals(current.getOption("iport" + j)) || !in.skey.equals(current.getOption("ikey" + j)) || !in.stag.equals(current.getOption("itag" + j))) continue;
                    String oexp = current.getOption("iexp" + j);
                    if (oexp == null) break;
                    try {
                        long oex = Long.parseLong(oexp) * 1000L;
                        if (oex <= now + 1200000L) break;
                        sexp = oexp;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            ssuOptions.setProperty("iexp" + i, sexp);
        }
        this.pingIntroducers();
        return found;
    }

    public void pingIntroducers() {
        long now = this._context.clock().now();
        long pingCutoff = now - 6300000L;
        long inactivityCutoff = now - 165000L;
        for (PeerState cur : this._inbound.values()) {
            if (cur.getIntroducerTime() <= pingCutoff || cur.getLastSendTime() >= inactivityCutoff) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Pinging introducer: " + cur);
            }
            cur.setLastSendTime(now);
            UDPPacket ping = cur.getVersion() == 2 ? this._builder2.buildPing((PeerState2)cur) : this._builder.buildPing(cur);
            this._transport.send(ping);
        }
    }

    int introducerCount(boolean ipv6) {
        int rv = 0;
        for (PeerState ps : this._inbound.values()) {
            if (ps.isIPv6() != ipv6) continue;
            ++rv;
        }
        return rv;
    }

    int introducedCount() {
        return this._outbound.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayIntro(RemoteHostId bob, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        this._context.statManager().addRateData("udp.receiveRelayIntro", 1L);
        if (!this._transport.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping RelayIntro, over conn limit");
            }
            return;
        }
        int ipSize = reader.getRelayIntroReader().readIPSize();
        byte[] ip = new byte[ipSize];
        reader.getRelayIntroReader().readIP(ip, 0);
        int port = reader.getRelayIntroReader().readPort();
        if (!this.isValid(ip, port, true) || !this.isValid(bob.getIP(), bob.getPort(), true)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad relay intro from " + bob + " for " + Addresses.toString(ip, port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay intro from " + bob + " for " + Addresses.toString(ip, port));
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IP for alice to hole punch to is invalid", uhe);
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        RemoteHostId alice = new RemoteHostId(ip, port);
        if (this._transport.getPeerState(alice) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring RelayIntro, already have a session to " + to);
            }
            return;
        }
        EstablishmentManager establisher = this._transport.getEstablisher();
        if (establisher != null) {
            if (establisher.getInboundState(alice) != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Ignoring RelayIntro, establishment in progress to " + to);
                }
                return;
            }
            if (!establisher.shouldAllowInboundEstablishment()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping RelayIntro, too many establishments in progress - for " + to);
                }
                return;
            }
        }
        boolean tooMany = false;
        boolean already = false;
        Set<InetAddress> set = this._recentHolePunches;
        synchronized (set) {
            long now = this._context.clock().now();
            if (now > this._lastHolePunchClean + 5000L) {
                this._recentHolePunches.clear();
                this._lastHolePunchClean = now;
                this._recentHolePunches.add(to);
            } else {
                boolean bl = tooMany = this._recentHolePunches.size() >= 20;
                if (!tooMany) {
                    already = !this._recentHolePunches.add(to);
                }
            }
        }
        if (tooMany) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping - too many - RelayIntro for " + to);
            }
            return;
        }
        if (already) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring dup RelayIntro for " + to);
            }
            return;
        }
        this._transport.send(this._builder.buildHolePunch(to, port));
    }

    void receiveRelayRequest(RemoteHostId alice, UDPPacketReader reader) {
        RemoteHostId aliceRelayID;
        boolean ipIncluded;
        if (this._context.router().isHidden()) {
            return;
        }
        UDPPacketReader.RelayRequestReader rrReader = reader.getRelayRequestReader();
        long tag = rrReader.readTag();
        int ipSize = rrReader.readIPSize();
        int port = rrReader.readPort();
        byte[] aliceIP = alice.getIP();
        int alicePort = alice.getPort();
        boolean bl = ipIncluded = ipSize != 0;
        if (!this.isValid(aliceIP, alicePort, true)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Rejecting relay req from " + alice + " for " + Addresses.toString(aliceIP, alicePort));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        if (ipIncluded) {
            byte[] ip = new byte[ipSize];
            rrReader.readIP(ip, 0);
            if (ipSize == aliceIP.length && !Arrays.equals(aliceIP, ip)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(ip, port));
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                return;
            }
            aliceIP = ip;
        }
        if (port != 0) {
            if (ipIncluded) {
                alicePort = port;
            } else if (port != alicePort) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(aliceIP, port));
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
            }
            return;
        }
        if (ipIncluded) {
            if (!this.isValid(aliceIP, alicePort, true)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(aliceIP, alicePort));
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                return;
            }
            aliceRelayID = new RemoteHostId(aliceIP, alicePort);
        } else {
            aliceRelayID = alice;
        }
        PeerState charlie = this.get(tag);
        if (charlie == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Receive relay request from " + alice + " with unknown tag " + tag);
            }
            this._context.statManager().addRateData("udp.receiveRelayRequestBadTag", 1L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay request from " + alice + " for tag " + tag + " and relaying with " + charlie);
        }
        this._context.statManager().addRateData("udp.receiveRelayRequest", 1L);
        this._transport.send(this._builder.buildRelayIntro(aliceRelayID, charlie, rrReader));
        SessionKey cipherKey = null;
        SessionKey macKey = null;
        PeerState aliceState = this._transport.getPeerState(alice);
        if (aliceState != null) {
            cipherKey = aliceState.getCurrentCipherKey();
            macKey = aliceState.getCurrentMACKey();
        }
        if (cipherKey == null || macKey == null) {
            byte[] key = new byte[32];
            reader.getRelayRequestReader().readAliceIntroKey(key, 0);
            macKey = cipherKey = new SessionKey(key);
            if (this._log.shouldLog(20)) {
                this._log.info("Sending relay response (w/ intro key) to " + alice);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Sending relay response (in-session) to " + alice);
        }
        this._transport.send(this._builder.buildRelayResponse(alice, charlie, rrReader.readNonce(), cipherKey, macKey));
    }

    private boolean isValid(byte[] ip, int port, boolean allowIPv6) {
        return TransportUtil.isValidPort(port) && ip != null && (ip.length == 4 || allowIPv6 && ip.length == 16) && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    private static class Introducer
    implements Comparable<Introducer> {
        public final String sip;
        public final String sport;
        public final String skey;
        public final String stag;
        public final String sexp;

        public Introducer(byte[] ip, int port, byte[] key, long tag, String exp) {
            this.sip = Addresses.toString(ip);
            this.sport = String.valueOf(port);
            this.skey = Base64.encode(key);
            this.stag = String.valueOf(tag);
            this.sexp = exp;
        }

        @Override
        public int compareTo(Introducer i) {
            return this.skey.compareTo(i.skey);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Introducer)) {
                return false;
            }
            Introducer i = (Introducer)o;
            return this.compareTo(i) == 0;
        }

        public int hashCode() {
            return this.skey.hashCode();
        }
    }
}

