/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.CompoundEditEvent;
import ca.sqlpower.architect.olap.CompoundEditListener;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.TransactionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OLAPObject
extends AbstractSPObject {
    private static final Logger logger = Logger.getLogger(OLAPObject.class);
    private int compoundEditDepth = 0;
    private final List<CompoundEditListener> compoundEditListeners = new ArrayList<CompoundEditListener>();

    protected OLAPObject() {
    }

    public void addChild(SPObject child) {
        this.addChild(child, this.getChildren(child.getClass()).size());
    }

    protected OLAPObject(OLAPObject original) {
        this.setParent(original.getParent());
    }

    public int childPositionOffset(Class<? extends SPObject> childType) {
        throw new IllegalArgumentException("Invalid child type " + childType);
    }

    protected void addChildImpl(SPObject child, int index) {
        throw new IllegalArgumentException("Cannot add child " + child);
    }

    protected boolean removeChildImpl(SPObject child) {
        throw new IllegalArgumentException("Cannot remove child " + child);
    }

    public void addCompoundEditListener(CompoundEditListener listener) {
        this.compoundEditListeners.add(listener);
    }

    public void removeCompoundEditListener(CompoundEditListener listener) {
        this.compoundEditListeners.remove(listener);
    }

    protected TransactionEvent fireTransactionStarted(String message) {
        ++this.compoundEditDepth;
        logger.debug((Object)("Compound edit on " + ((Object)((Object)this)).getClass().getSimpleName() + " starting. Depth=" + this.compoundEditDepth));
        if (this.compoundEditDepth == 1) {
            logger.debug((Object)("Firing compoundEditStarted to " + this.compoundEditListeners.size() + " listeners..."));
            CompoundEditEvent evt = new CompoundEditEvent(this, message);
            for (int i = this.compoundEditListeners.size() - 1; i >= 0; --i) {
                this.compoundEditListeners.get(i).compoundEditStarted(evt);
            }
        }
        return super.fireTransactionStarted(message);
    }

    protected TransactionEvent fireTransactionEnded() {
        logger.debug((Object)("Compound edit on " + ((Object)((Object)this)).getClass().getSimpleName() + " ending. Depth=" + this.compoundEditDepth));
        if (this.compoundEditDepth <= 0) {
            throw new IllegalStateException("Compound edit depth is already " + this.compoundEditDepth);
        }
        --this.compoundEditDepth;
        if (this.compoundEditDepth == 0) {
            logger.debug((Object)("Firing compoundEditEnded to " + this.compoundEditListeners.size() + " listeners..."));
            CompoundEditEvent evt = new CompoundEditEvent(this);
            for (int i = this.compoundEditListeners.size() - 1; i >= 0; --i) {
                this.compoundEditListeners.get(i).compoundEditEnded(evt);
            }
        }
        return super.fireTransactionEnded();
    }
}

