# This file was automatically generated by bifcl from zeek.bif.

##! A collection of built-in functions that implement a variety of things
##! such as general programming algorithms, string processing, math functions,
##! introspection, type conversion, file/directory manipulation, packet
##! filtering, interprocess communication and controlling protocol analyzer
##! behavior.
##!
##! You'll find most of Zeek's built-in functions that aren't protocol-specific
##! in this file.

export {








## Returns the current wall-clock time.
##
## In general, you should use :zeek:id:`network_time` instead
## unless you are using Zeek for non-networking uses (such as general
## scripting; not particularly recommended), because otherwise your script
## may behave very differently on live traffic versus played-back traffic
## from a save file.
##
## Returns: The wall-clock time.
##
## .. zeek:see:: network_time set_network_time
global current_time: function(): time ;


## Returns the timestamp of the last packet processed. This function returns
## the timestamp of the most recently read packet, whether read from a
## live network interface or from a save file.
##
## Returns: The timestamp of the packet processed.
##
## .. zeek:see:: current_time set_network_time
global network_time: function(): time ;


## Sets the timestamp associated with the last packet processed. Used for
## event replaying.
##
## nt: The time to which to set "network time".
##
## Returns: The timestamp of the packet processed.
##
## .. zeek:see:: current_time network_time
global set_network_time: function(nt: time ): bool ;


## Returns a system environment variable.
##
## var: The name of the variable whose value to request.
##
## Returns: The system environment variable identified by *var*, or an empty
##          string if it is not defined.
##
## .. zeek:see:: setenv
global getenv: function(var: string ): string ;


## Sets a system environment variable.
##
## var: The name of the variable.
##
## val: The (new) value of the variable *var*.
##
## Returns: True on success.
##
## .. zeek:see:: getenv
global setenv: function(var: string , val: string ): bool ;


## Shuts down the Zeek process immediately.
##
## code: The exit code to return with.
##
## .. zeek:see:: terminate
global exit: function(code: int ): any ;


## Gracefully shut down Zeek by terminating outstanding processing.
##
## Returns: True after successful termination and false when Zeek is still in
##          the process of shutting down.
##
## .. zeek:see:: exit zeek_is_terminating
global terminate: function(): bool ;




## Invokes a command via the ``system`` function of the OS.
## The command runs in the background with ``stdout`` redirecting to
## ``stderr``. Here is a usage example:
## ``system(fmt("rm %s", safe_shell_quote(sniffed_data)));``
##
## str: The command to execute.
##
## Returns: The return value from the OS ``system`` function.
##
## .. zeek:see:: system_env safe_shell_quote piped_exec
##
## .. note::
##
##      Note that this corresponds to the status of backgrounding the
##      given command, not to the exit status of the command itself. A
##      value of 127 corresponds to a failure to execute ``sh``, and -1
##      to an internal system failure.
global system: function(str: string ): int ;


## Invokes a command via the ``system`` function of the OS with a prepared
## environment. The function is essentially the same as :zeek:id:`system`,
## but changes the environment before invoking the command.
##
## str: The command to execute.
##
## env: A :zeek:type:`table` with the environment variables in the form
##      of key-value pairs. Each specified environment variable name
##      will be automatically prepended with ``ZEEK_ARG_``.
##
## Returns: The return value from the OS ``system`` function.
##
## .. zeek:see:: system safe_shell_quote piped_exec
global system_env: function(str: string , env: table_string_of_string ): int ;


## Opens a program with ``popen`` and writes a given string to the returned
## stream to send it to the opened process's stdin.
##
## program: The program to execute.
##
## to_write: Data to pipe to the opened program's process via ``stdin``.
##
## Returns: True on success.
##
## .. zeek:see:: system system_env
global piped_exec: function(program: string , to_write: string ): bool ;




## Computes the MD5 hash value of the provided list of arguments.
##
## Returns: The MD5 hash value of the concatenated arguments.
##
## .. zeek:see:: md5_hmac md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
##
## .. note::
##
##      This function performs a one-shot computation of its arguments.
##      For incremental hash computation, see :zeek:id:`md5_hash_init` and
##      friends.
global md5_hash: function(va_args: any): string ;


## Computes the SHA1 hash value of the provided list of arguments.
##
## Returns: The SHA1 hash value of the concatenated arguments.
##
## .. zeek:see:: md5_hash md5_hmac md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
##
## .. note::
##
##      This function performs a one-shot computation of its arguments.
##      For incremental hash computation, see :zeek:id:`sha1_hash_init` and
##      friends.
global sha1_hash: function(va_args: any): string ;


## Computes the SHA256 hash value of the provided list of arguments.
##
## Returns: The SHA256 hash value of the concatenated arguments.
##
## .. zeek:see:: md5_hash md5_hmac md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash_init sha256_hash_update sha256_hash_finish
##
## .. note::
##
##      This function performs a one-shot computation of its arguments.
##      For incremental hash computation, see :zeek:id:`sha256_hash_init` and
##      friends.
global sha256_hash: function(va_args: any): string ;


## Computes an HMAC-MD5 hash value of the provided list of arguments. The HMAC
## secret key is generated from available entropy when Zeek starts up, or it can
## be specified for repeatability using the ``-K`` command line flag.
##
## Returns: The HMAC-MD5 hash value of the concatenated arguments.
##
## .. zeek:see:: md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global md5_hmac: function(va_args: any): string ;


## Constructs an MD5 handle to enable incremental hash computation. You can
## feed data to the returned opaque value with :zeek:id:`md5_hash_update` and
## eventually need to call :zeek:id:`md5_hash_finish` to finish the computation
## and get the hash digest.
##
## For example, when computing incremental MD5 values of transferred files in
## multiple concurrent HTTP connections, one keeps an optional handle in the
## HTTP session record. Then, one would call
## ``c$http$md5_handle = md5_hash_init()`` once before invoking
## ``md5_hash_update(c$http$md5_handle, some_more_data)`` in the
## :zeek:id:`http_entity_data` event handler. When all data has arrived, a call
## to :zeek:id:`md5_hash_finish` returns the final hash value.
##
## Returns: The opaque handle associated with this hash computation.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global md5_hash_init: function(): opaque of md5 ;


## Constructs an SHA1 handle to enable incremental hash computation. You can
## feed data to the returned opaque value with :zeek:id:`sha1_hash_update` and
## finally need to call :zeek:id:`sha1_hash_finish` to finish the computation
## and get the hash digest.
##
## For example, when computing incremental SHA1 values of transferred files in
## multiple concurrent HTTP connections, one keeps an optional handle in the
## HTTP session record. Then, one would call
## ``c$http$sha1_handle = sha1_hash_init()`` once before invoking
## ``sha1_hash_update(c$http$sha1_handle, some_more_data)`` in the
## :zeek:id:`http_entity_data` event handler. When all data has arrived, a call
## to :zeek:id:`sha1_hash_finish` returns the final hash value.
##
## Returns: The opaque handle associated with this hash computation.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global sha1_hash_init: function(): opaque of sha1 ;


## Constructs an SHA256 handle to enable incremental hash computation. You can
## feed data to the returned opaque value with :zeek:id:`sha256_hash_update` and
## finally need to call :zeek:id:`sha256_hash_finish` to finish the computation
## and get the hash digest.
##
## For example, when computing incremental SHA256 values of transferred files in
## multiple concurrent HTTP connections, one keeps an optional handle in the
## HTTP session record. Then, one would call
## ``c$http$sha256_handle = sha256_hash_init()`` once before invoking
## ``sha256_hash_update(c$http$sha256_handle, some_more_data)`` in the
## :zeek:id:`http_entity_data` event handler. When all data has arrived, a call
## to :zeek:id:`sha256_hash_finish` returns the final hash value.
##
## Returns: The opaque handle associated with this hash computation.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_update sha256_hash_finish
global sha256_hash_init: function(): opaque of sha256 ;


## Updates the MD5 value associated with a given index. It is required to
## call :zeek:id:`md5_hash_init` once before calling this
## function.
##
## handle: The opaque handle associated with this hash computation.
##
## data: The data to add to the hash computation.
##
## Returns: True on success.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global md5_hash_update: function(handle: opaque of md5 , data: string ): bool ;


## Updates the SHA1 value associated with a given index. It is required to
## call :zeek:id:`sha1_hash_init` once before calling this
## function.
##
## handle: The opaque handle associated with this hash computation.
##
## data: The data to add to the hash computation.
##
## Returns: True on success.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global sha1_hash_update: function(handle: opaque of sha1 , data: string ): bool ;


## Updates the SHA256 value associated with a given index. It is required to
## call :zeek:id:`sha256_hash_init` once before calling this
## function.
##
## handle: The opaque handle associated with this hash computation.
##
## data: The data to add to the hash computation.
##
## Returns: True on success.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_finish
global sha256_hash_update: function(handle: opaque of sha256 , data: string ): bool ;


## Returns the final MD5 digest of an incremental hash computation.
##
## handle: The opaque handle associated with this hash computation.
##
## Returns: The hash value associated with the computation of *handle*.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global md5_hash_finish: function(handle: opaque of md5 ): string ;


## Returns the final SHA1 digest of an incremental hash computation.
##
## handle: The opaque handle associated with this hash computation.
##
## Returns: The hash value associated with the computation of *handle*.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update
##    sha256_hash sha256_hash_init sha256_hash_update sha256_hash_finish
global sha1_hash_finish: function(handle: opaque of sha1 ): string ;


## Returns the final SHA256 digest of an incremental hash computation.
##
## handle: The opaque handle associated with this hash computation.
##
## Returns: The hash value associated with the computation of *handle*.
##
## .. zeek:see:: md5_hmac md5_hash md5_hash_init md5_hash_update md5_hash_finish
##    sha1_hash sha1_hash_init sha1_hash_update sha1_hash_finish
##    sha256_hash sha256_hash_init sha256_hash_update
global sha256_hash_finish: function(handle: opaque of sha256 ): string ;


## Initializes and returns a new paraglob.
##
## v: Vector of patterns to initialize the paraglob with.
##
## Returns: A new, compiled, paraglob with the patterns in *v*
##
## .. zeek:see::paraglob_match paraglob_equals paraglob_add
global paraglob_init: function(v: any ) : opaque of paraglob ;


## Gets all the patterns inside the handle associated with an input string.
##
## handle: A compiled paraglob.
##
## match: string to match against the paraglob.
##
## Returns: A vector of strings matching the input string.
##
## ## .. zeek:see::paraglob_add paraglob_equals paraglob_init
global paraglob_match: function(handle: opaque of paraglob , match: string ): string_vec ;


## Compares two paraglobs for equality.
##
## p_one: A compiled paraglob.
##
## p_two: A compiled paraglob.
##
## Returns: True if both paraglobs contain the same patterns, false otherwise.
##
## ## .. zeek:see::paraglob_add paraglob_match paraglob_init
global paraglob_equals: function(p_one: opaque of paraglob , p_two: opaque of paraglob ) : bool ;


## Returns 32-bit digest of arbitrary input values using FNV-1a hash algorithm.
## See `<https://en.wikipedia.org/wiki/Fowler%E2%80%93Noll%E2%80%93Vo_hash_function>`_.
##
## input: The desired input value to hash.
##
## Returns: The hashed value.
##
## .. zeek:see:: hrw_weight
global fnv1a32: function(input: any ): count ;


## Calculates a weight value for use in a Rendezvous Hashing algorithm.
## See `<https://en.wikipedia.org/wiki/Rendezvous_hashing>`_.
## The weight function used is the one recommended in the original
## paper: `<http://www.eecs.umich.edu/techreports/cse/96/CSE-TR-316-96.pdf>`_.
##
## key_digest: A 32-bit digest of a key.  E.g. use :zeek:see:`fnv1a32` to
##             produce this.
##
## site_id: A 32-bit site/node identifier.
##
## Returns: The weight value for the key/site pair.
##
## .. zeek:see:: fnv1a32
global hrw_weight: function(key_digest: count , site_id: count ): count ;


## Generates a random number.
##
## max: The maximum value of the random number.
##
## Returns: a random positive integer in the interval *[0, max)*.
##
## .. zeek:see:: srand
##
## .. note::
##
##      This function is a wrapper about the function ``random``
##      provided by the OS.
global rand: function(max: count ): count ;


## Sets the seed for subsequent :zeek:id:`rand` calls.
##
## seed: The seed for the PRNG.
##
## .. zeek:see:: rand
##
## .. note::
##
##      This function is a wrapper about the function ``srandom``
##      provided by the OS.
global srand: function(seed: count ): any ;




## Send a string to syslog.
##
## s: The string to log via syslog
global syslog: function(s: string ): any ;


## Determines the MIME type of a piece of data using Zeek's file magic
## signatures.
##
## data: The data to find the MIME type for.
##
## return_mime: Deprecated argument; does nothing, except emit a warning
##              when false.
##
## Returns: The MIME type of *data*, or "<unknown>" if there was an error
##          or no match.  This is the strongest signature match.
##
## .. zeek:see:: file_magic
global identify_data: function(data: string , return_mime: bool &default=T): string ;


## Determines the MIME type of a piece of data using Zeek's file magic
## signatures.
##
## data: The data for which to find matching MIME types.
##
## Returns: All matching signatures, in order of strength.
##
## .. zeek:see:: identify_data
global file_magic: function(data: string ): mime_matches ;


## Performs an entropy test on the given data.
## See http://www.fourmilab.ch/random.
##
## data: The data to compute the entropy for.
##
## Returns: The result of the entropy test, which contains the following
##          fields.
##
##              - ``entropy``: The information density expressed as a number of
##                bits per character.
##
##              - ``chi_square``: The chi-square test value expressed as an
##                absolute number and a percentage which indicates how
##                frequently a truly random sequence would exceed the value
##                calculated, i.e., the degree to which the sequence tested is
##                suspected of being non-random.
##
##                If the percentage is greater than 99% or less than 1%, the
##                sequence is almost certainly not random. If the percentage is
##                between 99% and 95% or between 1% and 5%, the sequence is
##                suspect. Percentages between 90\% and 95\% and 5\% and 10\%
##                indicate the sequence is "almost suspect."
##
##              - ``mean``: The arithmetic mean of all the bytes. If the data
##                are close to random, it should be around 127.5.
##
##              - ``monte_carlo_pi``: Each successive sequence of six bytes is
##                used as 24-bit *x* and *y* coordinates within a square. If
##                the distance of the randomly-generated point is less than the
##                radius of a circle inscribed within the square, the six-byte
##                sequence is considered a "hit." The percentage of hits can
##                be used to calculate the value of pi. For very large streams
##                the value will approach the correct value of pi if the
##                sequence is close to random.
##
##              - ``serial_correlation``: This quantity measures the extent to
##                which each byte in the file depends upon the previous byte.
##                For random sequences this value will be close to zero.
##
## .. zeek:see:: entropy_test_init entropy_test_add entropy_test_finish
global find_entropy: function(data: string ): entropy_test_result ;


## Initializes data structures for incremental entropy calculation.
##
## Returns: An opaque handle to be used in subsequent operations.
##
## .. zeek:see:: find_entropy entropy_test_add entropy_test_finish
global entropy_test_init: function(): opaque of entropy ;


## Adds data to an incremental entropy calculation.
##
## handle: The opaque handle representing the entropy calculation state.
##
## data: The data to add to the entropy calculation.
##
## Returns: True on success.
##
## .. zeek:see:: find_entropy entropy_test_add entropy_test_finish
global entropy_test_add: function(handle: opaque of entropy , data: string ): bool ;


## Finishes an incremental entropy calculation. Before using this function,
## one needs to obtain an opaque handle with :zeek:id:`entropy_test_init` and
## add data to it via :zeek:id:`entropy_test_add`.
##
## handle: The opaque handle representing the entropy calculation state.
##
## Returns: The result of the entropy test. See :zeek:id:`find_entropy` for a
##          description of the individual components.
##
## .. zeek:see:: find_entropy entropy_test_init entropy_test_add
global entropy_test_finish: function(handle: opaque of entropy ): entropy_test_result ;


## Creates an identifier that is unique with high probability.
##
## prefix: A custom string prepended to the result.
##
## Returns: A string identifier that is unique.
##
## .. zeek:see:: unique_id_from
global unique_id: function(prefix: string ) : string ;


## Creates an identifier that is unique with high probability.
##
## pool: A seed for determinism.
##
## prefix: A custom string prepended to the result.
##
## Returns: A string identifier that is unique.
##
## .. zeek:see:: unique_id
global unique_id_from: function(pool: int , prefix: string ) : string ;








## Removes all elements from a set or table.
##
## v: The set or table
global clear_table: function(v: any ): any ;


## Gets all subnets that contain a given subnet from a set/table[subnet].
##
## search: the subnet to search for.
##
## t: the set[subnet] or table[subnet].
##
## Returns: All the keys of the set or table that cover the subnet searched for.
global matching_subnets: function(search: subnet , t: any ): subnet_vec ;


## For a set[subnet]/table[subnet], create a new table that contains all entries
## that contain a given subnet.
##
## search: the subnet to search for.
##
## t: the set[subnet] or table[subnet].
##
## Returns: A new table that contains all the entries that cover the subnet searched for.
global filter_subnet_table: function(search: subnet , t: any ): any ;


## Checks if a specific subnet is a member of a set/table[subnet].
## In contrast to the ``in`` operator, this performs an exact match, not
## a longest prefix match.
##
## search: the subnet to search for.
##
## t: the set[subnet] or table[subnet].
##
## Returns: True if the exact subnet is a member, false otherwise.
global check_subnet: function(search: subnet , t: any ): bool ;


## Checks whether two objects reference the same internal object. This function
## uses equality comparison of C++ raw pointer values to determine if the two
## objects are the same.
##
## o1: The first object.
##
## o2: The second object.
##
## Returns: True if *o1* and *o2* are equal.
global same_object: function(o1: any , o2: any ): bool ;


## Returns the number of bytes that a value occupies in memory.
##
## v: The value
##
## Returns: The number of bytes that *v* occupies.
global val_size: function(v: any ): count &deprecated="Remove in v5.1. MemoryAllocation() is deprecated and will be removed."
	;


## Resizes a vector.
##
## aggr: The vector instance.
##
## newsize: The new size of *aggr*.
##
## Returns: The old size of *aggr*, or 0 if *aggr* is not a :zeek:type:`vector`.
global resize: function(aggr: any , newsize: count ) : count ;


## Tests whether a boolean vector (``vector of bool``) has *any* true
## element.
##
## v: The boolean vector instance.
##
## Returns: True if any element in *v* is true.
##
## .. zeek:see:: all_set
global any_set: function(v: any ) : bool ;


## Tests whether *all* elements of a boolean vector (``vector of bool``) are
## true.
##
## v: The boolean vector instance.
##
## Returns: True iff all elements in *v* are true or there are no elements.
##
## .. zeek:see:: any_set
##
## .. note::
##
##      Missing elements count as false.
global all_set: function(v: any ) : bool ;


## Sorts a vector in place. The second argument is a comparison function that
## takes two arguments: if the vector type is ``vector of T``, then the
## comparison function must be ``function(a: T, b: T): int``, which returns
## a value less than zero if ``a < b`` for some type-specific notion of the
## less-than operator.  The comparison function is optional if the type
## is a numeric type (int, count, double, time, etc.).
##
## v: The vector instance to sort.
##
## Returns: The vector, sorted from minimum to maximum value. If the vector
##          could not be sorted, then the original vector is returned instead.
##
## .. zeek:see:: order
global sort: function(va_args: any) : any ;


## Returns the order of the elements in a vector according to some
## comparison function. See :zeek:id:`sort` for details about the comparison
## function.
##
## v: The vector whose order to compute.
##
## Returns: A ``vector of count`` with the indices of the ordered elements.
##          For example, the elements of *v* in order are (assuming ``o``
##          is the vector returned by ``order``):  v[o[0]], v[o[1]], etc.
##
## .. zeek:see:: sort
global order: function(va_args: any) : index_vec ;








## Returns the concatenation of the string representation of its arguments. The
## arguments can be of any type. For example, ``cat("foo", 3, T)`` returns
## ``"foo3T"``.
##
## Returns: A string concatentation of all arguments.
global cat: function(va_args: any): string ;


## Concatenates all arguments, with a separator placed between each one. This
## function is similar to :zeek:id:`cat`, but places a separator between each
## given argument. If any of the variable arguments is an empty string it is
## replaced by a given default string instead.
##
## sep: The separator to place between each argument.
##
## def: The default string to use when an argument is the empty string.
##
## Returns: A concatenation of all arguments with *sep* between each one and
##          empty strings replaced with *def*.
##
## .. zeek:see:: cat string_cat
global cat_sep: function(va_args: any): string ;


## Produces a formatted string à la ``printf``. The first argument is the
## *format string* and specifies how subsequent arguments are converted for
## output. It is composed of zero or more directives: ordinary characters (not
## ``%``), which are copied unchanged to the output, and conversion
## specifications, each of which fetches zero or more subsequent arguments.
## Conversion specifications begin with ``%`` and the arguments must properly
## correspond to the specifier. After the ``%``, the following characters
## may appear in sequence:
##
##    - ``%``: Literal ``%``
##
##    - ``-``: Left-align field
##
##    - ``[0-9]+``: The field width (< 128)
##
##    - ``.``: Precision of floating point specifiers ``[efg]`` (< 128)
##
##    - ``[DTdxsefg]``: Format specifier
##
##        - ``[DT]``: ISO timestamp with microsecond precision
##
##        - ``d``: Signed/Unsigned integer (using C-style ``%lld``/``%llu``
##                 for ``int``/``count``)
##
##        - ``x``: Unsigned hexadecimal (using C-style ``%llx``);
##                 addresses/ports are converted to host-byte order
##
##        - ``s``: String (byte values less than 32 or greater than 126
##                 will be escaped)
##
##        - ``[efg]``: Double
##
## Returns: Returns the formatted string. Given no arguments, :zeek:id:`fmt`
##          returns an empty string. Given no format string or the wrong
##          number of additional arguments for the given format specifier,
##          :zeek:id:`fmt` generates a run-time error.
##
## .. zeek:see:: cat cat_sep string_cat
global fmt: function(va_args: any): string ;


## Renders a sequence of values to a string of bytes and outputs them directly
## to ``stdout`` with no additional escape sequences added.  No additional
## newline is added to the end either.
##
## Returns: Always true.
##
## .. zeek:see:: fmt cat cat_sep string_cat to_json
global print_raw: function(va_args: any): bool ;








## Computes the greatest integer less than the given :zeek:type:`double` value.
## For example, ``floor(3.14)`` returns ``3.0``, and ``floor(-3.14)``
## returns ``-4.0``.
##
## d: The :zeek:type:`double` to manipulate.
##
## Returns: The next lowest integer of *d* as :zeek:type:`double`.
##
## .. zeek:see:: sqrt exp ln log10
global floor: function(d: double ): double ;


## Computes the square root of a :zeek:type:`double`.
##
## x: The number to compute the square root of.
##
## Returns: The square root of *x*.
##
## .. zeek:see:: floor exp ln log10
global sqrt: function(x: double ): double ;


## Computes the exponential function.
##
## d: The argument to the exponential function.
##
## Returns: *e* to the power of *d*.
##
## .. zeek:see:: floor sqrt ln log10
global exp: function(d: double ): double ;


## Computes the natural logarithm of a number.
##
## d: The argument to the logarithm.
##
## Returns: The natural logarithm of *d*.
##
## .. zeek:see:: exp floor sqrt log10
global ln: function(d: double ): double ;


## Computes the common logarithm of a number.
##
## d: The argument to the logarithm.
##
## Returns: The common logarithm of *d*.
##
## .. zeek:see:: exp floor sqrt ln
global log10: function(d: double ): double ;








## Returns the ID of the analyzer which raised the current event.
##
## Returns: The ID of the analyzer which raised the current event, or 0 if
##          none.
global current_analyzer: function() : count ;


## Returns Zeek's process ID.
##
## Returns: Zeek's process ID.
global getpid: function() : count ;




## Returns the Zeek version string.
##
## Returns: Zeek's version, e.g., 2.0-beta-47-debug.
global zeek_version: function(): string ;




## Returns whether Zeek was started in bare mode.
##
## Returns: True if Zeek was started in bare mode, false otherwise.
global bare_mode: function(): bool ;


## Converts a record type name to a vector of strings, where each element is
## the name of a record field. Nested records are flattened.
##
## rt: The name of the record type.
##
## Returns: A string vector with the field names of *rt*.
global record_type_to_vector: function(rt: string ): string_vec ;


## Returns the type name of an arbitrary Zeek variable.
##
## t: An arbitrary object.
##
## Returns: The type name of *t*.
global type_name: function(t: any ): string ;




## Returns all type name aliases of a value or type.
##
## x: An arbitrary value or type.
##
## Returns: The set of all type name aliases of *x* (or the type of *x*
##          if it's a value instead of a type).  For primitive values
##          and types like :zeek:type:`string` or :zeek:type:`count`,
##          this returns an empty set.  For types with user-defined
##          names like :zeek:type:`record` or :zeek:type:`enum`, the
##          returned set contains the original user-defined name for the
##          type along with all aliases.  For other compound types, like
##          :zeek:type:`table`, the returned set is empty unless
##          explicitly requesting aliases for a user-defined type alias
##          or a value that was explicitly created using a type alias
##          (as opposed to originating from an "anonymous" constructor
##          or initializer for that compound type).
global type_aliases: function(x: any ): string_set ;


## Returns all value names associated with an enum type.
##
## et: An enum type.
##
## Returns: All enum value names associated with enum type *et*.
##          If *et* is not an enum type, an empty set is returned.
global enum_names: function(et: any ): string_set ;


## Returns: list of command-line arguments (``argv``) used to run Zeek.
global zeek_args: function(): string_vec ;


## Checks whether Zeek reads traffic from one or more network interfaces (as
## opposed to from a network trace in a file). Note that this function returns
## true even after Zeek has stopped reading network traffic, for example due to
## receiving a termination signal.
##
## Returns: True if reading traffic from a network interface.
##
## .. zeek:see:: reading_traces packet_source
global reading_live_traffic: function(): bool ;


## Checks whether Zeek reads traffic from a trace file (as opposed to from a
## network interface).
##
## Returns: True if reading traffic from a network trace.
##
## .. zeek:see:: reading_live_traffic packet_source
global reading_traces: function(): bool ;


## Returns: the packet source being read by Zeek.
##
## .. zeek:see:: reading_live_traffic reading_traces
global packet_source: function(): PacketSource ;


## Generates a table of the size of all global variables. The table index is
## the variable name and the value is the variable size in bytes.
##
## Returns: A table that maps variable names to their sizes.
##
## .. zeek:see:: global_ids
global global_sizes: function(): var_sizes &deprecated="Remove in v5.1. MemoryAllocation() is deprecated and will be removed."
	;


## Generates a table of the "footprint" of all global container variables.
## This is (approximately) the number of objects the global contains either
## directly or indirectly.  The number is not meant to be precise, but
## rather comparable: larger footprint correlates with more memory consumption.
## The table index is the variable name and the value is the footprint.
##
## Returns: A table that maps variable names to their footprints.
##
## .. zeek:see:: val_footprint
global global_container_footprints: function(): var_sizes ;


## Computes a value's "footprint": the number of objects the value contains
## either directly or indirectly.  The number is not meant to be precise, but
## rather comparable: larger footprint correlates with more memory consumption.
##
## Returns: the footprint.
##
## .. zeek:see:: global_container_footprints
global val_footprint: function(v: any ): count ;


## Generates a table with information about all global identifiers. The table
## value is a record containing the type name of the identifier, whether it is
## exported, a constant, an enum constant, redefinable, and its value (if it
## has one).
##
## Returns: A table that maps identifier names to information about them.
##
## .. zeek:see:: global_sizes
global global_ids: function(): id_table ;


## Returns a set giving the names of all global options.
global global_options: function(): string_set ;


## Returns the value of a global identifier.
##
## id: The global identifier.
##
## Returns: The value of *id*. If *id* does not describe a valid identifier,
##          the string ``"<unknown id>"`` or ``"<no ID value>"`` is returned.
global lookup_ID: function(id: string ) : any ;


## Generates metadata about a record's fields. The returned information
## includes the field name, whether it is logged, its value (if it has one),
## and its default value (if specified).
##
## rec: The record value or type to inspect.
##
## Returns: A table that describes the fields of a record.
global record_fields: function(rec: any ): record_field_table ;


## Enables detailed collection of profiling statistics. Statistics include
## CPU/memory usage, connections, TCP states/reassembler, DNS lookups,
## timers, and script-level state. The script variable :zeek:id:`profiling_file`
## holds the name of the file.
##
## .. zeek:see:: get_conn_stats
##              get_dns_stats
##              get_event_stats
##              get_file_analysis_stats
##              get_gap_stats
##              get_matcher_stats
##              get_net_stats
##              get_proc_stats
##              get_reassembler_stats
##              get_thread_stats
##              get_timer_stats
global do_profiling: function() : any ;


## Checks whether a given IP address belongs to a local interface.
##
## ip: The IP address to check.
##
## Returns: True if *ip* belongs to a local interface.
global is_local_interface: function(ip: addr ) : bool ;


## Write rule matcher statistics (DFA states, transitions, memory usage, cache
## hits/misses) to a file.
##
## f: The file to write to.
##
## Returns: True (unconditionally).
##
## .. zeek:see:: get_matcher_stats
global dump_rule_stats: function(f: file ): bool ;


## Checks if Zeek is terminating.
##
## Returns: True if Zeek is in the process of shutting down.
##
## .. zeek:see:: terminate
global zeek_is_terminating: function(): bool ;


## Returns the hostname of the machine Zeek runs on.
##
## Returns: The hostname of the machine Zeek runs on.
global gethostname: function() : string ;


## Returns whether an address is IPv4 or not.
##
## a: the address to check.
##
## Returns: true if *a* is an IPv4 address, else false.
global is_v4_addr: function(a: addr ): bool ;


## Returns whether an address is IPv6 or not.
##
## a: the address to check.
##
## Returns: true if *a* is an IPv6 address, else false.
global is_v6_addr: function(a: addr ): bool ;


## Returns whether a subnet specification is IPv4 or not.
##
## s: the subnet to check.
##
## Returns: true if *s* is an IPv4 subnet, else false.
global is_v4_subnet: function(s: subnet ): bool ;


## Returns whether a subnet specification is IPv6 or not.
##
## s: the subnet to check.
##
## Returns: true if *s* is an IPv6 subnet, else false.
global is_v6_subnet: function(s: subnet ): bool ;


## Returns a representation of the call stack as a vector of call stack
## elements, each containing call location information.
##
## Returns: the call stack information, including function, file, and line
##          location information.
global backtrace: function(): Backtrace ;








## Converts the *data* field of :zeek:type:`ip6_routing` records that have
## *rtype* of 0 into a vector of addresses.
##
## s: The *data* field of an :zeek:type:`ip6_routing` record that has
##    an *rtype* of 0.
##
## Returns: The vector of addresses contained in the routing header data.
global routing0_data_to_addrs: function(s: string ): addr_vec ;


## Converts an :zeek:type:`addr` to an :zeek:type:`index_vec`.
##
## a: The address to convert into a vector of counts.
##
## Returns: A vector containing the host-order address representation,
##          four elements in size for IPv6 addresses, or one element for IPv4.
##
## .. zeek:see:: counts_to_addr
global addr_to_counts: function(a: addr ): index_vec ;


## Converts an :zeek:type:`index_vec` to an :zeek:type:`addr`.
##
## v: The vector containing host-order IP address representation,
##    one element for IPv4 addresses, four elements for IPv6 addresses.
##
## Returns: An IP address.
##
## .. zeek:see:: addr_to_counts
global counts_to_addr: function(v: index_vec ): addr ;


## Converts an :zeek:type:`enum` to an :zeek:type:`int`.
##
## e: The :zeek:type:`enum` to convert.
##
## Returns: The :zeek:type:`int` value that corresponds to the :zeek:type:`enum`.
global enum_to_int: function(e: any ): int ;


## Converts a :zeek:type:`string` to an :zeek:type:`int`.
##
## str: The :zeek:type:`string` to convert.
##
## Returns: The :zeek:type:`string` *str* as :zeek:type:`int`.
##
## .. zeek:see:: to_addr to_port to_subnet
global to_int: function(str: string ): int ;



## Converts a (positive) :zeek:type:`int` to a :zeek:type:`count`.
##
## n: The :zeek:type:`int` to convert.
##
## Returns: The :zeek:type:`int` *n* as unsigned integer, or 0 if *n* < 0.
global int_to_count: function(n: int ): count ;


## Converts a :zeek:type:`double` to a :zeek:type:`count`.
##
## d: The :zeek:type:`double` to convert.
##
## Returns: The :zeek:type:`double` *d* as unsigned integer, or 0 if *d* < 0.0.
##          The value returned follows typical rounding rules, as implemented
##          by rint().
global double_to_int: function(d: double ): int ;


## Converts a :zeek:type:`double` to a :zeek:type:`int`.
##
## d: The :zeek:type:`double` to convert.
##
## Returns: The :zeek:type:`double` *d* as signed integer. The value returned
##          follows typical rounding rules, as implemented by rint().
##
## .. zeek:see:: double_to_time
global double_to_count: function(d: double ): count ;


## Converts a :zeek:type:`string` to a :zeek:type:`count`.
##
## str: The :zeek:type:`string` to convert.
##
## Returns: The :zeek:type:`string` *str* as unsigned integer, or 0 if *str* has
##          an invalid format.
##
## .. zeek:see:: to_addr to_int to_port to_subnet
global to_count: function(str: string ): count ;


## Converts an :zeek:type:`interval` to a :zeek:type:`double`.
##
## i: The :zeek:type:`interval` to convert.
##
## Returns: The :zeek:type:`interval` *i* as :zeek:type:`double`.
##
## .. zeek:see:: double_to_interval
global interval_to_double: function(i: interval ): double ;


## Converts a :zeek:type:`count` to a :zeek:type:`double`.
##
## c: The :zeek:type:`count` to convert.
##
## Returns: The :zeek:type:`count` *c* as :zeek:type:`double`.
##
## .. zeek:see:: int_to_double double_to_count
global count_to_double: function(c: count ): double ;


## Converts an :zeek:type:`int` to a :zeek:type:`double`.
##
## i: The :zeek:type:`int` to convert.
##
## Returns: The :zeek:type:`int` *i* as :zeek:type:`double`.
##
## .. zeek:see:: count_to_double double_to_count
global int_to_double: function(i: int ): double ;


## Converts a :zeek:type:`time` value to a :zeek:type:`double`.
##
## t: The :zeek:type:`time` to convert.
##
## Returns: The :zeek:type:`time` value *t* as :zeek:type:`double`.
##
## .. zeek:see:: double_to_time
global time_to_double: function(t: time ): double ;


## Converts a :zeek:type:`double` value to a :zeek:type:`time`.
##
## d: The :zeek:type:`double` to convert.
##
## Returns: The :zeek:type:`double` value *d* as :zeek:type:`time`.
##
## .. zeek:see:: time_to_double double_to_count
global double_to_time: function(d: double ): time ;


## Converts a :zeek:type:`double` to an :zeek:type:`interval`.
##
## d: The :zeek:type:`double` to convert.
##
## Returns: The :zeek:type:`double` *d* as :zeek:type:`interval`.
##
## .. zeek:see:: interval_to_double
global double_to_interval: function(d: double ): interval ;


## Converts a :zeek:type:`port` to a :zeek:type:`count`.
##
## p: The :zeek:type:`port` to convert.
##
## Returns: The :zeek:type:`port` *p* as :zeek:type:`count`.
##
## .. zeek:see:: count_to_port
global port_to_count: function(p: port ): count ;


## Converts a :zeek:type:`count` and ``transport_proto`` to a :zeek:type:`port`.
##
## num: The :zeek:type:`port` number.
##
## proto: The transport protocol.
##
## Returns: The :zeek:type:`count` *num* as :zeek:type:`port`.
##
## .. zeek:see:: port_to_count
global count_to_port: function(num: count , proto: transport_proto ): port ;


## Converts a :zeek:type:`string` to an :zeek:type:`addr`.
##
## ip: The :zeek:type:`string` to convert.
##
## Returns: The :zeek:type:`string` *ip* as :zeek:type:`addr`, or the unspecified
##          address ``::`` if the input string does not parse correctly.
##
## .. zeek:see:: to_count to_int to_port count_to_v4_addr raw_bytes_to_v4_addr raw_bytes_to_v6_addr
##    to_subnet
global to_addr: function(ip: string ): addr ;


## Checks if a string is a valid IPv4 or IPv6 address.
##
## ip: the string to check for valid IP formatting.
##
## Returns: T if the string is a valid IPv4 or IPv6 address format.
global is_valid_ip: function(ip: string ): bool ;


## Converts a :zeek:type:`string` to a :zeek:type:`subnet`.
##
## sn: The subnet to convert.
##
## Returns: The *sn* string as a :zeek:type:`subnet`, or the unspecified subnet
##          ``::/0`` if the input string does not parse correctly.
##
## .. zeek:see:: to_count to_int to_port count_to_v4_addr raw_bytes_to_v4_addr raw_bytes_to_v6_addr
##    to_addr
global to_subnet: function(sn: string ): subnet ;


## Converts a :zeek:type:`addr` to a :zeek:type:`subnet`.
##
## a: The address to convert.
##
## Returns: The address as a :zeek:type:`subnet`.
##
## .. zeek:see:: to_subnet
global addr_to_subnet: function(a: addr ): subnet ;


## Converts a :zeek:type:`subnet` to an :zeek:type:`addr` by
## extracting the prefix.
##
## sn: The subnet to convert.
##
## Returns: The subnet as an :zeek:type:`addr`.
##
## .. zeek:see:: to_subnet
global subnet_to_addr: function(sn: subnet ): addr ;


## Returns the width of a :zeek:type:`subnet`.
##
## sn: The subnet.
##
## Returns: The width of the subnet.
##
## .. zeek:see:: to_subnet
global subnet_width: function(sn: subnet ): count ;


## Converts a :zeek:type:`string` to a :zeek:type:`double`.
##
## str: The :zeek:type:`string` to convert.
##
## Returns: The :zeek:type:`string` *str* as double, or 0 if *str* has
##          an invalid format.
##
global to_double: function(str: string ): double ;


## Converts a :zeek:type:`count` to an :zeek:type:`addr`.
##
## ip: The :zeek:type:`count` to convert.
##
## Returns: The :zeek:type:`count` *ip* as :zeek:type:`addr`.
##
## .. zeek:see:: raw_bytes_to_v4_addr to_addr to_subnet raw_bytes_to_v6_addr
global count_to_v4_addr: function(ip: count ): addr ;


## Converts a :zeek:type:`string` of bytes into an IPv4 address. In particular,
## this function interprets the first 4 bytes of the string as an IPv4 address
## in network order.
##
## b: The raw bytes (:zeek:type:`string`) to convert.
##
## Returns: The byte :zeek:type:`string` *b* as :zeek:type:`addr`.
##
## .. zeek:see:: raw_bytes_to_v4_addr to_addr to_subnet
global raw_bytes_to_v4_addr: function(b: string ): addr ;


## Converts a :zeek:type:`string` of bytes into an IPv6 address. In particular,
## this function interprets the first 16 bytes of the string as an IPv6 address
## in network order.
##
## b: The raw bytes (:zeek:type:`string`) to convert.
##
## Returns: The byte :zeek:type:`string` *b* as :zeek:type:`addr`.
##
## .. zeek:see:: raw_bytes_to_v6_addr to_addr to_subnet
global raw_bytes_to_v6_addr: function(x: string ): addr ;


## Converts a :zeek:type:`string` to a :zeek:type:`port`.
##
## s: The :zeek:type:`string` to convert.
##
## Returns: A :zeek:type:`port` converted from *s*.
##
## .. zeek:see:: to_addr to_count to_int to_subnet
global to_port: function(s: string ): port ;


## Converts a string of bytes (in network byte order) to a :zeek:type:`double`.
##
## s: A string of bytes containing the binary representation of a double value.
##
## Returns: The double value contained in *s*, or 0 if the conversion
##          failed.
##
global bytestring_to_double: function(s: string ): double ;


## Converts a string of bytes to a :zeek:type:`count`.
##
## s: A string of bytes containing the binary representation of the value.
##
## is_le: If true, *s* is assumed to be in little endian format, else it's big endian.
##
## Returns: The value contained in *s*, or 0 if the conversion failed.
##
global bytestring_to_count: function(s: string , is_le: bool &default=F): count ;


## Converts a reverse pointer name to an address. For example,
## ``1.0.168.192.in-addr.arpa`` to ``192.168.0.1``.
##
## s: The string with the reverse pointer name.
##
## Returns: The IP address corresponding to *s*.
##
## .. zeek:see:: addr_to_ptr_name to_addr
global ptr_name_to_addr: function(s: string ): addr ;


## Converts an IP address to a reverse pointer name. For example,
## ``192.168.0.1`` to ``1.0.168.192.in-addr.arpa``.
##
## a: The IP address to convert to a reverse pointer name.
##
## Returns: The reverse pointer representation of *a*.
##
## .. zeek:see:: ptr_name_to_addr to_addr
global addr_to_ptr_name: function(a: addr ): string ;


## Converts a string of bytes into its hexadecimal representation.
## For example, ``"04"`` would be converted to ``"3034"``.
##
## bytestring: The string of bytes.
##
## Returns: The hexadecimal representation of *bytestring*.
##
## .. zeek:see:: hexdump hexstr_to_bytestring
global bytestring_to_hexstr: function(bytestring: string ): string ;


## Converts a hex-string into its binary representation.
## For example, ``"3034"`` would be converted to ``"04"``.
##
## The input string is assumed to contain an even number of hexadecimal digits
## (0-9, a-f, or A-F), otherwise behavior is undefined.
##
## hexstr: The hexadecimal string representation.
##
## Returns: The binary representation of *hexstr*.
##
## .. zeek:see:: hexdump bytestring_to_hexstr
global hexstr_to_bytestring: function(hexstr: string ): string ;


## Encodes a Base64-encoded string.
##
## s: The string to encode.
##
## a: An optional custom alphabet. The empty string indicates the default
##    alphabet. If given, the string must consist of 64 unique characters.
##
## Returns: The encoded version of *s*.
##
## .. zeek:see:: decode_base64
global encode_base64: function(s: string , a: string &default=""): string ;


## Decodes a Base64-encoded string.
##
## s: The Base64-encoded string.
##
## a: An optional custom alphabet. The empty string indicates the default
##    alphabet. If given, the string must consist of 64 unique characters.
##
## Returns: The decoded version of *s*.
##
## .. zeek:see:: decode_base64_conn encode_base64
global decode_base64: function(s: string , a: string &default=""): string ;


## Decodes a Base64-encoded string that was derived from processing a connection.
## If an error is encountered decoding the string, that will be logged to
## ``weird.log`` with the associated connection.
##
## cid: The identifier of the connection that the encoding originates from.
##
## s: The Base64-encoded string.
##
## a: An optional custom alphabet. The empty string indicates the default
##    alphabet. If given, the string must consist of 64 unique characters.
##
## Returns: The decoded version of *s*.
##
## .. zeek:see:: decode_base64
global decode_base64_conn: function(cid: conn_id , s: string , a: string &default=""): string ;




## Converts a bytes representation of a UUID into its string form. For example,
## given a string of 16 bytes, it produces an output string in this format:
## ``550e8400-e29b-41d4-a716-446655440000``.
## See `<http://en.wikipedia.org/wiki/Universally_unique_identifier>`_.
##
## uuid: The 16 bytes of the UUID.
##
## Returns: The string representation of *uuid*.
global uuid_to_string: function(uuid: string ): string ;




## Escapes a string so that it becomes a valid :zeek:type:`pattern` and can be
## used with the :zeek:id:`string_to_pattern`. Any character from the set
## ``^$-:"\/|*+?.(){}[]`` is prefixed with a ``\``.
##
## s: The string to escape.
##
## Returns: An escaped version of *s* that has the structure of a valid
##          :zeek:type:`pattern`.
##
## .. zeek:see:: string_to_pattern
##
global convert_for_pattern: function(s: string ): string ;


## Converts a :zeek:type:`string` into a :zeek:type:`pattern`.
##
## s: The string to convert.
##
## convert: If true, *s* is first passed through the function
##          :zeek:id:`convert_for_pattern` to escape special characters of
##          patterns.
##
## Returns: *s* as :zeek:type:`pattern`.
##
## .. zeek:see:: convert_for_pattern
global string_to_pattern: function(s: string , convert: bool ): pattern ;


## Formats a given time value according to a format string.
##
## fmt: The format string. See ``man strftime`` for the syntax.
##
## d: The time value.
##
## Returns: The time *d* formatted according to *fmt*.
global strftime: function(fmt: string , d: time ) : string ;



## Parse a textual representation of a date/time value into a ``time`` type value.
##
## fmt: The format string used to parse the following *d* argument. See ``man strftime``
##      for the syntax.
##
## d: The string representing the time.
##
## Returns: The time value calculated from parsing *d* with *fmt*.
global strptime: function(fmt: string , d: string ) : time ;









## Masks an address down to the number of given upper bits. For example,
## ``mask_addr(1.2.3.4, 18)`` returns ``1.2.0.0``.
##
## a: The address to mask.
##
## top_bits_to_keep: The number of top bits to keep in *a*; must be greater
##                   than 0 and less than 33 for IPv4, or 129 for IPv6.
##
## Returns: The address *a* masked down to *top_bits_to_keep* bits.
##
## .. zeek:see:: remask_addr
global mask_addr: function(a: addr , top_bits_to_keep: count ): subnet ;


## Takes some top bits (such as a subnet address) from one address and the other
## bits (intra-subnet part) from a second address and merges them to get a new
## address. This is useful for anonymizing at subnet level while preserving
## serial scans.
##
## a1: The address to mask with *top_bits_from_a1*.
##
## a2: The address to take the remaining bits from.
##
## top_bits_from_a1: The number of top bits to keep in *a1*; must be greater
##                   than 0 and less than 129.  This value is always interpreted
##                   relative to the IPv6 bit width (v4-mapped addresses start
##                   at bit number 96).
##
## Returns: The address *a* masked down to *top_bits_to_keep* bits.
##
## .. zeek:see:: mask_addr
global remask_addr: function(a1: addr , a2: addr , top_bits_from_a1: count ): addr ;


## Checks whether a given :zeek:type:`port` has TCP as transport protocol.
##
## p: The :zeek:type:`port` to check.
##
## Returns: True iff *p* is a TCP port.
##
## .. zeek:see:: is_udp_port is_icmp_port
global is_tcp_port: function(p: port ): bool ;


## Checks whether a given :zeek:type:`port` has UDP as transport protocol.
##
## p: The :zeek:type:`port` to check.
##
## Returns: True iff *p* is a UDP port.
##
## .. zeek:see:: is_icmp_port is_tcp_port
global is_udp_port: function(p: port ): bool ;


## Checks whether a given :zeek:type:`port` has ICMP as transport protocol.
##
## p: The :zeek:type:`port` to check.
##
## Returns: True iff *p* is an ICMP port.
##
## .. zeek:see:: is_tcp_port is_udp_port
global is_icmp_port: function(p: port ): bool ;




## Extracts the transport protocol from a connection.
##
## cid: The connection identifier.
##
## Returns: The transport protocol of the connection identified by *cid*.
##
## .. zeek:see:: get_port_transport_proto
##              get_orig_seq get_resp_seq
global get_conn_transport_proto: function(cid: conn_id ): transport_proto ;


## Extracts the transport protocol from a :zeek:type:`port`.
##
## p: The port.
##
## Returns: The transport protocol of the port *p*.
##
## .. zeek:see:: get_conn_transport_proto
##              get_orig_seq get_resp_seq
global get_port_transport_proto: function(p: port ): transport_proto ;


## Checks whether a connection is (still) active.
##
## c: The connection id to check.
##
## Returns: True if the connection identified by *c* exists.
##
## .. zeek:see:: lookup_connection
global connection_exists: function(c: conn_id ): bool ;


## Returns the :zeek:type:`connection` record for a given connection identifier.
##
## cid: The connection ID.
##
## Returns: The :zeek:type:`connection` record for *cid*. If *cid* does not point
##          to an existing connection, the function generates a run-time error
##          and returns a dummy value.
##
## .. zeek:see:: connection_exists
global lookup_connection: function(cid: conn_id ): connection ;




## Writes the current packet to a file.
##
## file_name: The name of the file to write the packet to.
##
## Returns: True on success.
##
## .. zeek:see:: dump_packet get_current_packet
global dump_current_packet: function(file_name: string ) : bool ;


## Returns the currently processed PCAP packet.
##
## Returns: The currently processed packet, which is a record
##          containing the timestamp, ``snaplen``, and packet data.
##
## .. zeek:see:: dump_current_packet dump_packet
global get_current_packet: function() : pcap_packet ;


## Function to get the raw headers of the currently processed packet.
##
## Returns: The :zeek:type:`raw_pkt_hdr` record containing the Layer 2, 3 and
##          4 headers of the currently processed packet.
##
## .. zeek:see:: raw_pkt_hdr get_current_packet
global get_current_packet_header: function() : raw_pkt_hdr ;


## Writes a given packet to a file.
##
## pkt: The PCAP packet.
##
## file_name: The name of the file to write *pkt* to.
##
## Returns: True on success
##
## .. zeek:see:: get_current_packet dump_current_packet
global dump_packet: function(pkt: pcap_packet , file_name: string ) : bool ;




## Issues an asynchronous reverse DNS lookup and delays the function result.
## This function can therefore only be called inside a ``when`` condition,
## e.g., ``when ( local host = lookup_addr(10.0.0.1) ) { f(host); }``.
##
## host: The IP address to lookup.
##
## Returns: The DNS name of *host*.
##
## .. zeek:see:: lookup_hostname
global lookup_addr: function(host: addr ) : string ;


## Issues an asynchronous TEXT DNS lookup and delays the function result.
## This function can therefore only be called inside a ``when`` condition,
## e.g., ``when ( local h = lookup_hostname_txt("www.zeek.org") ) { f(h); }``.
##
## host: The hostname to lookup.
##
## Returns: The DNS TXT record associated with *host*.
##
## .. zeek:see:: lookup_hostname
global lookup_hostname_txt: function(host: string ) : string ;


## Issues an asynchronous DNS lookup and delays the function result.
## This function can therefore only be called inside a ``when`` condition,
## e.g., ``when ( local h = lookup_hostname("www.zeek.org") ) { f(h); }``.
##
## host: The hostname to lookup.
##
## Returns: A set of DNS A and AAAA records associated with *host*.
##
## .. zeek:see:: lookup_addr
global lookup_hostname: function(host: string ) : addr_set ;




## Initializes MMDB for later use of lookup_location.
## Requires Zeek to be built with ``libmaxminddb``.
##
## f: The filename of the MaxMind City or Country DB.
##
## Returns: A boolean indicating whether the db was successfully opened.
##
## .. zeek:see:: lookup_asn lookup_autonomous_system
global mmdb_open_location_db: function(f: string ) : bool ;


## Initializes MMDB for later use of lookup_asn or lookup_autonomous_system.
## Requires Zeek to be built with ``libmaxminddb``.
##
## f: The filename of the MaxMind ASN DB.
##
## Returns: A boolean indicating whether the db was successfully opened.
##
## .. zeek:see:: lookup_asn lookup_autonomous_system
global mmdb_open_asn_db: function(f: string ) : bool ;


## Performs a geo-lookup of an IP address.
## Requires Zeek to be built with ``libmaxminddb``.
##
## a: The IP address to lookup.
##
## Returns: A record with country, region, city, latitude, and longitude.
##
## .. zeek:see:: lookup_asn lookup_autonomous_system
global lookup_location: function(a: addr ) : geo_location ;


## Performs an ASN lookup of an IP address.
## Requires Zeek to be built with ``libmaxminddb``.
##
## a: The IP address to lookup.
##
## Returns: The number of the ASN that contains the IP address.
##
## .. zeek:see:: lookup_location lookup_autonomous_system
global lookup_asn: function(a: addr ) : count &deprecated="Remove in v6.1.  Functionality is now handled by lookup_autonomous_system()."
	;


## Performs an lookup of AS numbe & organization of an IP address.
## Requires Zeek to be built with ``libmaxminddb``.
##
## a: The IP address to lookup.
##
## Returns: A record with autonomous system number and organization that contains *a*.
##
## .. zeek:see:: lookup_location lookup_asn
global lookup_autonomous_system: function(a: addr ) : geo_autonomous_system ;


## Calculates distance between two geographic locations using the haversine
## formula.  Latitudes and longitudes must be given in degrees, where southern
## hemispere latitudes are negative and western hemisphere longitudes are
## negative.
##
## lat1: Latitude (in degrees) of location 1.
##
## long1: Longitude (in degrees) of location 1.
##
## lat2: Latitude (in degrees) of location 2.
##
## long2: Longitude (in degrees) of location 2.
##
## Returns: Distance in miles.
##
## .. zeek:see:: haversine_distance_ip
global haversine_distance: function(lat1: double , long1: double , lat2: double , long2: double ): double ;


## Converts UNIX file permissions given by a mode to an ASCII string.
##
## mode: The permissions (an octal number like 0644 converted to decimal).
##
## Returns: A string representation of *mode* in the format
##          ``rw[xsS]rw[xsS]rw[xtT]``.
global file_mode: function(mode: count ): string ;










## Disables the analyzer which raised the current event (if the analyzer
## belongs to the given connection).
##
## cid: The connection identifier.
##
## aid: The analyzer ID.
##
## err_if_no_conn: Emit an error message if the connection does not exit.
##
## prevent: Prevent the same analyzer type from being attached in the future.
##          This is useful for preventing the same analyzer from being
##          automatically reattached in the future, e.g. as a result of a
##          DPD signature suddenly matching.
##
## Returns: True if the connection identified by *cid* exists and has analyzer
##          *aid* and it is scheduled for removal.
##
## .. zeek:see:: Analyzer::schedule_analyzer Analyzer::name
global disable_analyzer: function(cid: conn_id , aid: count , err_if_no_conn: bool &default=T, prevent: bool &default=F) : bool ;


## Informs Zeek that it should skip any further processing of the contents of
## a given connection. In particular, Zeek will refrain from reassembling the
## TCP byte stream and from generating events relating to any analyzers that
## have been processing the connection.
##
## cid: The connection ID.
##
## Returns: False if *cid* does not point to an active connection, and true
##          otherwise.
##
## .. note::
##
##     Zeek will still generate connection-oriented events such as
##     :zeek:id:`connection_finished`.
global skip_further_processing: function(cid: conn_id ): bool ;


## Controls whether packet contents belonging to a connection should be
## recorded (when ``-w`` option is provided on the command line).
##
## cid: The connection identifier.
##
## do_record: True to enable packet contents, and false to disable for the
##            connection identified by *cid*.
##
## Returns: False if *cid* does not point to an active connection, and true
##          otherwise.
##
## .. zeek:see:: skip_further_processing
##
## .. note::
##
##     This is independent of whether Zeek processes the packets of this
##     connection, which is controlled separately by
##     :zeek:id:`skip_further_processing`.
##
## .. zeek:see:: get_contents_file set_contents_file
global set_record_packets: function(cid: conn_id , do_record: bool ): bool ;


## Sets an individual inactivity timeout for a connection and thus
## overrides the global inactivity timeout.
##
## cid: The connection ID.
##
## t: The new inactivity timeout for the connection identified by *cid*.
##
## Returns: The previous timeout interval.
global set_inactivity_timeout: function(cid: conn_id , t: interval ): interval ;








## Opens a file for writing. If a file with the same name already exists, this
## function overwrites it (as opposed to :zeek:id:`open_for_append`).
##
## f: The path to the file.
##
## Returns: A :zeek:type:`file` handle for subsequent operations.
##
## .. zeek:see:: active_file open_for_append close write_file
##              get_file_name set_buf flush_all mkdir enable_raw_output
##              rmdir unlink rename
global open: function(f: string ): file ;


## Opens a file for writing or appending. If a file with the same name already
## exists, this function appends to it (as opposed to :zeek:id:`open`).
##
## f: The path to the file.
##
## Returns: A :zeek:type:`file` handle for subsequent operations.
##
## .. zeek:see:: active_file open close write_file
##              get_file_name set_buf flush_all mkdir enable_raw_output
##              rmdir unlink rename
global open_for_append: function(f: string ): file ;


## Closes an open file and flushes any buffered content.
##
## f: A :zeek:type:`file` handle to an open file.
##
## Returns: True on success.
##
## .. zeek:see:: active_file open open_for_append write_file
##              get_file_name set_buf flush_all mkdir enable_raw_output
##              rmdir unlink rename
global close: function(f: file ): bool ;


## Writes data to an open file.
##
## f: A :zeek:type:`file` handle to an open file.
##
## data: The data to write to *f*.
##
## Returns: True on success.
##
## .. zeek:see:: active_file open open_for_append close
##              get_file_name set_buf flush_all mkdir enable_raw_output
##              rmdir unlink rename
global write_file: function(f: file , data: string ): bool ;


## Alters the buffering behavior of a file.
##
## f: A :zeek:type:`file` handle to an open file.
##
## buffered: When true, *f* is fully buffered, i.e., bytes are saved in a
##           buffer until the block size has been reached. When
##           false, *f* is line buffered, i.e., bytes are saved up until a
##           newline occurs.
##
## .. zeek:see:: active_file open open_for_append close
##              get_file_name write_file flush_all mkdir enable_raw_output
##              rmdir unlink rename
global set_buf: function(f: file , buffered: bool ): any ;


## Flushes all open files to disk.
##
## Returns: True on success.
##
## .. zeek:see:: active_file open open_for_append close
##              get_file_name write_file set_buf mkdir enable_raw_output
##              rmdir unlink rename
global flush_all: function(): bool ;


## Creates a new directory.
##
## f: The directory name.
##
## Returns: True if the operation succeeds or if *f* already exists,
##          and false if the file creation fails.
##
## .. zeek:see:: active_file open_for_append close write_file
##              get_file_name set_buf flush_all enable_raw_output
##              rmdir unlink rename
global mkdir: function(f: string ): bool ;



## Removes a directory.
##
## d: The directory name.
##
## Returns: True if the operation succeeds, and false if the
##          directory delete operation fails.
##
## .. zeek:see:: active_file open_for_append close write_file
##              get_file_name set_buf flush_all enable_raw_output
##              mkdir unlink rename
global rmdir: function(d: string ): bool ;


## Removes a file from a directory.
##
## f: the file to delete.
##
## Returns: True if the operation succeeds and the file was deleted,
##          and false if the deletion fails.
##
## .. zeek:see:: active_file open_for_append close write_file
##              get_file_name set_buf flush_all enable_raw_output
##              mkdir rmdir rename
global unlink: function(f: string ): bool ;


## Renames a file from src_f to dst_f.
##
## src_f: the name of the file to rename.
##
## dest_f: the name of the file after the rename operation.
##
## Returns: True if the rename succeeds and false otherwise.
##
## .. zeek:see:: active_file open_for_append close write_file
##              get_file_name set_buf flush_all enable_raw_output
##              mkdir rmdir unlink
global rename: function(src_f: string , dst_f: string ): bool ;


## Checks whether a given file is open.
##
## f: The file to check.
##
## Returns: True if *f* is an open :zeek:type:`file`.
##
## .. todo:: Rename to ``is_open``.
global active_file: function(f: file ): bool ;


## Gets the filename associated with a file handle.
##
## f: The file handle to inquire the name for.
##
## Returns: The filename associated with *f*.
##
## .. zeek:see:: open
global get_file_name: function(f: file ): string ;


## Rotates a file.
##
## f: An open file handle.
##
## Returns: Rotation statistics which include the original file name, the name
##          after the rotation, and the time when *f* was opened/closed.
##
## .. zeek:see:: rotate_file_by_name calc_next_rotate
global rotate_file: function(f: file ): rotate_info ;


## Rotates a file identified by its name.
##
## f: The name of the file to rotate
##
## Returns: Rotation statistics which include the original file name, the name
##          after the rotation, and the time when *f* was opened/closed.
##
## .. zeek:see:: rotate_file calc_next_rotate
global rotate_file_by_name: function(f: string ): rotate_info ;


## Calculates the duration until the next time a file is to be rotated, based
## on a given rotate interval.
##
## i: The rotate interval to base the calculation on.
##
## Returns: The duration until the next file rotation time.
##
## .. zeek:see:: rotate_file rotate_file_by_name
global calc_next_rotate: function(i: interval ) : interval ;


## Returns the size of a given file.
##
## f: The name of the file whose size to lookup.
##
## Returns: The size of *f* in bytes.
global file_size: function(f: string ) : double ;


## Prevents escaping of non-ASCII characters when writing to a file.
## This function is equivalent to :zeek:attr:`&raw_output`.
##
## f: The file to disable raw output for.
global enable_raw_output: function(f: file ): any ;








## Installs a filter to drop packets from a given IP source address with
## a certain probability if none of a given set of TCP flags are set.
## Note that for IPv6 packets with a Destination options header that has
## the Home Address option, this filters out against that home address.
##
## ip: The IP address to drop.
##
## tcp_flags: If none of these TCP flags are set, drop packets from *ip* with
##            probability *prob*.
##
## prob: The probability [0.0, 1.0] used to drop packets from *ip*.
##
## Returns: True (unconditionally).
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
##
## .. todo:: The return value should be changed to any.
global install_src_addr_filter: function(ip: addr , tcp_flags: count , prob: double ) : bool ;


## Installs a filter to drop packets originating from a given subnet with
## a certain probability if none of a given set of TCP flags are set.
##
## snet: The subnet to drop packets from.
##
## tcp_flags: If none of these TCP flags are set, drop packets from *snet* with
##            probability *prob*.
##
## prob: The probability [0.0, 1.0] used to drop packets from *snet*.
##
## Returns: True (unconditionally).
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
##
## .. todo:: The return value should be changed to any.
global install_src_net_filter: function(snet: subnet , tcp_flags: count , prob: double ) : bool ;


## Removes a source address filter.
##
## ip: The IP address for which a source filter was previously installed.
##
## Returns: True on success.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
global uninstall_src_addr_filter: function(ip: addr ) : bool ;


## Removes a source subnet filter.
##
## snet: The subnet for which a source filter was previously installed.
##
## Returns: True on success.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
global uninstall_src_net_filter: function(snet: subnet ) : bool ;


## Installs a filter to drop packets destined to a given IP address with
## a certain probability if none of a given set of TCP flags are set.
## Note that for IPv6 packets with a routing type header and non-zero
## segments left, this filters out against the final destination of the
## packet according to the routing extension header.
##
## ip: Drop packets to this IP address.
##
## tcp_flags: If none of these TCP flags are set, drop packets to *ip* with
##            probability *prob*.
##
## prob: The probability [0.0, 1.0] used to drop packets to *ip*.
##
## Returns: True (unconditionally).
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
##
## .. todo:: The return value should be changed to any.
global install_dst_addr_filter: function(ip: addr , tcp_flags: count , prob: double ) : bool ;


## Installs a filter to drop packets destined to a given subnet with
## a certain probability if none of a given set of TCP flags are set.
##
## snet: Drop packets to this subnet.
##
## tcp_flags: If none of these TCP flags are set, drop packets to *snet* with
##            probability *prob*.
##
## prob: The probability [0.0, 1.0] used to drop packets to *snet*.
##
## Returns: True (unconditionally).
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
##
## .. todo:: The return value should be changed to any.
global install_dst_net_filter: function(snet: subnet , tcp_flags: count , prob: double ) : bool ;


## Removes a destination address filter.
##
## ip: The IP address for which a destination filter was previously installed.
##
## Returns: True on success.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_net_filter
##              Pcap::error
global uninstall_dst_addr_filter: function(ip: addr ) : bool ;


## Removes a destination subnet filter.
##
## snet: The subnet for which a destination filter was previously installed.
##
## Returns: True on success.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              Pcap::error
global uninstall_dst_net_filter: function(snet: subnet ) : bool ;


## Checks whether the last raised event came from a remote peer.
##
## Returns: True if the last raised event came from a remote peer.
global is_remote_event: function() : bool ;


## Stops Zeek's packet processing. This function is used to synchronize
## distributed trace processing with communication enabled
## (*pseudo-realtime* mode).
##
## .. zeek:see:: continue_processing
##               is_processing_suspended
global suspend_processing: function() : any ;


## Resumes Zeek's packet processing.
##
## .. zeek:see:: suspend_processing
##               is_processing_suspended
global continue_processing: function() : any ;


## Returns whether or not processing is currently suspended.
##
## .. zeek:see:: suspend_processing
##               continue_processing
global is_processing_suspended: function(): bool ;








## Manually triggers the signature engine for a given connection.
## This is an internal function.
global match_signatures: function(c: connection , pattern_type: int , s: string , bol: bool , eol: bool , from_orig: bool , clear: bool ) : bool ;


## By default, zeek does not generate (raise) events that have not handled by
## any scripts. This means that these events will be invisible to a lot of other
## event handlers - and will not raise :zeek:id:`new_event`.
##
## Calling this function will cause all event handlers to be raised. This is, likely,
## only useful for debugging and causes reduced performance.
global generate_all_events: function() : bool ;




## An internal function that helps initialize BIFs.
global __init_secondary_bifs: function(): bool ;













## Preserves the prefix of an IP address in anonymization.
##
## a: The address to preserve.
##
## width: The number of bits from the top that should remain intact.
##
## .. zeek:see:: preserve_subnet anonymize_addr
##
## .. todo:: Currently dysfunctional.
global preserve_prefix: function(a: addr , width: count ): any ;


## Preserves the prefix of a subnet in anonymization.
##
## a: The subnet to preserve.
##
## .. zeek:see:: preserve_prefix anonymize_addr
##
## .. todo:: Currently dysfunctional.
global preserve_subnet: function(a: subnet ): any ;


## Anonymizes an IP address.
##
## a: The address to anonymize.
##
## cl: The anonymization class, which can take on three different values:
##
##     - ``ORIG_ADDR``: Tag *a* as an originator address.
##
##     - ``RESP_ADDR``: Tag *a* as an responder address.
##
##     - ``OTHER_ADDR``: Tag *a* as an arbitrary address.
##
## Returns: An anonymized version of *a*.
##
## .. zeek:see:: preserve_prefix preserve_subnet
##
## .. todo:: Currently dysfunctional.
global anonymize_addr: function(a: addr , cl: IPAddrAnonymizationClass ): addr ;


## A function to convert arbitrary Zeek data into a JSON string.
##
## v: The value to convert to JSON.  Typically a record.
##
## only_loggable: If the v value is a record this will only cause
##                fields with the &log attribute to be included in the JSON.
##
## returns: a JSON formatted string.
##
## .. zeek:see:: fmt cat cat_sep string_cat print_raw
global to_json: function(val: any , only_loggable: bool &default=F, field_escape_pattern: pattern &default=/^_/): string ;


## Compresses a given path by removing '..'s and the parent directory it
## references and also removing dual '/'s and extraneous '/./'s.
##
## dir: a path string, either relative or absolute.
##
## Returns: a compressed version of the input path.
global compress_path: function(dir: string ): string ;

} # end of export section
module GLOBAL;
