/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import java.util.List;

public class CipherSuiteFilter {
    public static void filterCipherSuites(List<CipherSuite> cipherSuites) {
        KeyExchangeAlgorithm algorithm = AlgorithmResolver.getKeyExchangeAlgorithm(cipherSuites.get(0));
        boolean ephemeral = cipherSuites.get(0).isEphemeral();
        for (int i = cipherSuites.size() - 1; i > 0; --i) {
            CipherSuite cs = cipherSuites.get(i);
            if (AlgorithmResolver.getKeyExchangeAlgorithm(cs) == algorithm && cs.isEphemeral() == ephemeral) continue;
            cipherSuites.remove(i);
        }
    }

    private CipherSuiteFilter() {
    }
}

