-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
-- Generated on: 2022-10-08 18:38:05
--           by: ../../utils/create_unpackaged.pl
--          for: postgis
--         from: -
--
-- Do not edit manually, your changes will be lost.
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

-- complain if script is sourced in psql
\echo Use "CREATE EXTENSION postgis" to load this file. \quit

-- Register all views.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW geography_columns;
	RAISE NOTICE 'newly registered VIEW geography_columns';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW geography_columns';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW geography_columns does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW geography_columns to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD VIEW geometry_columns;
	RAISE NOTICE 'newly registered VIEW geometry_columns';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered VIEW geometry_columns';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object VIEW geometry_columns does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add VIEW geometry_columns to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all tables.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TABLE spatial_ref_sys;
	RAISE NOTICE 'newly registered TABLE spatial_ref_sys';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TABLE spatial_ref_sys';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TABLE spatial_ref_sys does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TABLE spatial_ref_sys to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all sequences.
-- Register all aggregates.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Extent (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Extent (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Extent (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Extent (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Extent (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_3DExtent (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_3DExtent (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_3DExtent (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_3DExtent (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_3DExtent (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MemCollect (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MemCollect (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MemCollect (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MemCollect (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MemCollect (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MemUnion (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MemUnion (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MemUnion (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MemUnion (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MemUnion (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Union (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Union (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Union (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Union (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Union (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Union (geometry, gridSize float8);
	RAISE NOTICE 'newly registered AGGREGATE ST_Union (geometry, gridSize float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Union (geometry, gridSize float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Union (geometry, gridSize float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Union (geometry, gridSize float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Collect (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Collect (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Collect (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Collect (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Collect (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_ClusterIntersecting (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_ClusterIntersecting (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_ClusterIntersecting (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_ClusterIntersecting (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_ClusterIntersecting (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_ClusterWithin (geometry, float8);
	RAISE NOTICE 'newly registered AGGREGATE ST_ClusterWithin (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_ClusterWithin (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_ClusterWithin (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_ClusterWithin (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_Polygonize (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_Polygonize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_Polygonize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_Polygonize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_Polygonize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_MakeLine (geometry);
	RAISE NOTICE 'newly registered AGGREGATE ST_MakeLine (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_MakeLine (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_MakeLine (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_MakeLine (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text, integer);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text, integer, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text, integer, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text, integer, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text, integer, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text, integer, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsMVT (anyelement, text, integer, text, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsMVT (anyelement, text, integer, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsMVT (anyelement, text, integer, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsMVT (anyelement, text, integer, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsMVT (anyelement, text, integer, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsGeobuf (anyelement);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsGeobuf (anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsGeobuf (anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsGeobuf (anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsGeobuf (anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsGeobuf (anyelement, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsGeobuf (anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsGeobuf (anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsGeobuf (anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsGeobuf (anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsFlatGeobuf (anyelement);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsFlatGeobuf (anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsFlatGeobuf (anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsFlatGeobuf (anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsFlatGeobuf (anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsFlatGeobuf (anyelement, bool);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsFlatGeobuf (anyelement, bool)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsFlatGeobuf (anyelement, bool)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsFlatGeobuf (anyelement, bool) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsFlatGeobuf (anyelement, bool) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD AGGREGATE ST_AsFlatGeobuf (anyelement, bool, text);
	RAISE NOTICE 'newly registered AGGREGATE ST_AsFlatGeobuf (anyelement, bool, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered AGGREGATE ST_AsFlatGeobuf (anyelement, bool, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object AGGREGATE ST_AsFlatGeobuf (anyelement, bool, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add AGGREGATE ST_AsFlatGeobuf (anyelement, bool, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all operators classes and families.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS btree_geometry_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR CLASS btree_geometry_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS btree_geometry_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS btree_geometry_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS btree_geometry_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY btree_geometry_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR FAMILY btree_geometry_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY btree_geometry_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY btree_geometry_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY btree_geometry_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS hash_geometry_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR CLASS hash_geometry_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS hash_geometry_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS hash_geometry_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS hash_geometry_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY hash_geometry_ops USING hash;
	RAISE NOTICE 'newly registered OPERATOR FAMILY hash_geometry_ops USING hash';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY hash_geometry_ops USING hash';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY hash_geometry_ops USING hash does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY hash_geometry_ops USING hash to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geometry_ops_2d USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geometry_ops_2d USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geometry_ops_2d USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geometry_ops_2d USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geometry_ops_2d USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geometry_ops_2d USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geometry_ops_2d USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geometry_ops_2d USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geometry_ops_2d USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geometry_ops_2d USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geometry_ops_nd USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geometry_ops_nd USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geometry_ops_nd USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geometry_ops_nd USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geometry_ops_nd USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geometry_ops_nd USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geometry_ops_nd USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geometry_ops_nd USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geometry_ops_nd USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geometry_ops_nd USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS gist_geography_ops USING GIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS gist_geography_ops USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS gist_geography_ops USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS gist_geography_ops USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS gist_geography_ops USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY gist_geography_ops USING GIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY gist_geography_ops USING GIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY gist_geography_ops USING GIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY gist_geography_ops USING GIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY gist_geography_ops USING GIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geography_inclusion_ops USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geography_inclusion_ops USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geography_inclusion_ops USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geography_inclusion_ops USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geography_inclusion_ops USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geography_inclusion_ops USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geography_inclusion_ops USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geography_inclusion_ops USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geography_inclusion_ops USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geography_inclusion_ops USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS btree_geography_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR CLASS btree_geography_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS btree_geography_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS btree_geography_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS btree_geography_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY btree_geography_ops USING btree;
	RAISE NOTICE 'newly registered OPERATOR FAMILY btree_geography_ops USING btree';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY btree_geography_ops USING btree';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY btree_geography_ops USING btree does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY btree_geography_ops USING btree to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_2d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_2d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_3d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_3d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin;
	RAISE NOTICE 'newly registered OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS brin_geometry_inclusion_ops_4d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin;
	RAISE NOTICE 'newly registered OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY brin_geometry_inclusion_ops_4d USING brin to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geometry_ops_2d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geometry_ops_2d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geometry_ops_3d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geometry_ops_3d USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geometry_ops_nd USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geometry_ops_nd USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geometry_ops_nd USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geometry_ops_nd USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geometry_ops_nd USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geometry_ops_nd USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geometry_ops_nd USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geometry_ops_nd USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geometry_ops_nd USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geometry_ops_nd USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR CLASS spgist_geography_ops_nd USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR CLASS spgist_geography_ops_nd USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR CLASS spgist_geography_ops_nd USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR CLASS spgist_geography_ops_nd USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR CLASS spgist_geography_ops_nd USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR FAMILY spgist_geography_ops_nd USING SPGIST;
	RAISE NOTICE 'newly registered OPERATOR FAMILY spgist_geography_ops_nd USING SPGIST';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR FAMILY spgist_geography_ops_nd USING SPGIST';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR FAMILY spgist_geography_ops_nd USING SPGIST does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR FAMILY spgist_geography_ops_nd USING SPGIST to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all operators.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR =  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR =  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR =  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR =  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR =  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <->  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <->  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <->  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <->  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <->  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <#>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <#>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <#>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <#>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <#>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR @  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &<  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &<|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &<|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &<|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &<|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &<|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR >>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |&>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |&>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |&>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |&>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |&>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |>>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |>>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |>>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |>>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |>>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~~  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~~  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~~  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~~  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~~  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @@  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR @@  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @@  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @@  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @@  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~~=  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~~=  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~~=  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~~=  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~~=  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<->>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<->>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<->>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<->>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<->>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR |=|  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR |=|  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR |=|  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR |=|  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR |=|  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR &&  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <->  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <->  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <->  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <->  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <->  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (gidx,geography);
	RAISE NOTICE 'newly registered OPERATOR &&  (gidx,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (gidx,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (gidx,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (gidx,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geography,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&  (geography,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geography,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geography,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geography,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (gidx,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&  (gidx,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (gidx,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (gidx,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (gidx,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <=  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR <=  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <=  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <=  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <=  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR =  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR =  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR =  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR =  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR =  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >=  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR >=  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >=  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >=  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >=  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR >  (geography,geography);
	RAISE NOTICE 'newly registered OPERATOR >  (geography,geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR >  (geography,geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR >  (geography,geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR >  (geography,geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR @  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (box2df,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&  (box2df,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (box2df,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (box2df,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (box2df,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR ~  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR @  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (geometry,box2df);
	RAISE NOTICE 'newly registered OPERATOR &&  (geometry,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (geometry,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (geometry,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (geometry,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR &&  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR @  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~  (box2df,box2df);
	RAISE NOTICE 'newly registered OPERATOR ~  (box2df,box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~  (box2df,box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~  (box2df,box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~  (box2df,box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (gidx,geometry);
	RAISE NOTICE 'newly registered OPERATOR &&&  (gidx,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (gidx,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (gidx,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (gidx,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (geometry,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&&  (geometry,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (geometry,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (geometry,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (geometry,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &&&  (gidx,gidx);
	RAISE NOTICE 'newly registered OPERATOR &&&  (gidx,gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &&&  (gidx,gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &&&  (gidx,gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &&&  (gidx,gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR &/&  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR &/&  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR &/&  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR &/&  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR &/&  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR @>>  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR @>>  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR @>>  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR @>>  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR @>>  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR <<@  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR <<@  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR <<@  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR <<@  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR <<@  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD OPERATOR ~==  (geometry,geometry);
	RAISE NOTICE 'newly registered OPERATOR ~==  (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered OPERATOR ~==  (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object OPERATOR ~==  (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add OPERATOR ~==  (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all casts.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS geometry);
	RAISE NOTICE 'newly registered CAST (geometry AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS point);
	RAISE NOTICE 'newly registered CAST (geometry AS point)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS point)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS point) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS point) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (point AS geometry);
	RAISE NOTICE 'newly registered CAST (point AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (point AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (point AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (point AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS path);
	RAISE NOTICE 'newly registered CAST (geometry AS path)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS path)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS path) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS path) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (path AS geometry);
	RAISE NOTICE 'newly registered CAST (path AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (path AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (path AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (path AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS polygon);
	RAISE NOTICE 'newly registered CAST (geometry AS polygon)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS polygon)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS polygon) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS polygon) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (polygon AS geometry);
	RAISE NOTICE 'newly registered CAST (polygon AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (polygon AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (polygon AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (polygon AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box2d);
	RAISE NOTICE 'newly registered CAST (geometry AS box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box3d);
	RAISE NOTICE 'newly registered CAST (geometry AS box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS box);
	RAISE NOTICE 'newly registered CAST (geometry AS box)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS box)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS box) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS box) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS box2d);
	RAISE NOTICE 'newly registered CAST (box3d AS box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box2d AS box3d);
	RAISE NOTICE 'newly registered CAST (box2d AS box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box2d AS box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box2d AS box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box2d AS box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box2d AS geometry);
	RAISE NOTICE 'newly registered CAST (box2d AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box2d AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box2d AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box2d AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS box);
	RAISE NOTICE 'newly registered CAST (box3d AS box)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS box)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS box) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS box) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (box3d AS geometry);
	RAISE NOTICE 'newly registered CAST (box3d AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (box3d AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (box3d AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (box3d AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (text AS geometry);
	RAISE NOTICE 'newly registered CAST (text AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (text AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (text AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (text AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS text);
	RAISE NOTICE 'newly registered CAST (geometry AS text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (bytea AS geometry);
	RAISE NOTICE 'newly registered CAST (bytea AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (bytea AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (bytea AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (bytea AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS bytea);
	RAISE NOTICE 'newly registered CAST (geometry AS bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS json);
	RAISE NOTICE 'newly registered CAST (geometry AS json)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS json)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS json) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS json) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS jsonb);
	RAISE NOTICE 'newly registered CAST (geometry AS jsonb)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS jsonb)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS jsonb) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS jsonb) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS geography);
	RAISE NOTICE 'newly registered CAST (geography AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (bytea AS geography);
	RAISE NOTICE 'newly registered CAST (bytea AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (bytea AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (bytea AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (bytea AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS bytea);
	RAISE NOTICE 'newly registered CAST (geography AS bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geometry AS geography);
	RAISE NOTICE 'newly registered CAST (geometry AS geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geometry AS geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geometry AS geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geometry AS geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD CAST (geography AS geometry);
	RAISE NOTICE 'newly registered CAST (geography AS geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered CAST (geography AS geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object CAST (geography AS geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add CAST (geography AS geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all functions except 24 needed for type definition.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_deprecate (oldname text, newname text, version text);
	RAISE NOTICE 'newly registered FUNCTION _postgis_deprecate (oldname text, newname text, version text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_deprecate (oldname text, newname text, version text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_deprecate (oldname text, newname text, version text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_deprecate (oldname text, newname text, version text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (geometry, integer, boolean);
	RAISE NOTICE 'newly registered FUNCTION geometry (geometry, integer, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (geometry, integer, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (geometry, integer, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (geometry, integer, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (point);
	RAISE NOTICE 'newly registered FUNCTION geometry (point)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (point)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (point) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (point) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION point (geometry);
	RAISE NOTICE 'newly registered FUNCTION point (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION point (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION point (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION point (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (path);
	RAISE NOTICE 'newly registered FUNCTION geometry (path)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (path)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (path) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (path) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION path (geometry);
	RAISE NOTICE 'newly registered FUNCTION path (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION path (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION path (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION path (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (polygon);
	RAISE NOTICE 'newly registered FUNCTION geometry (polygon)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (polygon)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (polygon) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (polygon) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION polygon (geometry);
	RAISE NOTICE 'newly registered FUNCTION polygon (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION polygon (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION polygon (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION polygon (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_X (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_X (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_X (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_X (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_X (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Y (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Y (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Y (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Y (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Y (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Z (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Z (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Z (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Z (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Z (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_M (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_M (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_M (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_M (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_M (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_lt (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_lt (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_lt (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_lt (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_lt (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_le (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_le (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_le (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_le (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_le (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gt (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_gt (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gt (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gt (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gt (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_ge (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_ge (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_ge (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_ge (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_ge (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_eq (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_eq (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_eq (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_eq (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_eq (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_cmp (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_cmp (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_cmp (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_cmp (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_cmp (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_sortsupport (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_sortsupport (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_sortsupport (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_sortsupport (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_sortsupport (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_hash (geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_hash (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_hash (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_hash (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_hash (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_distance_2d (internal,geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_distance_2d (internal,geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_distance_2d (internal,geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_distance_2d (internal,geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_distance_2d (internal,geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_consistent_2d (internal,geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_consistent_2d (internal,geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_consistent_2d (internal,geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_consistent_2d (internal,geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_consistent_2d (internal,geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_compress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_compress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_compress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_compress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_compress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_penalty_2d (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_penalty_2d (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_penalty_2d (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_penalty_2d (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_penalty_2d (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_picksplit_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_picksplit_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_picksplit_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_picksplit_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_picksplit_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_union_2d (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_union_2d (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_union_2d (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_union_2d (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_union_2d (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_same_2d (geom1 geometry, geom2 geometry, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_decompress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_decompress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_decompress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_decompress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_decompress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_sortsupport_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_sortsupport_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_sortsupport_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_sortsupport_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_sortsupport_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_selectivity (tbl regclass, att_name text, geom geometry, mode text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_join_selectivity (regclass, text, regclass, text, text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_stats (tbl regclass, att_name text, text );
	RAISE NOTICE 'newly registered FUNCTION _postgis_stats (tbl regclass, att_name text, text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_stats (tbl regclass, att_name text, text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_stats (tbl regclass, att_name text, text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_stats (tbl regclass, att_name text, text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_index_extent (tbl regclass, col text);
	RAISE NOTICE 'newly registered FUNCTION _postgis_index_extent (tbl regclass, col text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_index_extent (tbl regclass, col text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_index_extent (tbl regclass, col text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_index_extent (tbl regclass, col text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, integer);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_sel_2d  (internal, oid, internal, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, integer);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_sel_nd  (internal, oid, internal, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_joinsel_2d  (internal, oid, internal, smallint) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint);
	RAISE NOTICE 'newly registered FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gserialized_gist_joinsel_nd  (internal, oid, internal, smallint) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_same (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_same (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_same (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_same (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_same (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_centroid (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_box (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_left (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_left (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_left (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_left (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_left (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overleft (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overleft (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overleft (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overleft (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overleft (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_below (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_below (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_below (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_below (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_below (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overbelow (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overright (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overright (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overright (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overright (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overright (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_right (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_right (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_right (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_right (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_right (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overabove (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overabove (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overabove (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overabove (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overabove (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_above (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_above (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_above (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_above (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_above (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_consistent_nd (internal,geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_consistent_nd (internal,geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_consistent_nd (internal,geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_consistent_nd (internal,geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_consistent_nd (internal,geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_compress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_compress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_compress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_compress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_compress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_penalty_nd (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_penalty_nd (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_penalty_nd (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_penalty_nd (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_penalty_nd (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_picksplit_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_picksplit_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_picksplit_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_picksplit_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_picksplit_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_union_nd (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_union_nd (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_union_nd (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_union_nd (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_union_nd (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_same_nd (geometry, geometry, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_same_nd (geometry, geometry, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_same_nd (geometry, geometry, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_same_nd (geometry, geometry, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_same_nd (geometry, geometry, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_decompress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_decompress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_decompress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_decompress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_decompress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps_nd (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps_nd (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps_nd (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps_nd (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps_nd (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contains_nd (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contains_nd (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contains_nd (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contains_nd (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contains_nd (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_within_nd (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_within_nd (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_within_nd (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_within_nd (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_within_nd (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_same_nd (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_same_nd (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_same_nd (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_same_nd (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_same_nd (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_centroid_nd (geometry,geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_centroid_nd (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_centroid_nd (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_centroid_nd (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_centroid_nd (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_distance_cpa (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_distance_cpa (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_distance_cpa (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_distance_cpa (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_distance_cpa (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_gist_distance_nd (internal,geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION geometry_gist_distance_nd (internal,geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_gist_distance_nd (internal,geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_gist_distance_nd (internal,geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_gist_distance_nd (internal,geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ShiftLongitude (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ShiftLongitude (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ShiftLongitude (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ShiftLongitude (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ShiftLongitude (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WrapX (geom geometry, wrap float8, move float8);
	RAISE NOTICE 'newly registered FUNCTION ST_WrapX (geom geometry, wrap float8, move float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WrapX (geom geometry, wrap float8, move float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WrapX (geom geometry, wrap float8, move float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WrapX (geom geometry, wrap float8, move float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_XMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_XMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_XMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_XMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_XMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_YMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_YMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_YMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_YMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_YMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ZMin (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_ZMin (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ZMin (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ZMin (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ZMin (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_XMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_XMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_XMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_XMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_XMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_YMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_YMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_YMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_YMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_YMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ZMax (box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_ZMax (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ZMax (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ZMax (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ZMax (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box2d,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box2d,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box2d,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box2d,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box2d,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box box2d, dx float8, dy float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box box2d, dx float8, dy float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box box2d, dx float8, dy float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box box2d, dx float8, dy float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box box2d, dx float8, dy float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_getbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_getbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_getbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_getbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_getbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeBox2d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text,text,boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text,text,boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text,text,boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text,text,boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text,text,boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EstimatedExtent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_EstimatedExtent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EstimatedExtent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EstimatedExtent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EstimatedExtent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FindExtent (text,text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_FindExtent (text,text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FindExtent (text,text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FindExtent (text,text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FindExtent (text,text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FindExtent (text,text);
	RAISE NOTICE 'newly registered FUNCTION ST_FindExtent (text,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FindExtent (text,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FindExtent (text,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FindExtent (text,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_addbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_addbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_addbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_addbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_addbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_dropbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_dropbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_dropbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_dropbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_dropbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_hasbbox (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_hasbbox (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_hasbbox (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_hasbbox (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_hasbbox (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int );
	RAISE NOTICE 'newly registered FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_QuantizeCoordinates (g geometry, prec_x int, prec_y int , prec_z int , prec_m int ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MemSize (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MemSize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MemSize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MemSize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MemSize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Summary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Summary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Summary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Summary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Summary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NPoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NPoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NPoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NPoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NPoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NRings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NRings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NRings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NRings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NRings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLength (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLength (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLength (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLength (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLength (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Length2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Length (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LengthSpheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_LengthSpheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LengthSpheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LengthSpheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LengthSpheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length2DSpheroid (geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_Length2DSpheroid (geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length2DSpheroid (geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length2DSpheroid (geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length2DSpheroid (geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DPerimeter (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DPerimeter (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DPerimeter (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DPerimeter (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DPerimeter (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_perimeter2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_perimeter2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_perimeter2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_perimeter2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_perimeter2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Perimeter (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Perimeter (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Perimeter (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Perimeter (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Perimeter (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area2D (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Area2D (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area2D (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area2D (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area2D (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Area (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsPolygonCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsPolygonCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsPolygonCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsPolygonCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsPolygonCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsPolygonCCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsPolygonCCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsPolygonCCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsPolygonCCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsPolygonCCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry, spheroid);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry, spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry, spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry, spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry, spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSpheroid (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointInsideCircle (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_azimuth (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_azimuth (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_azimuth (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_azimuth (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_azimuth (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Angle (pt1 geometry, pt2 geometry, pt3 geometry, pt4 geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force2D (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Force2D (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force2D (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force2D (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force2D (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3DZ (geom geometry, zvalue float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Force3DZ (geom geometry, zvalue float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3DZ (geom geometry, zvalue float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3DZ (geom geometry, zvalue float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3DZ (geom geometry, zvalue float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3D (geom geometry, zvalue float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Force3D (geom geometry, zvalue float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3D (geom geometry, zvalue float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3D (geom geometry, zvalue float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3D (geom geometry, zvalue float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force3DM (geom geometry, mvalue float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Force3DM (geom geometry, mvalue float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force3DM (geom geometry, mvalue float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force3DM (geom geometry, mvalue float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force3DM (geom geometry, mvalue float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Force4D (geom geometry, zvalue float8 , mvalue float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Force4D (geom geometry, zvalue float8 , mvalue float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Force4D (geom geometry, zvalue float8 , mvalue float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Force4D (geom geometry, zvalue float8 , mvalue float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Force4D (geom geometry, zvalue float8 , mvalue float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceCollection (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceCollection (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceCollection (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceCollection (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceCollection (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CollectionExtract (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_CollectionExtract (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CollectionExtract (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CollectionExtract (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CollectionExtract (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CollectionExtract (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CollectionExtract (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CollectionExtract (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CollectionExtract (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CollectionExtract (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CollectionHomogenize (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CollectionHomogenize (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CollectionHomogenize (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CollectionHomogenize (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CollectionHomogenize (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Multi (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Multi (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Multi (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Multi (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Multi (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceCurve (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceCurve (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceCurve (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceCurve (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceCurve (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceSFS (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceSFS (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceSFS (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceSFS (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceSFS (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceSFS (geometry, version text);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceSFS (geometry, version text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceSFS (geometry, version text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceSFS (geometry, version text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceSFS (geometry, version text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box3d,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box3d,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box3d,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box3d,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box3d,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (box box3d, dx float8, dy float8, dz float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Expand (geom geometry, dx float8, dy float8, dz float8 , dm float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Envelope (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Envelope (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Envelope (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Envelope (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Envelope (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BoundingDiagonal (geom geometry, fits boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Reverse (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Reverse (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Reverse (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Reverse (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Reverse (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scroll (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Scroll (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scroll (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scroll (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scroll (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForcePolygonCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForcePolygonCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForcePolygonCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForcePolygonCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForcePolygonCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForcePolygonCCW (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForcePolygonCCW (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForcePolygonCCW (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForcePolygonCCW (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForcePolygonCCW (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ForceRHR (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ForceRHR (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ForceRHR (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ForceRHR (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ForceRHR (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_noop (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_noop (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_noop (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_noop (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_noop (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_geos_noop (geometry);
	RAISE NOTICE 'newly registered FUNCTION postgis_geos_noop (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_geos_noop (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_geos_noop (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_geos_noop (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Normalize (geom geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Normalize (geom geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Normalize (geom geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Normalize (geom geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Normalize (geom geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_zmflag (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_zmflag (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_zmflag (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_zmflag (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_zmflag (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NDims (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NDims (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NDims (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NDims (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NDims (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsTWKB (geom geometry, prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_AsTWKB (geom geometry, prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsTWKB (geom geometry, prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsTWKB (geom geometry, prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsTWKB (geom geometry, prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsTWKB (geom geometry[], ids bigint[], prec integer , prec_z integer , prec_m integer , with_sizes boolean , with_boxes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKB (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKB (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKB (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKB (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKB (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsHEXEWKB (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsHEXEWKB (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsHEXEWKB (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsHEXEWKB (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsHEXEWKB (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsHEXEWKB (geometry, text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsHEXEWKB (geometry, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsHEXEWKB (geometry, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsHEXEWKB (geometry, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsHEXEWKB (geometry, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKB (geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKB (geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKB (geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKB (geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKB (geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsLatLonText (geom geometry, tmpl text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsLatLonText (geom geometry, tmpl text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsLatLonText (geom geometry, tmpl text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsLatLonText (geom geometry, tmpl text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsLatLonText (geom geometry, tmpl text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeomFromEWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION GeomFromEWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeomFromEWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeomFromEWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeomFromEWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromEWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromEWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromEWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromEWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromEWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromTWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromTWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromTWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromTWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromTWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeomFromEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION GeomFromEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeomFromEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeomFromEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeomFromEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_cache_bbox ();
	RAISE NOTICE 'newly registered FUNCTION postgis_cache_bbox ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_cache_bbox ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_cache_bbox () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_cache_bbox () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePoint (float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePoint (float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePoint (float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePoint (float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePoint (float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePointM (float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePointM (float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePointM (float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePointM (float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePointM (float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DMakeBox (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeLine  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeLine  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeLine  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeLine  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeLine  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromMultiPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromMultiPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromMultiPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromMultiPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromMultiPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddPoint (geom1 geometry, geom2 geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RemovePoint (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_RemovePoint (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RemovePoint (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RemovePoint (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RemovePoint (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetPoint (geometry, integer, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SetPoint (geometry, integer, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetPoint (geometry, integer, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetPoint (geometry, integer, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetPoint (geometry, integer, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer );
	RAISE NOTICE 'newly registered FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeEnvelope (float8, float8, float8, float8, integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_TileEnvelope (zoom integer, x integer, y integer, bounds geometry , margin float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_TileEnvelope (zoom integer, x integer, y integer, bounds geometry , margin float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_TileEnvelope (zoom integer, x integer, y integer, bounds geometry , margin float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_TileEnvelope (zoom integer, x integer, y integer, bounds geometry , margin float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_TileEnvelope (zoom integer, x integer, y integer, bounds geometry , margin float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePolygon (geometry, geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePolygon (geometry, geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePolygon (geometry, geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePolygon (geometry, geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePolygon (geometry, geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakePolygon (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakePolygon (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakePolygon (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakePolygon (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakePolygon (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BuildArea (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_BuildArea (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BuildArea (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BuildArea (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BuildArea (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Polygonize  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Polygonize  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Polygonize  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Polygonize  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Polygonize  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterIntersecting (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterIntersecting (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterIntersecting (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterIntersecting (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterIntersecting (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterWithin (geometry[], float8);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterWithin (geometry[], float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterWithin (geometry[], float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterWithin (geometry[], float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterWithin (geometry[], float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int);
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterDBSCAN  (geometry, eps float8, minpoints int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineMerge (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineMerge (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineMerge (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineMerge (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineMerge (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineMerge (geometry, boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_LineMerge (geometry, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineMerge (geometry, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineMerge (geometry, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineMerge (geometry, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Affine (geometry,float8,float8,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Rotate (geometry,float8,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Rotate (geometry,float8,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Rotate (geometry,float8,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Rotate (geometry,float8,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Rotate (geometry,float8,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateZ (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateZ (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateZ (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateZ (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateZ (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateX (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateX (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateX (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateX (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateX (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RotateY (geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_RotateY (geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RotateY (geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RotateY (geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RotateY (geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Translate (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Translate (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Translate (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Translate (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Translate (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Translate (geometry,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Translate (geometry,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Translate (geometry,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Translate (geometry,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Translate (geometry,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,geometry,origin geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,geometry,origin geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,geometry,origin geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,geometry,origin geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,geometry,origin geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Scale (geometry,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Scale (geometry,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Scale (geometry,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Scale (geometry,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Scale (geometry,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transscale (geometry,float8,float8,float8,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Transscale (geometry,float8,float8,float8,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transscale (geometry,float8,float8,float8,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transscale (geometry,float8,float8,float8,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transscale (geometry,float8,float8,float8,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Dump (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Dump (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Dump (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Dump (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Dump (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DumpRings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DumpRings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DumpRings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DumpRings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DumpRings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DumpPoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DumpPoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DumpPoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DumpPoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DumpPoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DumpSegments (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DumpSegments (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DumpSegments (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DumpSegments (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DumpSegments (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION populate_geometry_columns (use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION populate_geometry_columns (use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION populate_geometry_columns (use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION populate_geometry_columns (use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION populate_geometry_columns (use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION populate_geometry_columns (tbl_oid oid, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (catalog_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (schema_name varchar,table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean );
	RAISE NOTICE 'newly registered FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddGeometryColumn (table_name varchar,column_name varchar,new_srid integer,new_type varchar,new_dim integer, use_typmod boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (catalog_name varchar, schema_name varchar,table_name varchar,column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (schema_name varchar, table_name varchar,column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryColumn (table_name varchar, column_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryColumn (table_name varchar, column_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryColumn (table_name varchar, column_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryColumn (table_name varchar, column_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryColumn (table_name varchar, column_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (catalog_name varchar, schema_name varchar, table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (schema_name varchar, table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (schema_name varchar, table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (schema_name varchar, table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (schema_name varchar, table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (schema_name varchar, table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DropGeometryTable (table_name varchar);
	RAISE NOTICE 'newly registered FUNCTION DropGeometryTable (table_name varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DropGeometryTable (table_name varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DropGeometryTable (table_name varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DropGeometryTable (table_name varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (catalogn_name varchar,schema_name varchar,table_name varchar,column_name varchar,new_srid_in integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (varchar,varchar,varchar,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UpdateGeometrySRID (varchar,varchar,integer);
	RAISE NOTICE 'newly registered FUNCTION UpdateGeometrySRID (varchar,varchar,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UpdateGeometrySRID (varchar,varchar,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UpdateGeometrySRID (varchar,varchar,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UpdateGeometrySRID (varchar,varchar,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION find_srid (varchar,varchar,varchar);
	RAISE NOTICE 'newly registered FUNCTION find_srid (varchar,varchar,varchar)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION find_srid (varchar,varchar,varchar)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION find_srid (varchar,varchar,varchar) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION find_srid (varchar,varchar,varchar) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION get_proj4_from_srid (integer);
	RAISE NOTICE 'newly registered FUNCTION get_proj4_from_srid (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION get_proj4_from_srid (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION get_proj4_from_srid (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION get_proj4_from_srid (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetSRID (geom geometry, srid integer);
	RAISE NOTICE 'newly registered FUNCTION ST_SetSRID (geom geometry, srid integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetSRID (geom geometry, srid integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetSRID (geom geometry, srid integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetSRID (geom geometry, srid integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SRID (geom geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SRID (geom geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SRID (geom geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SRID (geom geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SRID (geom geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_transform_geometry (geom geometry, text, text, int);
	RAISE NOTICE 'newly registered FUNCTION postgis_transform_geometry (geom geometry, text, text, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_transform_geometry (geom geometry, text, text, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_transform_geometry (geom geometry, text, text, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_transform_geometry (geom geometry, text, text, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, to_proj text);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, to_proj text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, to_proj text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, to_proj text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, to_proj text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, from_proj text, to_proj text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Transform (geom geometry, from_proj text, to_srid integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_liblwgeom_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_liblwgeom_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_liblwgeom_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_liblwgeom_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_liblwgeom_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_proj_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_proj_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_proj_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_proj_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_proj_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_wagyu_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_wagyu_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_wagyu_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_wagyu_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_wagyu_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_installed ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_installed ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_installed ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_installed () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_installed () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_lib_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_lib_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_lib_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_lib_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_lib_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_released ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_released ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_released ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_released () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_released () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_geos_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_geos_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_geos_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_geos_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_geos_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_lib_revision ();
	RAISE NOTICE 'newly registered FUNCTION postgis_lib_revision ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_lib_revision ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_lib_revision () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_lib_revision () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_svn_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_svn_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_svn_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_svn_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_svn_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libxml_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libxml_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libxml_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libxml_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libxml_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_scripts_build_date ();
	RAISE NOTICE 'newly registered FUNCTION postgis_scripts_build_date ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_scripts_build_date ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_scripts_build_date () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_scripts_build_date () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_lib_build_date ();
	RAISE NOTICE 'newly registered FUNCTION postgis_lib_build_date ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_lib_build_date ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_lib_build_date () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_lib_build_date () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_scripts_pgsql_version ();
	RAISE NOTICE 'newly registered FUNCTION _postgis_scripts_pgsql_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_scripts_pgsql_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_scripts_pgsql_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_scripts_pgsql_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _postgis_pgsql_version ();
	RAISE NOTICE 'newly registered FUNCTION _postgis_pgsql_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _postgis_pgsql_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _postgis_pgsql_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _postgis_pgsql_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_extensions_upgrade ();
	RAISE NOTICE 'newly registered FUNCTION postgis_extensions_upgrade ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_extensions_upgrade ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_extensions_upgrade () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_extensions_upgrade () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_full_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_full_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_full_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_full_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_full_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d (geometry);
	RAISE NOTICE 'newly registered FUNCTION box2d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d (geometry);
	RAISE NOTICE 'newly registered FUNCTION box3d (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box (geometry);
	RAISE NOTICE 'newly registered FUNCTION box (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d (box3d);
	RAISE NOTICE 'newly registered FUNCTION box2d (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d (box2d);
	RAISE NOTICE 'newly registered FUNCTION box3d (box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d (box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d (box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d (box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box (box3d);
	RAISE NOTICE 'newly registered FUNCTION box (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION text (geometry);
	RAISE NOTICE 'newly registered FUNCTION text (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION text (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION text (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION text (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3dtobox (box3d);
	RAISE NOTICE 'newly registered FUNCTION box3dtobox (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3dtobox (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3dtobox (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3dtobox (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (box2d);
	RAISE NOTICE 'newly registered FUNCTION geometry (box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (box3d);
	RAISE NOTICE 'newly registered FUNCTION geometry (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (text);
	RAISE NOTICE 'newly registered FUNCTION geometry (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (bytea);
	RAISE NOTICE 'newly registered FUNCTION geometry (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION bytea (geometry);
	RAISE NOTICE 'newly registered FUNCTION bytea (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION bytea (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION bytea (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION bytea (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Simplify (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Simplify (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Simplify (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Simplify (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Simplify (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Simplify (geometry, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION ST_Simplify (geometry, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Simplify (geometry, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Simplify (geometry, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Simplify (geometry, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SimplifyVW (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SimplifyVW (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SimplifyVW (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SimplifyVW (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SimplifyVW (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer );
	RAISE NOTICE 'newly registered FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetEffectiveArea (geometry,  float8 , integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FilterByM (geometry, double precision, double precision , boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ChaikinSmoothing (geometry, integer , boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SnapToGrid (geom1 geometry, geom2 geometry, float8, float8, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Segmentize (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Segmentize (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Segmentize (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Segmentize (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Segmentize (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineInterpolatePoint (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LineInterpolatePoint (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineInterpolatePoint (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineInterpolatePoint (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineInterpolatePoint (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineInterpolatePoints (geometry, float8, repeat boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineSubstring (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LineSubstring (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineSubstring (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineSubstring (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineSubstring (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineLocatePoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AddMeasure (geometry, float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_AddMeasure (geometry, float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AddMeasure (geometry, float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AddMeasure (geometry, float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AddMeasure (geometry, float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClosestPointOfApproach (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ClosestPointOfApproach (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClosestPointOfApproach (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClosestPointOfApproach (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClosestPointOfApproach (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceCPA (geometry, geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceCPA (geometry, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceCPA (geometry, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceCPA (geometry, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceCPA (geometry, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CPAWithin (geometry, geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_CPAWithin (geometry, geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CPAWithin (geometry, geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CPAWithin (geometry, geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CPAWithin (geometry, geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidTrajectory (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidTrajectory (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidTrajectory (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidTrajectory (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidTrajectory (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (geom1 geometry, geom2 geometry, gridSize float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (geom1 geometry, geom2 geometry, gridSize float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (geom1 geometry, geom2 geometry, gridSize float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (geom1 geometry, geom2 geometry, gridSize float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (geom1 geometry, geom2 geometry, gridSize float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geom geometry, radius float8, options text );
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geom geometry, radius float8, options text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geom geometry, radius float8, options text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geom geometry, radius float8, options text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geom geometry, radius float8, options text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geom geometry, radius float8, quadsegs integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geom geometry, radius float8, quadsegs integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geom geometry, radius float8, quadsegs integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geom geometry, radius float8, quadsegs integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geom geometry, radius float8, quadsegs integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumBoundingRadius (geometry, OUT center geometry, OUT radius double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer );
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumBoundingCircle (inputgeom geometry, segs_per_quarter integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OrientedEnvelope (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_OrientedEnvelope (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OrientedEnvelope (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OrientedEnvelope (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OrientedEnvelope (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OffsetCurve (line geometry, distance float8, params text );
	RAISE NOTICE 'newly registered FUNCTION ST_OffsetCurve (line geometry, distance float8, params text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OffsetCurve (line geometry, distance float8, params text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OffsetCurve (line geometry, distance float8, params text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OffsetCurve (line geometry, distance float8, params text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeneratePoints (area geometry, npoints integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeneratePoints (area geometry, npoints integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeneratePoints (area geometry, npoints integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeneratePoints (area geometry, npoints integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeneratePoints (area geometry, npoints integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeneratePoints (area geometry, npoints integer, seed integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeneratePoints (area geometry, npoints integer, seed integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeneratePoints (area geometry, npoints integer, seed integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeneratePoints (area geometry, npoints integer, seed integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeneratePoints (area geometry, npoints integer, seed integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ConvexHull (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ConvexHull (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ConvexHull (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ConvexHull (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ConvexHull (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SimplifyPreserveTopology (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_SimplifyPreserveTopology (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SimplifyPreserveTopology (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SimplifyPreserveTopology (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SimplifyPreserveTopology (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidReason (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidReason (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidReason (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidReason (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidReason (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidDetail (geom geometry, flags integer );
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidDetail (geom geometry, flags integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidDetail (geom geometry, flags integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidDetail (geom geometry, flags integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidDetail (geom geometry, flags integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValidReason (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValidReason (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValidReason (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValidReason (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValidReason (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValid (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValid (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValid (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValid (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValid (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HausdorffDistance (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FrechetDistance (geom1 geometry, geom2 geometry, float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MaximumInscribedCircle (geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision);
	RAISE NOTICE 'newly registered FUNCTION ST_MaximumInscribedCircle (geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MaximumInscribedCircle (geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MaximumInscribedCircle (geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MaximumInscribedCircle (geometry, OUT center geometry, OUT nearest geometry, OUT radius double precision) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Difference (geom1 geometry, geom2 geometry, gridSize float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Difference (geom1 geometry, geom2 geometry, gridSize float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Difference (geom1 geometry, geom2 geometry, gridSize float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Difference (geom1 geometry, geom2 geometry, gridSize float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Difference (geom1 geometry, geom2 geometry, gridSize float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Boundary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Boundary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Boundary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Boundary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Boundary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Points (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Points (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Points (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Points (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Points (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry, gridSize float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry, gridSize float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry, gridSize float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry, gridSize float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SymDifference (geom1 geometry, geom2 geometry, gridSize float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SymmetricDifference (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SymmetricDifference (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SymmetricDifference (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SymmetricDifference (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SymmetricDifference (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Union (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Union (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Union (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Union (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Union (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Union (geom1 geometry, geom2 geometry, gridSize float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Union (geom1 geometry, geom2 geometry, gridSize float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Union (geom1 geometry, geom2 geometry, gridSize float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Union (geom1 geometry, geom2 geometry, gridSize float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Union (geom1 geometry, geom2 geometry, gridSize float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_UnaryUnion (geometry, gridSize float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_UnaryUnion (geometry, gridSize float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_UnaryUnion (geometry, gridSize float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_UnaryUnion (geometry, gridSize float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_UnaryUnion (geometry, gridSize float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RemoveRepeatedPoints (geom geometry, tolerance float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClipByBox2d (geom geometry, box box2d);
	RAISE NOTICE 'newly registered FUNCTION ST_ClipByBox2d (geom geometry, box box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClipByBox2d (geom geometry, box box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClipByBox2d (geom geometry, box box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClipByBox2d (geom geometry, box box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Subdivide (geom geometry, maxvertices integer , gridSize float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_Subdivide (geom geometry, maxvertices integer , gridSize float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Subdivide (geom geometry, maxvertices integer , gridSize float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Subdivide (geom geometry, maxvertices integer , gridSize float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Subdivide (geom geometry, maxvertices integer , gridSize float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ReducePrecision (geom geometry, gridsize float8);
	RAISE NOTICE 'newly registered FUNCTION ST_ReducePrecision (geom geometry, gridsize float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ReducePrecision (geom geometry, gridsize float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ReducePrecision (geom geometry, gridsize float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ReducePrecision (geom geometry, gridsize float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeValid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeValid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeValid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeValid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeValid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MakeValid (geom geometry, params text);
	RAISE NOTICE 'newly registered FUNCTION ST_MakeValid (geom geometry, params text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MakeValid (geom geometry, params text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MakeValid (geom geometry, params text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MakeValid (geom geometry, params text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CleanGeometry (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CleanGeometry (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CleanGeometry (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CleanGeometry (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CleanGeometry (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Split (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Split (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Split (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Split (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Split (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SharedPaths (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Snap (geom1 geometry, geom2 geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_RelateMatch (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_RelateMatch (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_RelateMatch (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_RelateMatch (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_RelateMatch (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Node (g geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Node (g geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Node (g geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Node (g geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Node (g geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags integer );
	RAISE NOTICE 'newly registered FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DelaunayTriangles (g1 geometry, tolerance float8 , flags integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_TriangulatePolygon (g1 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_TriangulatePolygon (g1 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_TriangulatePolygon (g1 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_TriangulatePolygon (g1 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_TriangulatePolygon (g1 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean );
	RAISE NOTICE 'newly registered FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Voronoi (g1 geometry, clip geometry , tolerance float8 , return_polygons boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_VoronoiPolygons (g1 geometry, tolerance float8 , extend_to geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_VoronoiLines (g1 geometry, tolerance float8 , extend_to geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBBox (box3d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBBox (box3d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBBox (box3d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBBox (box3d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBBox (box3d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBBox (box3d,box3d);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBBox (box3d,box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBBox (box3d,box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBBox (box3d,box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBBox (box3d,box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CombineBbox (box2d,geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CombineBbox (box2d,geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CombineBbox (box2d,geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CombineBbox (box2d,geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CombineBbox (box2d,geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Collect (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Collect (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Collect (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Collect (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Collect (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Collect (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Collect (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Collect (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Collect (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Collect (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_accum_transfn (internal, geometry, float8, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_collect_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_collect_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_collect_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_collect_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_collect_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_polygonize_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_polygonize_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_polygonize_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_polygonize_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_polygonize_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_clusterintersecting_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_clusterintersecting_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_clusterintersecting_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_clusterintersecting_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_clusterintersecting_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_clusterwithin_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_clusterwithin_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_clusterwithin_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_clusterwithin_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_clusterwithin_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_makeline_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_makeline_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_makeline_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_makeline_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_makeline_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_transfn (internal, geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_combinefn (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_combinefn (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_combinefn (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_combinefn (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_combinefn (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_serialfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_serialfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_serialfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_serialfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_serialfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_deserialfn (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_deserialfn (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_deserialfn (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_deserialfn (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_deserialfn (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_geometry_union_parallel_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_geometry_union_parallel_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_geometry_union_parallel_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_geometry_union_parallel_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_geometry_union_parallel_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Union  (geometry[]);
	RAISE NOTICE 'newly registered FUNCTION ST_Union  (geometry[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Union  (geometry[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Union  (geometry[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Union  (geometry[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClusterKMeans (geom geometry, k integer, max_radius float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_ClusterKMeans (geom geometry, k integer, max_radius float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClusterKMeans (geom geometry, k integer, max_radius float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClusterKMeans (geom geometry, k integer, max_radius float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClusterKMeans (geom geometry, k integer, max_radius float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Relate (geom1 geometry, geom2 geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Disjoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_LineCrossingDirection (line1 geometry, line2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_LineCrossingDirection (line1 geometry, line2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_LineCrossingDirection (line1 geometry, line2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_LineCrossingDirection (line1 geometry, line2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_LineCrossingDirection (line1 geometry, line2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Touches (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Touches (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Touches (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Touches (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Touches (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Intersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Crosses (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_ContainsProperly (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Covers (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Covers (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Covers (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Covers (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Covers (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_CoveredBy (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DDWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_3DIntersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_OrderingEquals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_OrderingEquals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_OrderingEquals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_OrderingEquals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_OrderingEquals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_index_supportfn  (internal);
	RAISE NOTICE 'newly registered FUNCTION postgis_index_supportfn  (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_index_supportfn  (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_index_supportfn  (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_index_supportfn  (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineCrossingDirection (line1 geometry, line2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineCrossingDirection (line1 geometry, line2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineCrossingDirection (line1 geometry, line2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineCrossingDirection (line1 geometry, line2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineCrossingDirection (line1 geometry, line2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Touches (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Touches (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Touches (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Touches (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Touches (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Crosses (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Crosses (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Crosses (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Crosses (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Crosses (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Contains (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Contains (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Contains (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Contains (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Contains (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ContainsProperly (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Within (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Within (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Within (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Within (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Within (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Overlaps (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDFullyWithin (geom1 geometry, geom2 geometry,float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DIntersects (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_OrderingEquals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_OrderingEquals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_OrderingEquals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_OrderingEquals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_OrderingEquals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsValid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsValid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsValid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsValid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsValid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumClearance (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumClearance (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumClearance (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumClearance (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumClearance (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MinimumClearanceLine (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MinimumClearanceLine (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MinimumClearanceLine (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MinimumClearanceLine (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MinimumClearanceLine (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometricMedian (g geometry, tolerance float8 , max_iter int , fail_if_not_converged boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointOnSurface (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_PointOnSurface (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointOnSurface (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointOnSurface (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointOnSurface (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsSimple (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsSimple (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsSimple (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsSimple (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsSimple (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsCollection (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsCollection (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsCollection (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsCollection (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsCollection (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION Equals (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION Equals (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION Equals (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION Equals (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION Equals (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_GeomFromGML (text, integer);
	RAISE NOTICE 'newly registered FUNCTION _ST_GeomFromGML (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_GeomFromGML (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_GeomFromGML (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_GeomFromGML (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGML (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGML (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGML (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGML (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGML (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GMLToSQL (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GMLToSQL (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GMLToSQL (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GMLToSQL (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GMLToSQL (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GMLToSQL (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GMLToSQL (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GMLToSQL (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GMLToSQL (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GMLToSQL (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromKML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromKML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromKML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromKML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromKML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromMARC21 (marc21xml text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromMARC21 (marc21xml text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromMARC21 (marc21xml text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromMARC21 (marc21xml text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromMARC21 (marc21xml text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsMARC21 (geom geometry, format text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsMARC21 (geom geometry, format text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsMARC21 (geom geometry, format text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsMARC21 (geom geometry, format text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsMARC21 (geom geometry, format text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (json);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (json)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (json)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (json) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (json) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoJson (jsonb);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoJson (jsonb)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoJson (jsonb)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoJson (jsonb) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoJson (jsonb) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libjson_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libjson_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libjson_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libjson_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libjson_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromEncodedPolyline (txtin text, nprecision integer );
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromEncodedPolyline (txtin text, nprecision integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromEncodedPolyline (txtin text, nprecision integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromEncodedPolyline (txtin text, nprecision integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromEncodedPolyline (txtin text, nprecision integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEncodedPolyline (geom geometry, nprecision integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsEncodedPolyline (geom geometry, nprecision integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEncodedPolyline (geom geometry, nprecision integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEncodedPolyline (geom geometry, nprecision integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEncodedPolyline (geom geometry, nprecision integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (geom geometry, rel integer , maxdecimaldigits integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (geom geometry, rel integer , maxdecimaldigits integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (geom geometry, rel integer , maxdecimaldigits integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (geom geometry, rel integer , maxdecimaldigits integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (geom geometry, rel integer , maxdecimaldigits integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsGML (integer, geometry, integer, integer, text, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsGML (integer, geometry, integer, integer, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsGML (integer, geometry, integer, integer, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsGML (integer, geometry, integer, integer, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsGML (integer, geometry, integer, integer, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (geom geometry, maxdecimaldigits integer , options integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (geom geometry, maxdecimaldigits integer , options integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (geom geometry, maxdecimaldigits integer , options integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (geom geometry, maxdecimaldigits integer , options integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (geom geometry, maxdecimaldigits integer , options integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (version integer, geom geometry, maxdecimaldigits integer , options integer , nprefix text , id text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (version integer, geom geometry, maxdecimaldigits integer , options integer , nprefix text , id text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (version integer, geom geometry, maxdecimaldigits integer , options integer , nprefix text , id text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (version integer, geom geometry, maxdecimaldigits integer , options integer , nprefix text , id text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (version integer, geom geometry, maxdecimaldigits integer , options integer , nprefix text , id text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (geom geometry, maxdecimaldigits integer , nprefix TEXT );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (geom geometry, maxdecimaldigits integer , nprefix TEXT )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (geom geometry, maxdecimaldigits integer , nprefix TEXT )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (geom geometry, maxdecimaldigits integer , nprefix TEXT ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (geom geometry, maxdecimaldigits integer , nprefix TEXT ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits integer , options integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits integer , options integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits integer , options integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits integer , options integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (geom geometry, maxdecimaldigits integer , options integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (r record, geom_column text , maxdecimaldigits integer , pretty_bool bool );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (r record, geom_column text , maxdecimaldigits integer , pretty_bool bool )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (r record, geom_column text , maxdecimaldigits integer , pretty_bool bool )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (r record, geom_column text , maxdecimaldigits integer , pretty_bool bool ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (r record, geom_column text , maxdecimaldigits integer , pretty_bool bool ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION "json" (geometry);
	RAISE NOTICE 'newly registered FUNCTION "json" (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION "json" (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION "json" (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION "json" (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION "jsonb" (geometry);
	RAISE NOTICE 'newly registered FUNCTION "jsonb" (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION "jsonb" (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION "jsonb" (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION "jsonb" (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_transfn (internal, anyelement, text, integer, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_combinefn (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_combinefn (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_combinefn (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_combinefn (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_combinefn (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_serialfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_serialfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_serialfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_serialfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_serialfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asmvt_deserialfn (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asmvt_deserialfn (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asmvt_deserialfn (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asmvt_deserialfn (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asmvt_deserialfn (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent integer , buffer integer , clip_geom bool );
	RAISE NOTICE 'newly registered FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent integer , buffer integer , clip_geom bool )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent integer , buffer integer , clip_geom bool )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent integer , buffer integer , clip_geom bool ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsMVTGeom (geom geometry, bounds box2d, extent integer , buffer integer , clip_geom bool ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_libprotobuf_version ();
	RAISE NOTICE 'newly registered FUNCTION postgis_libprotobuf_version ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_libprotobuf_version ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_libprotobuf_version () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_libprotobuf_version () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_transfn (internal, anyelement);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_transfn (internal, anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_transfn (internal, anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_transfn (internal, anyelement, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asgeobuf_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asgeobuf_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asgeobuf_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asgeobuf_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asgeobuf_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement);
	RAISE NOTICE 'newly registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool);
	RAISE NOTICE 'newly registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool, text);
	RAISE NOTICE 'newly registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asflatgeobuf_transfn (internal, anyelement, bool, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION pgis_asflatgeobuf_finalfn (internal);
	RAISE NOTICE 'newly registered FUNCTION pgis_asflatgeobuf_finalfn (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION pgis_asflatgeobuf_finalfn (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION pgis_asflatgeobuf_finalfn (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION pgis_asflatgeobuf_finalfn (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FromFlatGeobufToTable (text, text, bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_FromFlatGeobufToTable (text, text, bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FromFlatGeobufToTable (text, text, bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FromFlatGeobufToTable (text, text, bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FromFlatGeobufToTable (text, text, bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FromFlatGeobuf (anyelement, bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_FromFlatGeobuf (anyelement, bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FromFlatGeobuf (anyelement, bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FromFlatGeobuf (anyelement, bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FromFlatGeobuf (anyelement, bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeoHash (geom geometry, maxchars integer );
	RAISE NOTICE 'newly registered FUNCTION ST_GeoHash (geom geometry, maxchars integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeoHash (geom geometry, maxchars integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeoHash (geom geometry, maxchars integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeoHash (geom geometry, maxchars integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_SortableHash (geom geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_SortableHash (geom geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_SortableHash (geom geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_SortableHash (geom geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_SortableHash (geom geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Box2dFromGeoHash (text, integer );
	RAISE NOTICE 'newly registered FUNCTION ST_Box2dFromGeoHash (text, integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Box2dFromGeoHash (text, integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Box2dFromGeoHash (text, integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Box2dFromGeoHash (text, integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromGeoHash (text, integer );
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromGeoHash (text, integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromGeoHash (text, integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromGeoHash (text, integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromGeoHash (text, integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromGeoHash (text, integer );
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromGeoHash (text, integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromGeoHash (text, integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromGeoHash (text, integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromGeoHash (text, integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumPoints (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumPoints (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumPoints (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumPoints (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumPoints (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumGeometries (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumGeometries (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumGeometries (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumGeometries (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumGeometries (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Dimension (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Dimension (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Dimension (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Dimension (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Dimension (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ExteriorRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ExteriorRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ExteriorRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ExteriorRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ExteriorRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumInteriorRings (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumInteriorRings (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumInteriorRings (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumInteriorRings (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumInteriorRings (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumInteriorRing (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumInteriorRing (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumInteriorRing (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumInteriorRing (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumInteriorRing (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_InteriorRingN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_InteriorRingN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_InteriorRingN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_InteriorRingN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_InteriorRingN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeometryType (geometry);
	RAISE NOTICE 'newly registered FUNCTION GeometryType (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeometryType (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeometryType (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeometryType (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryType (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryType (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryType (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryType (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryType (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointN (geometry,integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PointN (geometry,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointN (geometry,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointN (geometry,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointN (geometry,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_NumPatches (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_NumPatches (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_NumPatches (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_NumPatches (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_NumPatches (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PatchN (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PatchN (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PatchN (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PatchN (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PatchN (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_StartPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_StartPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_StartPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_StartPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_StartPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_EndPoint (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_EndPoint (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_EndPoint (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_EndPoint (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_EndPoint (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsClosed (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsClosed (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsClosed (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsClosed (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsClosed (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_IsEmpty (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_IsEmpty (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_IsEmpty (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_IsEmpty (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_IsEmpty (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geometry,text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geometry,text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geometry,text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geometry,text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geometry,text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geometry, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geometry, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geometry, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geometry, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geometry, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeometryFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeometryFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeometryFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeometryFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeometryFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WKTToSQL (text);
	RAISE NOTICE 'newly registered FUNCTION ST_WKTToSQL (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WKTToSQL (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WKTToSQL (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WKTToSQL (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineStringFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineStringFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineStringFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineStringFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineStringFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineStringFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineStringFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineStringFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineStringFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineStringFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolygonFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolygonFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolygonFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolygonFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolygonFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolygonFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolygonFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolygonFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolygonFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolygonFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_LineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LinestringFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_LinestringFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LinestringFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LinestringFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LinestringFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LinestringFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_LinestringFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LinestringFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LinestringFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LinestringFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PolygonFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_PolygonFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PolygonFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PolygonFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PolygonFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MPointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPointFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPointFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPointFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPointFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPointFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiLineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiLineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiLineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiLineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiLineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MLineFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MLineFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MLineFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MLineFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MLineFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MPolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MPolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MPolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MPolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MPolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolyFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolyFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolyFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolyFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolyFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MultiPolyFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_MultiPolyFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MultiPolyFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MultiPolyFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MultiPolyFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromWKB (bytea, int);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromWKB (bytea, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromWKB (bytea, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromWKB (bytea, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromWKB (bytea, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeomCollFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeomCollFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeomCollFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeomCollFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeomCollFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_MaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_MaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ClosestPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ShortestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_LongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SwapOrdinates (geom geometry, ords cstring);
	RAISE NOTICE 'newly registered FUNCTION ST_SwapOrdinates (geom geometry, ords cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SwapOrdinates (geom geometry, ords cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SwapOrdinates (geom geometry, ords cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SwapOrdinates (geom geometry, ords cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_FlipCoordinates (geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_FlipCoordinates (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_FlipCoordinates (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_FlipCoordinates (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_FlipCoordinates (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BdPolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_BdPolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BdPolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BdPolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BdPolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_BdMPolyFromText (text, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_BdMPolyFromText (text, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_BdMPolyFromText (text, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_BdMPolyFromText (text, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_BdMPolyFromText (text, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION UnlockRows (text);
	RAISE NOTICE 'newly registered FUNCTION UnlockRows (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION UnlockRows (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION UnlockRows (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION UnlockRows (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, text, timestamp);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, text, timestamp)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, text, timestamp)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, text, timestamp) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, text, timestamp) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, text);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LockRow (text, text, text, timestamp);
	RAISE NOTICE 'newly registered FUNCTION LockRow (text, text, text, timestamp)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LockRow (text, text, text, timestamp)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LockRow (text, text, text, timestamp) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LockRow (text, text, text, timestamp) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION AddAuth (text);
	RAISE NOTICE 'newly registered FUNCTION AddAuth (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION AddAuth (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION AddAuth (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION AddAuth (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuth (text, text, text);
	RAISE NOTICE 'newly registered FUNCTION CheckAuth (text, text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuth (text, text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuth (text, text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuth (text, text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuth (text, text);
	RAISE NOTICE 'newly registered FUNCTION CheckAuth (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuth (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuth (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuth (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION CheckAuthTrigger ();
	RAISE NOTICE 'newly registered FUNCTION CheckAuthTrigger ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION CheckAuthTrigger ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION CheckAuthTrigger () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION CheckAuthTrigger () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GetTransactionID ();
	RAISE NOTICE 'newly registered FUNCTION GetTransactionID ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GetTransactionID ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GetTransactionID () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GetTransactionID () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION EnableLongTransactions ();
	RAISE NOTICE 'newly registered FUNCTION EnableLongTransactions ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION EnableLongTransactions ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION EnableLongTransactions () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION EnableLongTransactions () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION LongTransactionsEnabled ();
	RAISE NOTICE 'newly registered FUNCTION LongTransactionsEnabled ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION LongTransactionsEnabled ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION LongTransactionsEnabled () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION LongTransactionsEnabled () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION DisableLongTransactions ();
	RAISE NOTICE 'newly registered FUNCTION DisableLongTransactions ()';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION DisableLongTransactions ()';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION DisableLongTransactions () does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION DisableLongTransactions () to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (geography, integer, boolean);
	RAISE NOTICE 'newly registered FUNCTION geography (geography, integer, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (geography, integer, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (geography, integer, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (geography, integer, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (bytea);
	RAISE NOTICE 'newly registered FUNCTION geography (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION bytea (geography);
	RAISE NOTICE 'newly registered FUNCTION bytea (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION bytea (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION bytea (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION bytea (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (geography, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (geography, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (geography, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (geography, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (geography, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeographyFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeographyFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeographyFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeographyFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeographyFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeogFromText (text);
	RAISE NOTICE 'newly registered FUNCTION ST_GeogFromText (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeogFromText (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeogFromText (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeogFromText (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeogFromWKB (bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_GeogFromWKB (bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeogFromWKB (bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeogFromWKB (bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeogFromWKB (bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_dims (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_dims (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_dims (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_dims (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_dims (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_srid (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_srid (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_srid (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_srid (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_srid (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_typmod_type (integer);
	RAISE NOTICE 'newly registered FUNCTION postgis_typmod_type (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_typmod_type (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_typmod_type (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_typmod_type (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography (geometry);
	RAISE NOTICE 'newly registered FUNCTION geography (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry (geography);
	RAISE NOTICE 'newly registered FUNCTION geometry (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_consistent (internal,geography,integer);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_consistent (internal,geography,integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_consistent (internal,geography,integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_consistent (internal,geography,integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_consistent (internal,geography,integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_compress (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_compress (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_compress (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_compress (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_compress (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_penalty (internal,internal,internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_penalty (internal,internal,internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_penalty (internal,internal,internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_penalty (internal,internal,internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_penalty (internal,internal,internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_picksplit (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_picksplit (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_picksplit (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_picksplit (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_picksplit (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_union (bytea, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_union (bytea, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_union (bytea, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_union (bytea, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_union (bytea, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_same (box2d, box2d, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_same (box2d, box2d, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_same (box2d, box2d, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_same (box2d, box2d, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_same (box2d, box2d, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_decompress (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_decompress (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_decompress (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_decompress (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_decompress (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_overlaps (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_overlaps (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_overlaps (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_overlaps (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_overlaps (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_distance_knn (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_distance_knn (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_distance_knn (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_distance_knn (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_distance_knn (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gist_distance (internal, geography, integer);
	RAISE NOTICE 'newly registered FUNCTION geography_gist_distance (internal, geography, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gist_distance (internal, geography, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gist_distance (internal, geography, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gist_distance (internal, geography, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (gidx, geography);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (gidx, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (gidx, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (gidx, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (gidx, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (gidx, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (gidx, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (gidx, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (gidx, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (gidx, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_geog (geography, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_geog (geography, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_geog (geography, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_geog (geography, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_geog (geography, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geog_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_lt (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_lt (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_lt (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_lt (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_lt (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_le (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_le (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_le (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_le (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_le (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_gt (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_gt (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_gt (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_gt (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_gt (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_ge (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_ge (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_ge (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_ge (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_ge (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_eq (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_eq (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_eq (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_eq (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_eq (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_cmp (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION geography_cmp (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_cmp (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_cmp (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_cmp (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (geog geography, rel integer , maxdecimaldigits integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (geog geography, rel integer , maxdecimaldigits integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (geog geography, rel integer , maxdecimaldigits integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (geog geography, rel integer , maxdecimaldigits integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (geog geography, rel integer , maxdecimaldigits integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsSVG (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsSVG (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsSVG (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsSVG (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsSVG (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (version integer, geog geography, maxdecimaldigits integer , options integer , nprefix text , id text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (version integer, geog geography, maxdecimaldigits integer , options integer , nprefix text , id text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (version integer, geog geography, maxdecimaldigits integer , options integer , nprefix text , id text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (version integer, geog geography, maxdecimaldigits integer , options integer , nprefix text , id text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (version integer, geog geography, maxdecimaldigits integer , options integer , nprefix text , id text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (geog geography, maxdecimaldigits integer , options integer , nprefix text , id text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (geog geography, maxdecimaldigits integer , options integer , nprefix text , id text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (geog geography, maxdecimaldigits integer , options integer , nprefix text , id text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (geog geography, maxdecimaldigits integer , options integer , nprefix text , id text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (geog geography, maxdecimaldigits integer , options integer , nprefix text , id text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsGML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (geog geography, maxdecimaldigits integer , nprefix text );
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (geog geography, maxdecimaldigits integer , nprefix text )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (geog geography, maxdecimaldigits integer , nprefix text )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (geog geography, maxdecimaldigits integer , nprefix text ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (geog geography, maxdecimaldigits integer , nprefix text ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsKML (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsKML (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsKML (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsKML (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsKML (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits integer , options integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits integer , options integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits integer , options integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits integer , options integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (geog geography, maxdecimaldigits integer , options integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsGeoJson (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsGeoJson (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsGeoJson (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsGeoJson (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsGeoJson (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (geog1 geography, geog2 geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (geog1 geography, geog2 geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (geog1 geography, geog2 geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (geog1 geography, geog2 geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (geog1 geography, geog2 geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Distance (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Distance (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Distance (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Distance (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Distance (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Expand (geography, float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_Expand (geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Expand (geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Expand (geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Expand (geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceUnCached (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceUnCached (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceUnCached (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceUnCached (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceUnCached (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceTree (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceTree (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceTree (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceTree (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceTree (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DistanceTree (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_DistanceTree (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DistanceTree (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DistanceTree (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DistanceTree (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithinUnCached (geography, geography, float8, boolean) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithinUnCached (geography, geography, float8);
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithinUnCached (geography, geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithinUnCached (geography, geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithinUnCached (geography, geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithinUnCached (geography, geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Area (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Area (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Area (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Area (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Area (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Area (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Length (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Length (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Length (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Length (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Length (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Length (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Project (geog geography, distance float8, azimuth float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Project (geog geography, distance float8, azimuth float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Project (geog geography, distance float8, azimuth float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Project (geog geography, distance float8, azimuth float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Project (geog geography, distance float8, azimuth float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Azimuth (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Azimuth (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Azimuth (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Azimuth (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Azimuth (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Perimeter (geog geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Perimeter (geog geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Perimeter (geog geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Perimeter (geog geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Perimeter (geog geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_PointOutside (geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_PointOutside (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_PointOutside (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_PointOutside (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_PointOutside (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Segmentize (geog geography, max_segment_length float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Segmentize (geog geography, max_segment_length float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Segmentize (geog geography, max_segment_length float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Segmentize (geog geography, max_segment_length float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Segmentize (geog geography, max_segment_length float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_BestSRID (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_BestSRID (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_BestSRID (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_BestSRID (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_BestSRID (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_BestSRID (geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_BestSRID (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_BestSRID (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_BestSRID (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_BestSRID (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (geography, float8, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (geography, float8, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (geography, float8, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (geography, float8, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (geography, float8, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Buffer (text, float8, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Buffer (text, float8, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Buffer (text, float8, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Buffer (text, float8, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Buffer (text, float8, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (geography, geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (geography, geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (geography, geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (geography, geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (geography, geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersection (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersection (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersection (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersection (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersection (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsBinary (geography, text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsBinary (geography, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsBinary (geography, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsBinary (geography, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsBinary (geography, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (geography, integer);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (geography, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (geography, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (geography, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (geography, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsEWKT (text);
	RAISE NOTICE 'newly registered FUNCTION ST_AsEWKT (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsEWKT (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsEWKT (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsEWKT (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION GeometryType (geography);
	RAISE NOTICE 'newly registered FUNCTION GeometryType (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION GeometryType (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION GeometryType (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION GeometryType (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Summary (geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Summary (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Summary (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Summary (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Summary (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_GeoHash (geog geography, maxchars integer );
	RAISE NOTICE 'newly registered FUNCTION ST_GeoHash (geog geography, maxchars integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_GeoHash (geog geography, maxchars integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_GeoHash (geog geography, maxchars integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_GeoHash (geog geography, maxchars integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SRID (geog geography);
	RAISE NOTICE 'newly registered FUNCTION ST_SRID (geog geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SRID (geog geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SRID (geog geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SRID (geog geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SetSRID (geog geography, srid integer);
	RAISE NOTICE 'newly registered FUNCTION ST_SetSRID (geog geography, srid integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SetSRID (geog geography, srid integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SetSRID (geog geography, srid integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SetSRID (geog geography, srid integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (geography, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (geography, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (geography, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (geography, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (geography, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Centroid (text);
	RAISE NOTICE 'newly registered FUNCTION ST_Centroid (text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Centroid (text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Centroid (text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Centroid (text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_Covers (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_Covers (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_Covers (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_Covers (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_Covers (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION _ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_CoveredBy (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION _ST_CoveredBy (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_CoveredBy (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_CoveredBy (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_CoveredBy (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (geog1 geography, geog2 geography, tolerance float8, use_spheroid boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (geog1 geography, geog2 geography);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (geog1 geography, geog2 geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (geog1 geography, geog2 geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (geog1 geography, geog2 geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (geog1 geography, geog2 geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Covers (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Covers (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Covers (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Covers (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Covers (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoveredBy (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_CoveredBy (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoveredBy (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoveredBy (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoveredBy (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DWithin (text, text, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DWithin (text, text, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DWithin (text, text, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DWithin (text, text, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DWithin (text, text, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Intersects (text, text);
	RAISE NOTICE 'newly registered FUNCTION ST_Intersects (text, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Intersects (text, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Intersects (text, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Intersects (text, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry, radius float8);
	RAISE NOTICE 'newly registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry, radius float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry, radius float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry, radius float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_DistanceSphere (geom1 geometry, geom2 geometry, radius float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean );
	RAISE NOTICE 'newly registered FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_type_name (geomname varchar, coord_dimension integer, use_new_name boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_srid (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_dims (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text);
	RAISE NOTICE 'newly registered FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION postgis_constraint_type (geomschema text, geomtable text, geomcolumn text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DMaxDistance (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DClosestPoint (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DShortestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLongestLine (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CoordDim (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_CoordDim (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CoordDim (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CoordDim (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CoordDim (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer );
	RAISE NOTICE 'newly registered FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_CurveToLine (geom geometry, tol float8 , toltype integer , flags integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HasArc (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_HasArc (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HasArc (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HasArc (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HasArc (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LineToCurve (Geometry geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_LineToCurve (Geometry geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LineToCurve (Geometry geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LineToCurve (Geometry geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LineToCurve (Geometry geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Point (float8, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_Point (float8, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Point (float8, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Point (float8, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Point (float8, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Point (float8, float8, srid integer);
	RAISE NOTICE 'newly registered FUNCTION ST_Point (float8, float8, srid integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Point (float8, float8, srid integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Point (float8, float8, srid integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Point (float8, float8, srid integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointZ (XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer );
	RAISE NOTICE 'newly registered FUNCTION ST_PointZ (XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointZ (XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointZ (XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointZ (XCoordinate float8, YCoordinate float8, ZCoordinate float8, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointM (XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer );
	RAISE NOTICE 'newly registered FUNCTION ST_PointM (XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointM (XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointM (XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointM (XCoordinate float8, YCoordinate float8, MCoordinate float8, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_PointZM (XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer );
	RAISE NOTICE 'newly registered FUNCTION ST_PointZM (XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_PointZM (XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_PointZM (XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_PointZM (XCoordinate float8, YCoordinate float8, ZCoordinate float8, MCoordinate float8, srid integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Polygon (geometry, int);
	RAISE NOTICE 'newly registered FUNCTION ST_Polygon (geometry, int)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Polygon (geometry, int)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Polygon (geometry, int) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Polygon (geometry, int) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_WKBToSQL (WKB bytea);
	RAISE NOTICE 'newly registered FUNCTION ST_WKBToSQL (WKB bytea)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_WKBToSQL (WKB bytea)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_WKBToSQL (WKB bytea) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_WKBToSQL (WKB bytea) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateBetween (Geometry geometry, FromMeasure float8, ToMeasure float8, LeftRightOffset float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 );
	RAISE NOTICE 'newly registered FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateAlong (Geometry geometry, Measure float8, LeftRightOffset float8 ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8);
	RAISE NOTICE 'newly registered FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_LocateBetweenElevations (Geometry geometry, FromElevation float8, ToElevation float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_InterpolatePoint (Line geometry, Point geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_InterpolatePoint (Line geometry, Point geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_InterpolatePoint (Line geometry, Point geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_InterpolatePoint (Line geometry, Point geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_InterpolatePoint (Line geometry, Point geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Hexagon (size float8, cell_i integer, cell_j integer, origin geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_Hexagon (size float8, cell_i integer, cell_j integer, origin geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Hexagon (size float8, cell_i integer, cell_j integer, origin geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Hexagon (size float8, cell_i integer, cell_j integer, origin geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Hexagon (size float8, cell_i integer, cell_j integer, origin geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Square (size float8, cell_i integer, cell_j integer, origin geometry );
	RAISE NOTICE 'newly registered FUNCTION ST_Square (size float8, cell_i integer, cell_j integer, origin geometry )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Square (size float8, cell_i integer, cell_j integer, origin geometry )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Square (size float8, cell_i integer, cell_j integer, origin geometry ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Square (size float8, cell_i integer, cell_j integer, origin geometry ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_HexagonGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer);
	RAISE NOTICE 'newly registered FUNCTION ST_HexagonGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_HexagonGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_HexagonGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_HexagonGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SquareGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer);
	RAISE NOTICE 'newly registered FUNCTION ST_SquareGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SquareGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SquareGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SquareGrid (size float8, bounds geometry, OUT geom geometry, OUT i integer, OUT j integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (box2df, geometry);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (box2df, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (box2df, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (box2df, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (box2df, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (box2df, box2df);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (box2df, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (box2df, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (box2df, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (box2df, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION contains_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION contains_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION contains_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION contains_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION contains_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION is_contained_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION is_contained_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION is_contained_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION is_contained_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION is_contained_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_2d (geometry, box2df);
	RAISE NOTICE 'newly registered FUNCTION overlaps_2d (geometry, box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_2d (geometry, box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_2d (geometry, box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_2d (geometry, box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (gidx, geometry);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (gidx, geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (gidx, geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (gidx, geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (gidx, geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (gidx, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (gidx, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (gidx, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (gidx, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (gidx, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION overlaps_nd (geometry, gidx);
	RAISE NOTICE 'newly registered FUNCTION overlaps_nd (geometry, gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION overlaps_nd (geometry, gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION overlaps_nd (geometry, gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION overlaps_nd (geometry, gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom2d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom3d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geom4d_brin_inclusion_add_value (internal, internal, internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_SimplifyPolygonHull (geom geometry, vertex_fraction float8, is_outer boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_SimplifyPolygonHull (geom geometry, vertex_fraction float8, is_outer boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_SimplifyPolygonHull (geom geometry, vertex_fraction float8, is_outer boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_SimplifyPolygonHull (geom geometry, vertex_fraction float8, is_outer boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_SimplifyPolygonHull (geom geometry, vertex_fraction float8, is_outer boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean );
	RAISE NOTICE 'newly registered FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_ConcaveHull (param_geom geometry, param_pctconvex float, param_allow_holes boolean ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION _ST_AsX3D (integer, geometry, integer, integer, text);
	RAISE NOTICE 'newly registered FUNCTION _ST_AsX3D (integer, geometry, integer, integer, text)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION _ST_AsX3D (integer, geometry, integer, integer, text)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION _ST_AsX3D (integer, geometry, integer, integer, text) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION _ST_AsX3D (integer, geometry, integer, integer, text) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer );
	RAISE NOTICE 'newly registered FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_AsX3D (geom geometry, maxdecimaldigits integer , options integer ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Angle (line1 geometry, line2 geometry);
	RAISE NOTICE 'newly registered FUNCTION ST_Angle (line1 geometry, line2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Angle (line1 geometry, line2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Angle (line1 geometry, line2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Angle (line1 geometry, line2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_3DLineInterpolatePoint (geometry, float8);
	RAISE NOTICE 'newly registered FUNCTION ST_3DLineInterpolatePoint (geometry, float8)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_3DLineInterpolatePoint (geometry, float8)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_3DLineInterpolatePoint (geometry, float8) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_3DLineInterpolatePoint (geometry, float8) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_config_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_config_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_config_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_config_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_config_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_choose_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_choose_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_choose_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_choose_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_choose_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_picksplit_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_picksplit_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_picksplit_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_picksplit_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_picksplit_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_inner_consistent_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_inner_consistent_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_inner_consistent_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_inner_consistent_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_inner_consistent_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_leaf_consistent_2d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_compress_2d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_compress_2d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_compress_2d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_compress_2d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_compress_2d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_overlaps_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contains_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_contained_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_same_3d (geom1 geometry, geom2 geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_config_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_config_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_config_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_config_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_config_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_choose_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_choose_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_choose_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_choose_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_choose_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_picksplit_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_picksplit_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_picksplit_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_picksplit_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_picksplit_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_inner_consistent_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_inner_consistent_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_inner_consistent_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_inner_consistent_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_inner_consistent_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_leaf_consistent_3d (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_compress_3d (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_compress_3d (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_compress_3d (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_compress_3d (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_compress_3d (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_config_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_config_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_config_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_config_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_config_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_choose_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_choose_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_choose_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_choose_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_choose_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_picksplit_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_picksplit_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_picksplit_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_picksplit_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_picksplit_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_inner_consistent_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_inner_consistent_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_inner_consistent_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_inner_consistent_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_inner_consistent_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_leaf_consistent_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_leaf_consistent_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_leaf_consistent_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_leaf_consistent_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_leaf_consistent_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_spgist_compress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_spgist_compress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_spgist_compress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_spgist_compress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_spgist_compress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_config_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_config_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_config_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_config_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_config_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_choose_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_choose_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_choose_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_choose_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_choose_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_picksplit_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_picksplit_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_picksplit_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_picksplit_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_picksplit_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_inner_consistent_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_inner_consistent_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_inner_consistent_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_inner_consistent_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_inner_consistent_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_leaf_consistent_nd (internal, internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_leaf_consistent_nd (internal, internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_leaf_consistent_nd (internal, internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_leaf_consistent_nd (internal, internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_leaf_consistent_nd (internal, internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_spgist_compress_nd (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_spgist_compress_nd (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_spgist_compress_nd (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_spgist_compress_nd (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_spgist_compress_nd (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION ST_Letters (letters text, font json );
	RAISE NOTICE 'newly registered FUNCTION ST_Letters (letters text, font json )';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION ST_Letters (letters text, font json )';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION ST_Letters (letters text, font json ) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION ST_Letters (letters text, font json ) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Add all functions needed for types definition (needed?).
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION spheroid_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION spheroid_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION spheroid_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION spheroid_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION spheroid_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION spheroid_out (spheroid);
	RAISE NOTICE 'newly registered FUNCTION spheroid_out (spheroid)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION spheroid_out (spheroid)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION spheroid_out (spheroid) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION spheroid_out (spheroid) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION geometry_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_out (geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_out (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_out (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_out (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_out (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_typmod_in (cstring[]);
	RAISE NOTICE 'newly registered FUNCTION geometry_typmod_in (cstring[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_typmod_in (cstring[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_typmod_in (cstring[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_typmod_in (cstring[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_typmod_out (integer);
	RAISE NOTICE 'newly registered FUNCTION geometry_typmod_out (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_typmod_out (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_typmod_out (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_typmod_out (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_analyze (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_analyze (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_analyze (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_analyze (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_analyze (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_recv (internal);
	RAISE NOTICE 'newly registered FUNCTION geometry_recv (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_recv (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_recv (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_recv (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geometry_send (geometry);
	RAISE NOTICE 'newly registered FUNCTION geometry_send (geometry)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geometry_send (geometry)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geometry_send (geometry) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geometry_send (geometry) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION box3d_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box3d_out (box3d);
	RAISE NOTICE 'newly registered FUNCTION box3d_out (box3d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box3d_out (box3d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box3d_out (box3d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box3d_out (box3d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION box2d_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2d_out (box2d);
	RAISE NOTICE 'newly registered FUNCTION box2d_out (box2d)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2d_out (box2d)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2d_out (box2d) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2d_out (box2d) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2df_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION box2df_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2df_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2df_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2df_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION box2df_out (box2df);
	RAISE NOTICE 'newly registered FUNCTION box2df_out (box2df)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION box2df_out (box2df)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION box2df_out (box2df) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION box2df_out (box2df) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gidx_in (cstring);
	RAISE NOTICE 'newly registered FUNCTION gidx_in (cstring)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gidx_in (cstring)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gidx_in (cstring) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gidx_in (cstring) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION gidx_out (gidx);
	RAISE NOTICE 'newly registered FUNCTION gidx_out (gidx)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION gidx_out (gidx)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION gidx_out (gidx) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION gidx_out (gidx) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_typmod_in (cstring[]);
	RAISE NOTICE 'newly registered FUNCTION geography_typmod_in (cstring[])';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_typmod_in (cstring[])';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_typmod_in (cstring[]) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_typmod_in (cstring[]) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_typmod_out (integer);
	RAISE NOTICE 'newly registered FUNCTION geography_typmod_out (integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_typmod_out (integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_typmod_out (integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_typmod_out (integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_in (cstring, oid, integer);
	RAISE NOTICE 'newly registered FUNCTION geography_in (cstring, oid, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_in (cstring, oid, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_in (cstring, oid, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_in (cstring, oid, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_out (geography);
	RAISE NOTICE 'newly registered FUNCTION geography_out (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_out (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_out (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_out (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_recv (internal, oid, integer);
	RAISE NOTICE 'newly registered FUNCTION geography_recv (internal, oid, integer)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_recv (internal, oid, integer)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_recv (internal, oid, integer) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_recv (internal, oid, integer) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_send (geography);
	RAISE NOTICE 'newly registered FUNCTION geography_send (geography)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_send (geography)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_send (geography) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_send (geography) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD FUNCTION geography_analyze (internal);
	RAISE NOTICE 'newly registered FUNCTION geography_analyze (internal)';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered FUNCTION geography_analyze (internal)';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object FUNCTION geography_analyze (internal) does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add FUNCTION geography_analyze (internal) to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
-- Register all types.
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE spheroid;
	RAISE NOTICE 'newly registered TYPE spheroid';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE spheroid';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE spheroid does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE spheroid to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE geometry;
	RAISE NOTICE 'newly registered TYPE geometry';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE geometry';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE geometry does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE geometry to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE box3d;
	RAISE NOTICE 'newly registered TYPE box3d';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE box3d';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE box3d does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE box3d to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE box2d;
	RAISE NOTICE 'newly registered TYPE box2d';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE box2d';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE box2d does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE box2d to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE box2df;
	RAISE NOTICE 'newly registered TYPE box2df';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE box2df';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE box2df does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE box2df to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE gidx;
	RAISE NOTICE 'newly registered TYPE gidx';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE gidx';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE gidx does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE gidx to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE geometry_dump;
	RAISE NOTICE 'newly registered TYPE geometry_dump';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE geometry_dump';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE geometry_dump does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE geometry_dump to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE valid_detail;
	RAISE NOTICE 'newly registered TYPE valid_detail';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE valid_detail';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE valid_detail does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE valid_detail to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';
DO $$
BEGIN

	-- TODO: check if ownership of the object
	--       matches ownership of the extension
	--       the object to the extension

	ALTER EXTENSION postgis ADD TYPE geography;
	RAISE NOTICE 'newly registered TYPE geography';

EXCEPTION
WHEN object_not_in_prerequisite_state THEN
  IF SQLERRM ~ '\mpostgis\M'
  THEN
    RAISE NOTICE 'already registered TYPE geography';
  ELSE
    RAISE EXCEPTION '%', SQLERRM;
  END IF;
WHEN
	undefined_function OR
	undefined_table OR
	undefined_object
	-- TODO: handle more exceptions ?
THEN
	RAISE NOTICE 'Object TYPE geography does not exist yet';
WHEN OTHERS THEN
	RAISE EXCEPTION 'Trying to add TYPE geography to postgis, got % (%)', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE 'plpgsql';

\echo Use "CREATE EXTENSION postgis" to load this file. \quit
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
----
-- PostGIS - Spatial Types for PostgreSQL
-- http://postgis.net
--
-- Copyright (C) 2011 Regina Obe <lr@pcorp.us>
--
-- This is free software; you can redistribute and/or modify it under
-- the terms of the GNU General Public Licence. See the COPYING file.
--
-- Author: Regina Obe <lr@pcorp.us>
--
-- This is a suite of SQL helper functions for use during a PostGIS extension install/upgrade
-- The functions get uninstalled after the extention install/upgrade process
---------------------------
-- postgis_extension_remove_objects: This function removes objects of a particular class from an extension
-- this is needed because there is no ALTER EXTENSION DROP FUNCTION/AGGREGATE command
-- and we can't CREATE OR REPALCe functions whose signatures have changed and we can drop them if they are part of an extention
-- So we use this to remove it from extension first before we drop
CREATE FUNCTION postgis_extension_remove_objects(param_extension text, param_type text)
  RETURNS boolean AS
$$
DECLARE
	var_sql text := '';
	var_r record;
	var_result boolean := false;
	var_class text := '';
	var_is_aggregate boolean := false;
	var_sql_list text := '';
	var_pgsql_version integer := pg_catalog.current_setting('server_version_num');
BEGIN
		var_class := CASE WHEN pg_catalog.lower(param_type) OPERATOR(pg_catalog.=)'function' OR pg_catalog.lower(param_type) OPERATOR(pg_catalog.=) 'aggregate' THEN 'pg_catalog.pg_proc' ELSE '' END;
		var_is_aggregate := CASE WHEN pg_catalog.lower(param_type) OPERATOR(pg_catalog.=) 'aggregate' THEN true ELSE false END;

		IF var_pgsql_version OPERATOR(pg_catalog.<) 110000 THEN
			var_sql_list := $sql$SELECT 'ALTER EXTENSION ' OPERATOR(pg_catalog.||)  e.extname OPERATOR(pg_catalog.||) ' DROP ' OPERATOR(pg_catalog.||) $3 OPERATOR(pg_catalog.||) ' ' OPERATOR(pg_catalog.||) COALESCE(proc.proname OPERATOR(pg_catalog.||) '(' OPERATOR(pg_catalog.||) oidvectortypes(proc.proargtypes) OPERATOR(pg_catalog.||) ')' ,typ.typname, cd.relname, op.oprname,
					cs.typname OPERATOR(pg_catalog.||) ' AS ' OPERATOR(pg_catalog.||) ct.typname OPERATOR(pg_catalog.||) ') ', opcname, opfname) OPERATOR(pg_catalog.||) ';' AS remove_command
			FROM pg_catalog.pg_depend As d INNER JOIN pg_catalog.pg_extension As e
				ON d.refobjid OPERATOR(pg_catalog.=) e.oid INNER JOIN pg_catalog.pg_class As c ON
					c.oid OPERATOR(pg_catalog.=) d.classid
					LEFT JOIN pg_catalog.pg_proc AS proc ON proc.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_type AS typ ON typ.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_class As cd ON cd.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_operator As op ON op.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_cast AS ca ON ca.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_type AS cs ON ca.castsource OPERATOR(pg_catalog.=) cs.oid
					LEFT JOIN pg_catalog.pg_type AS ct ON ca.casttarget OPERATOR(pg_catalog.=) ct.oid
					LEFT JOIN pg_opclass As oc ON oc.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_opfamily As ofa ON ofa.oid OPERATOR(pg_catalog.=) d.objid
			WHERE d.deptype OPERATOR(pg_catalog.=) 'e' and e.extname OPERATOR(pg_catalog.=) $1 and c.relname OPERATOR(pg_catalog.=) $2 AND COALESCE(proc.proisagg, false) OPERATOR(pg_catalog.=) $4;$sql$;
		ELSE -- for PostgreSQL 11 and above, they removed proc.proisagg among others and replaced with some func type thing
			var_sql_list := $sql$SELECT 'ALTER EXTENSION ' OPERATOR(pg_catalog.||) e.extname OPERATOR(pg_catalog.||) ' DROP ' OPERATOR(pg_catalog.||) $3 OPERATOR(pg_catalog.||) ' ' OPERATOR(pg_catalog.||) COALESCE(proc.proname OPERATOR(pg_catalog.||) '(' OPERATOR(pg_catalog.||) oidvectortypes(proc.proargtypes) OPERATOR(pg_catalog.||) ')' ,typ.typname, cd.relname, op.oprname,
					cs.typname OPERATOR(pg_catalog.||) ' AS ' OPERATOR(pg_catalog.||) ct.typname OPERATOR(pg_catalog.||) ') ', opcname, opfname) OPERATOR(pg_catalog.||) ';' AS remove_command
			FROM pg_catalog.pg_depend As d INNER JOIN pg_catalog.pg_extension As e
				ON d.refobjid OPERATOR(pg_catalog.=) e.oid INNER JOIN pg_catalog.pg_class As c ON
					c.oid OPERATOR(pg_catalog.=) d.classid
					LEFT JOIN pg_catalog.pg_proc AS proc ON proc.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_type AS typ ON typ.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_class As cd ON cd.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_operator As op ON op.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_cast AS ca ON ca.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_catalog.pg_type AS cs ON ca.castsource OPERATOR(pg_catalog.=) cs.oid
					LEFT JOIN pg_catalog.pg_type AS ct ON ca.casttarget OPERATOR(pg_catalog.=) ct.oid
					LEFT JOIN pg_opclass As oc ON oc.oid OPERATOR(pg_catalog.=) d.objid
					LEFT JOIN pg_opfamily As ofa ON ofa.oid OPERATOR(pg_catalog.=) d.objid
			WHERE d.deptype OPERATOR(pg_catalog.=) 'e' and e.extname OPERATOR(pg_catalog.=) $1 and c.relname OPERATOR(pg_catalog.=) $2 AND (proc.prokind OPERATOR(pg_catalog.=) 'a')  OPERATOR(pg_catalog.=) $4;$sql$;
		END IF;

		FOR var_r IN EXECUTE var_sql_list  USING param_extension, var_class, param_type, var_is_aggregate
		LOOP
			var_sql := var_sql OPERATOR(pg_catalog.||) var_r.remove_command OPERATOR(pg_catalog.||) ';';
		END LOOP;
		IF var_sql > '' THEN
			EXECUTE var_sql;
			var_result := true;
		END IF;

		RETURN var_result;
END;
$$
LANGUAGE plpgsql VOLATILE;

CREATE FUNCTION postgis_extension_drop_if_exists(param_extension text, param_statement text)
  RETURNS boolean AS
$$
DECLARE
	var_sql_ext text := 'ALTER EXTENSION ' OPERATOR(pg_catalog.||) pg_catalog.quote_ident(param_extension) OPERATOR(pg_catalog.||) ' ' OPERATOR(pg_catalog.||) pg_catalog.replace(param_statement, 'IF EXISTS', '');
	var_result boolean := false;
BEGIN
	BEGIN
		EXECUTE var_sql_ext;
		var_result := true;
	EXCEPTION
		WHEN OTHERS THEN
			--this is to allow ignoring if the object does not exist in extension
			var_result := false;
	END;
	RETURN var_result;
END;
$$
LANGUAGE plpgsql VOLATILE;

CREATE FUNCTION postgis_extension_AddToSearchPath(a_schema_name text)
RETURNS text
AS
$$
DECLARE
	var_result text;
	var_cur_search_path text;
BEGIN

	WITH settings AS (
		SELECT pg_catalog.unnest(setconfig) config
		FROM pg_catalog.pg_db_role_setting
		WHERE setdatabase OPERATOR(pg_catalog.=) (
			SELECT oid
			FROM pg_catalog.pg_database
			WHERE datname OPERATOR(pg_catalog.=) pg_catalog.current_database()
		) and setrole OPERATOR(pg_catalog.=) 0
	)
	SELECT pg_catalog.regexp_replace(config, '^search_path=', '')
	FROM settings WHERE config like 'search_path=%'
	INTO var_cur_search_path;

	RAISE NOTICE 'cur_search_path from pg_db_role_setting is %', var_cur_search_path;

	IF var_cur_search_path IS NULL THEN
		SELECT reset_val
		INTO var_cur_search_path
		FROM pg_catalog.pg_settings
		WHERE name OPERATOR(pg_catalog.=) 'search_path';

		RAISE NOTICE 'cur_search_path from pg_settings is %', var_cur_search_path;
	END IF;


	IF var_cur_search_path LIKE '%' OPERATOR(pg_catalog.||) pg_catalog.quote_ident(a_schema_name) OPERATOR(pg_catalog.||) '%' THEN
		var_result := a_schema_name OPERATOR(pg_catalog.||) ' already in database search_path';
	ELSE
		var_cur_search_path := var_cur_search_path OPERATOR(pg_catalog.||) ', '
                       OPERATOR(pg_catalog.||) pg_catalog.quote_ident(a_schema_name);
		EXECUTE 'ALTER DATABASE ' OPERATOR(pg_catalog.||) pg_catalog.quote_ident(pg_catalog.current_database())
                             OPERATOR(pg_catalog.||) ' SET search_path = ' OPERATOR(pg_catalog.||) var_cur_search_path;
		var_result := a_schema_name OPERATOR(pg_catalog.||) ' has been added to end of database search_path ';
	END IF;

	EXECUTE 'SET search_path = ' OPERATOR(pg_catalog.||) var_cur_search_path;

  RETURN var_result;
END
$$
LANGUAGE 'plpgsql' VOLATILE STRICT;
DO $unpackage_if_needed$
BEGIN
	IF EXISTS (
		select t.typname from pg_catalog.pg_depend d, pg_catalog.pg_extension e, pg_catalog.pg_type t where
		e.extname = 'postgis' and d.refclassid =
		'pg_catalog.pg_extension'::pg_catalog.regclass and d.refobjid = e.oid
		and d.classid = 'pg_catalog.pg_type'::pg_catalog.regclass and d.objid = t.oid
		and t.typname = 'raster'
	) THEN

		RAISE WARNING 'unpackaging raster';

		EXECUTE $unpackage$
		-- UNPACKAGE_CODE --
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bytea(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box2d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box2d(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebra(raster, integer, text, text, nodatavaluerepl text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebra(raster, pixeltype text, expression text, nodatavaluerepl text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, integer, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraExpr(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapalgebraFct(raster, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, text, regprocedure, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, regprocedure, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, integer, regprocedure, variadic text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, integer, text, regprocedure, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, integer, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, integer, regprocedure, variadic text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapalgebraFct(raster, integer, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, raster, regprocedure, text, text, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFct(raster, integer, raster, integer, regprocedure, text, text, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MapAlgebraFctNgb(raster, integer, text, integer, integer, regprocedure, text,  VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION  ST_MapAlgebraFct(raster, raster, regprocedure, VARIADIC text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text[] , double precision[] , double precision[] , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , integer , integer , double precision , double precision , text[] , double precision[] , double precision[] , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , double precision , double precision , text , double precision , double precision , double precision , double precision , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_AsRaster(geometry , raster , text , double precision , double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_AsRaster(geometry,double precision , double precision, integer , integer,text[] , double precision[] ,double precision[] ,  double precision,  double precision, double precision,double precision, double precision, double precision,touched boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_Resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Resample(raster, raster, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_HasNoBand(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandNoDataValue(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetGeoReference(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue(raster, integer, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_dumpaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_polygon(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster(int, int, float8, float8, float8, float8, float8, float8, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, int, text, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata(raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpixeltype(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference(raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, VARIADIC int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelAsPolygons(raster,integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster,int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster,int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text,integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text,integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(raster,int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text,integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(raster, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, boolean, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, int, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, int, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(text, text, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(raster, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile(text, text, int, boolean, double precision, double precision[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE quantile;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, integer, boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(text, text, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, integer, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount(raster, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(text, text, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount(raster, integer, boolean, double precision[], double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE valuecount;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(raster, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( raster, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(raster, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( raster, int, boolean, double precision, int, double precision[], boolean, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram( text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE histogram;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE bandmetadata;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE geomvalxy;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _rename_raster_tables();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterColumn(varchar, varchar, integer, varchar[], boolean, boolean, double precision[], double precision, double precision, integer, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterColumn(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar, varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterTable(varchar);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION AddRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION DropRasterConstraints(name, name, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _drop_st_samealignment();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects(raster, integer, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects(raster, integer, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minpossibleval(text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygon(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, int, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, geometry, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, integer, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, geometry, float8, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, geometry, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, int, geometry, float8, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, geometry, float8[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_clip(raster, integer, geometry, float8[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_dumpaswktpolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP TYPE wktgeomval;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_nearestvalue(raster, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, integer, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, integer, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_neighborhood(raster, geometry, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, integer, raster, integer, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, text, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersection(raster, raster, regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelaspolygons(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandsurface(raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_intersects(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_intersects(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_overlaps(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_touches(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_touches(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(raster, integer, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(raster, geometry, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_contains(geometry, raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband(raster, raster[], integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope(raster, integer, text, text, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope(raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect(raster, integer, text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect(raster, integer, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect(raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, double precision, double precision, double precision, double precision, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade(raster, integer, text, float, float, float, float);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, integer, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setvalue(raster, geometry, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoord(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_world2rastercoord(raster, double precision, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordx(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_world2rastercoordy(raster, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoord( raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_raster2worldcoord(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordx(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_raster2worldcoordy(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_resample(raster, text, double precision, integer, double precision, double precision, double precision, double precision, double precision, double precision, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, double precision, double precision, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample(raster, integer, integer, integer, double precision, double precision, double precision, double precision, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile(raster, integer, integer, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer[], integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile(raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _add_raster_constraint_regular_blocking(name, name, name);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asbinary(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma(float8[], text, text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandmetadata(raster, int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, text, text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE ST_Union(raster, record[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,boolean,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster,boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(raster, integer, boolean, geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersects(geometry, raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(raster,raster, integer, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Intersection(geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionfinal1(raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, int4, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra4unionstate(raster, raster, text, text, text, float8, text, text, text, float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra(rastbandarg[],regprocedure,text,integer,integer,text,raster,text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, int, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, integer, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram(text, text, int, boolean, double precision, int,double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, boolean, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram(text, text, int, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram( ext, text, int, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, boolean, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int,double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, double precision[], boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram(text, text, int, double precision, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile( rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile( rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile( rastertable text, rastercolumn text, nband int, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile( rastertable text, rastercolumn text, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, nband int, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile( rastertable text, rastercolumn text, nband int, sample_percent double precision, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile( rastertable text, rastercolumn text, sample_percent double precision, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile( rastertable text, rastercolumn text, quantiles double precision[], OUT quantile double precision, OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, nband int, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile(rastertable text, rastercolumn text, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value(rast raster, band integer, pt geometry, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdalopenoptions(opts text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_columns;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP VIEW raster_overviews;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_summarystatsagg (raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, integer, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_countagg (raster, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_samealignment (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, unionarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP AGGREGATE st_union (raster, text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR CLASS hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR FAMILY hash_raster_ops USING hash;EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR =  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR <<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &<|  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR >>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |&>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR |>>  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~=  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (raster,geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR ~  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR @  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP OPERATOR &&  (geometry,raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS box3d);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS geometry);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP CAST (raster AS bytea);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_scripts_installed ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_raster_lib_build_date ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION postgis_gdal_version ();EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_envelope (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_convexhull (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_minconvexhull (	rast raster,	nband integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION box3d (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_height (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_numbands (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scalex (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_scaley (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_skewy (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_srid (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperleftx (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_upperlefty (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_width (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelwidth (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelheight (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_geotransform (raster,    OUT imag double precision,    OUT jmag double precision,    OUT theta_i double precision,    OUT theta_ij double precision,    OUT xoffset double precision,    OUT yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rotation (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_metadata (	rast raster,	OUT upperleftx double precision,	OUT upperlefty double precision,	OUT width int,	OUT height int,	OUT scalex double precision,	OUT scaley double precision,	OUT skewx double precision,	OUT skewy double precision,	OUT srid int,	OUT numbands int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summary (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_MemSize (raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, scalex float8, scaley float8, skewx float8, skewy float8, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (width int, height int, upperleftx float8, upperlefty float8, pixelsize float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_makeemptyraster (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (rast raster, addbandargset addbandarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	pixeltype text,	initialvalue float8 ,	nodataval float8 );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrast raster,	fromband int ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	torast raster,	fromrasts raster[], fromband integer ,	torastindex int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	index int,	outdbfile text, outdbindex int[],	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_addband (	rast raster,	outdbfile text, outdbindex int[],	index int ,	nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands int[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nband int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_band (rast raster, nbands text, delimiter char );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	nband int ,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_summarystats (	rast raster,	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	nband int,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	exclude_nodata_value boolean,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxsummarystats (	rast raster,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_finalfn (internal);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, integer,	boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, boolean, double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_summarystats_transfn (	internal,	raster, int, boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_count (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, nband int , exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_count (rast raster, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int , exclude_nodata_value boolean , sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, nband int, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, exclude_nodata_value boolean, sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxcount (rast raster, sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_finalfn (agg agg_count);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION __st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer , exclude_nodata_value boolean ,	sample_percent double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean,	sample_percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	nband integer, exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_countagg_transfn (	agg agg_count,	rast raster, 	exclude_nodata_value boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	min double precision , max double precision ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	exclude_nodata_value boolean,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_histogram (	rast raster, nband int,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	bins int , width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	exclude_nodata_value boolean,	sample_percent double precision,	bins int,	right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster,	sample_percent double precision,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, width double precision[] ,	right boolean ,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxhistogram (	rast raster, nband int,	sample_percent double precision,	bins int, right boolean,	OUT min double precision,	OUT max double precision,	OUT count bigint,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	nband int,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, exclude_nodata_value boolean, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, nband int, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_quantile (rast raster, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int ,	exclude_nodata_value boolean ,	sample_percent double precision ,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	nband int,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	sample_percent double precision,	quantiles double precision[] ,	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (	rast raster,	quantiles double precision[],	OUT quantile double precision,	OUT value double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, exclude_nodata_value boolean, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, nband int, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, sample_percent double precision, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, exclude_nodata_value boolean, quantile double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_approxquantile (rast raster, quantile double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rast raster, nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rast raster, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_valuecount (	rastertable text,	rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision,	OUT count integer,	OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT count integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuecount (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (	rastertable text, rastercolumn text,	nband integer ,	exclude_nodata_value boolean ,	searchvalues double precision[] ,	roundto double precision ,	OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalues double precision[], roundto double precision , OUT value double precision, OUT percent double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, exclude_nodata_value boolean, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, nband integer, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_valuepercent (rastertable text, rastercolumn text, searchvalue double precision, roundto double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, VARIADIC reclassargset reclassarg[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, nband int, reclassexpr text, pixeltype text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reclass (rast raster, reclassexpr text, pixeltype text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_colormap (	rast raster, nband int,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster, nband int ,	colormap text ,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_colormap (	rast raster,	colormap text,	method text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_fromgdalraster (gdaldata bytea, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_gdaldrivers (	OUT idx int,	OUT short_name text,	OUT long_name text,	OUT can_read boolean,	OUT can_write boolean,	OUT create_options text);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asgdalraster (rast raster, format text, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_Contour (		rast raster,		bandnumber integer ,		level_interval float8 ,		level_base float8 ,		fixed_levels float8[] ,		polygonize boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_InterpolateRaster (		geom geometry,		options text,		rast raster,		bandnumber integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], options text[] , srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_astiff (rast raster, nbands int[], compression text, srid integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nbands int[], quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asjpeg (rast raster, nband int, quality int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nbands int[], compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, options text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspng (rast raster, nband int, compression int);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_asraster (	geom geometry,	scalex double precision , scaley double precision ,	width integer , height integer ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision , gridy double precision ,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text[],	value double precision[] ,	nodataval double precision[] ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	scalex double precision, scaley double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	gridx double precision, gridy double precision,	pixeltype text,	value double precision ,	nodataval double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	width integer, height integer,	pixeltype text,	value double precision ,	nodataval double precision ,	upperleftx double precision , upperlefty double precision ,	skewx double precision , skewy double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text[] ,	value double precision[] ,	nodataval double precision[] ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_asraster (	geom geometry,	ref raster,	pixeltype text,	value double precision ,	nodataval double precision ,	touched boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_gdalwarp (	rast raster,	algorithm text , maxerr double precision ,	srid integer ,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	width integer , height integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	scalex double precision , scaley double precision ,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	width integer, height integer,	gridx double precision , gridy double precision ,	skewx double precision , skewy double precision ,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	algorithm text ,	maxerr double precision ,	usescale boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resample (	rast raster,	ref raster,	usescale boolean,	algorithm text ,	maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, algorithm text , maxerr double precision , scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (rast raster, srid integer, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_transform (	rast raster,	alignto raster,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalex double precision, scaley double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_rescale (rast raster, scalexy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewx double precision, skewy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_reskew (rast raster, skewxy double precision, algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	algorithm text , maxerr double precision ,	scalex double precision , scaley double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalex double precision, scaley double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_snaptogrid (	rast raster,	gridx double precision, gridy double precision,	scalexy double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width text, height text,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	width integer, height integer,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_resize (	rast raster,	percentwidth double precision, percentheight double precision,	algorithm text , maxerr double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, band integer, pixeltype text,        expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (rast raster, pixeltype text, expression text,        nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        pixeltype text, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, band integer,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, pixeltype text,        onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure,        variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (rast raster, onerastuserfunc regprocedure);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebraexpr (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	tworastuserfunc regprocedure,	pixeltype text , extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafct (	rast1 raster,	rast2 raster,	tworastuserfunc regprocedure,	pixeltype text , extenttype text ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebrafctngb (    rast raster,    band integer,    pixeltype text,    ngbwidth integer,    ngbheight integer,    onerastngbuserfunc regprocedure,    nodatamode text,    variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (matrix float[][], nodatamode text, variadic args text[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (matrix float[][], nodatamode TEXT, VARIADIC args TEXT[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	distancex integer , distancey integer ,	extenttype text , customextent raster ,	mask double precision[][] , weighted boolean ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rastbandargset rastbandarg[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int[],	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, nband1 int,	rast2 raster, nband2 int,	callbackfunc regprocedure,	pixeltype text ,	extenttype text , customextent raster ,	distancex integer , distancey integer ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband int,	callbackfunc regprocedure,	mask double precision [][], weighted boolean,	pixeltype text ,	extenttype text , customextent raster ,	VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_mapalgebra (	rastbandargset rastbandarg[],	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster, nband integer,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast raster,	pixeltype text,	expression text, nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster, band1 integer,	rast2 raster, band2 integer,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mapalgebra (	rast1 raster,	rast2 raster,	expression text,	pixeltype text , extenttype text ,	nodata1expr text , nodata2expr text ,	nodatanodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_convertarray4ma (value double precision[][]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_max4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_min4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_sum4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mean4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_range4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_distinct4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_stddev4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_invdistweight4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_mindist4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_slope4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster, nband integer,	customextent raster,	pixeltype text , units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_slope (	rast raster, nband integer ,	pixeltype text , units text ,	scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_aspect4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster, nband integer,	customextent raster,	pixeltype text , units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_aspect (	rast raster, nband integer ,	pixeltype text , units text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_hillshade4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer,	customextent raster,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hillshade (	rast raster, nband integer ,	pixeltype text ,	azimuth double precision , altitude double precision ,	max_bright double precision , scale double precision ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tpi4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tpi (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_roughness4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_roughness (	rast raster, nband integer,	customextent raster,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_roughness (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tri4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer,	customextent raster,	pixeltype text ,	interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tri (	rast raster, nband integer ,	pixeltype text , interpolate_nodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_grayscale4ma (value double precision[][][], pos integer[][], VARIADIC userargs text[] );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rastbandargset rastbandarg[],	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_grayscale (	rast raster, 	redband integer , 	greenband integer , 	blueband integer ,	extenttype text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_isempty (rast raster);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_hasnoband (rast raster, nband int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandnodatavalue (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, band integer , forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandisnodata (rast raster, forceChecking boolean);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_bandpath (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandPixelType (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int[]);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandMetaData (	rast raster,	band int );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_BandFileSize (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION St_BandFileTimestamp (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, band integer, pt geometry, exclude_nodata_value boolean , resample text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, x integer, y integer, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_value (rast raster, pt geometry, exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setz (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setm (rast raster, geom geometry, resample text , band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_PixelofValue (	rast raster,	search double precision[],	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	nband integer,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_pixelofvalue (	rast raster,	search double precision,	exclude_nodata_value boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_georeference (rast raster, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scale float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setscale (rast raster, scalex float8, scaley float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skew float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setskew (rast raster, skewx float8, skewy float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setsrid (rast raster, srid integer);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setupperleft (rast raster, upperleftx float8, upperlefty float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setrotation (rast raster, rotation float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeotransform (rast raster,    imag double precision,    jmag double precision,    theta_i double precision,    theta_ij double precision,    xoffset double precision,    yoffset double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (rast raster, georef text, format text );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setgeoreference (	rast raster,	upperleftx double precision, upperlefty double precision,	scalex double precision, scaley double precision,	skewx double precision, skewy double precision);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _st_tile (	rast raster,	width integer, height integer,	nband integer[] ,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer[],	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster, nband integer,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_tile (	rast raster,	width integer, height integer,	padwithnodata boolean , nodataval double precision );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, band integer, nodatavalue float8, forceChecking boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandnodatavalue (rast raster, nodatavalue float8);EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandisnodata (rast raster, band integer );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandpath (rast raster, band integer, outdbpath text, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION st_setbandindex (rast raster, band integer, outdbindex integer, force boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION _ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	hasnosetvalue boolean ,	nosetvalue double precision ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	noset boolean[][] ,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	newvalueset double precision[][],	nosetvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster,	x integer, y integer,	width integer, height integer,	newvalue double precision,	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS THEN  RAISE EXCEPTION 'Got % - %', SQLSTATE, SQLERRM; END $$ LANGUAGE 'plpgsql';
DO $$ BEGIN ALTER EXTENSION postgis DROP FUNCTION ST_SetValues (	rast raster, nband integer,	geomvalset geomval[],	keepnodata boolean );EXCEPTION WHEN object_not_in_prerequisite_state OR undefined_function OR undefined_object THEN  RAISE NOTICE '%', SQLERRM; WHEN OTHERS TH