"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = query;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function query(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(request);
    return response.ok({
      body: retVal
    });
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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