"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
var geometries_1 = require("./geometries");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getPickedShapes = re_reselect_1.default([geometries_1.partitionGeometries, getCurrentPointerPosition], function (geoms, pointerPosition) {
    var picker = geoms.pickQuads;
    var diskCenter = geoms.diskCenter;
    var x = pointerPosition.x - diskCenter.x;
    var y = pointerPosition.y - diskCenter.y;
    return picker(x, y);
})(function (state) { return state.chartId; });
exports.getPickedShapesLayerValues = re_reselect_1.default([exports.getPickedShapes], pickShapesLayerValues)(function (state) { return state.chartId; });
function pickShapesLayerValues(pickedShapes) {
    var maxDepth = pickedShapes.reduce(function (acc, curr) { return Math.max(acc, curr.depth); }, 0);
    var elements = pickedShapes
        .filter(function (_a) {
        var depth = _a.depth;
        return depth === maxDepth;
    })
        .map(function (model) {
        var values = [];
        values.push({
            groupByRollup: model.dataName,
            value: model.value,
        });
        var parent = model[group_by_rollup_1.PARENT_KEY];
        var index = model[group_by_rollup_1.PARENT_KEY].sortIndex;
        while (parent[group_by_rollup_1.DEPTH_KEY] > 0) {
            var value = parent[group_by_rollup_1.AGGREGATE_KEY];
            var dataName = parent[group_by_rollup_1.PARENT_KEY][group_by_rollup_1.CHILDREN_KEY][index][0];
            values.push({ groupByRollup: dataName, value: value });
            parent = parent[group_by_rollup_1.PARENT_KEY];
            index = parent[group_by_rollup_1.SORT_INDEX_KEY];
        }
        return values.reverse();
    });
    return elements;
}
exports.pickShapesLayerValues = pickShapesLayerValues;
//# sourceMappingURL=picked_shapes.js.map