/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.beans.Introspector;
import java.lang.reflect.Method;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class DefaultNameFactory
implements NameFactory {
    public String getParameterName(Signature sig, int num) {
        Method method = sig.getMethod();
        String methodName = method.getName();
        Class[] parameters = method.getParameterTypes();
        Class<?> type = parameters[num];
        String className = type.getName().replace('$', '.');
        if (methodName.length() > 3) {
            if (methodName.startsWith("set")) {
                if (parameters.length == 2) {
                    if (num == 1 && className.equals("int")) {
                        return "index";
                    }
                    if (num == 2) {
                        return this.methodToParamName(methodName, 3);
                    }
                }
                if (parameters.length == 1 && num == 1) {
                    return this.methodToParamName(methodName, 3);
                }
            }
            if (methodName.startsWith("get") && parameters.length == 1 && num == 1 && className.equals("int")) {
                return "index";
            }
        }
        return this.unique(parameters, type, num, this.getNameFromClass(className));
    }

    private final String getNameFromClass(String className) {
        int i = className.lastIndexOf(46) + 1;
        if (Character.isUpperCase(className.charAt(i))) {
            if ((className = Introspector.decapitalize(className.substring(i))).endsWith(";")) {
                className = className.substring(0, className.length() - 1) + "Array";
            }
            return className;
        }
        if (className.equals("[Z")) {
            return "boolArray";
        }
        if (className.equals("[B")) {
            return "byteArray";
        }
        if (className.equals("[C")) {
            return "charArray";
        }
        if (className.equals("[S")) {
            return "shortArray";
        }
        if (className.equals("[I")) {
            return "intArray";
        }
        if (className.equals("[J")) {
            return "longArray";
        }
        if (className.equals("[F")) {
            return "floatArray";
        }
        if (className.equals("[D")) {
            return "doubleArray";
        }
        if (className.equals("boolean")) {
            return "flag";
        }
        if (className.equals("byte")) {
            return "b";
        }
        if (className.equals("char")) {
            return "c";
        }
        if (className.equals("short")) {
            return "s";
        }
        if (className.equals("int")) {
            return "n";
        }
        if (className.equals("long")) {
            return "l";
        }
        if (className.equals("float")) {
            return "f";
        }
        if (className.equals("double")) {
            return "d";
        }
        return "arg";
    }

    private final String unique(Class[] parameters, Class type, int num, String name) {
        if (parameters.length > 1) {
            int i = 0;
            int j = 0;
            while (j < num) {
                if (parameters[j] == type) {
                    ++i;
                }
                ++j;
            }
            if (i != 0) {
                name = name + i;
            }
        }
        return name;
    }

    private final String methodToParamName(String name, int strip) {
        return Introspector.decapitalize(name.substring(strip));
    }
}

