/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connectiongroup;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObject;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupModel;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupService;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.form.NumericField;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeledConnectionGroup
extends ModeledChildDirectoryObject<ConnectionGroupModel>
implements ConnectionGroup {
    private static final Logger logger = LoggerFactory.getLogger(ModeledConnectionGroup.class);
    public static final String MAX_CONNECTIONS_NAME = "max-connections";
    public static final String MAX_CONNECTIONS_PER_USER_NAME = "max-connections-per-user";
    public static final String ENABLE_SESSION_AFFINITY = "enable-session-affinity";
    public static final Form CONCURRENCY_LIMITS = new Form("concurrency", Arrays.asList(new NumericField("max-connections"), new NumericField("max-connections-per-user"), new BooleanField("enable-session-affinity", "true")));
    public static final Collection<Form> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(CONCURRENCY_LIMITS));
    public static final Set<String> ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("max-connections", "max-connections-per-user", "enable-session-affinity")));
    @Inject
    private JDBCEnvironment environment;
    @Inject
    private ConnectionGroupService connectionGroupService;
    @Inject
    private GuacamoleTunnelService tunnelService;

    public String getName() {
        return ((ConnectionGroupModel)this.getModel()).getName();
    }

    public void setName(String name) {
        ((ConnectionGroupModel)this.getModel()).setName(name);
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        return this.connectionGroupService.connect(this.getCurrentUser(), this, info, tokens);
    }

    public int getActiveConnections() {
        return this.tunnelService.getActiveConnections(this).size();
    }

    public void setType(ConnectionGroup.Type type) {
        ((ConnectionGroupModel)this.getModel()).setType(type);
    }

    public ConnectionGroup.Type getType() {
        return ((ConnectionGroupModel)this.getModel()).getType();
    }

    public Set<String> getConnectionIdentifiers() throws GuacamoleException {
        return ((ConnectionGroupModel)this.getModel()).getConnectionIdentifiers();
    }

    public Set<String> getConnectionGroupIdentifiers() throws GuacamoleException {
        return ((ConnectionGroupModel)this.getModel()).getConnectionGroupIdentifiers();
    }

    @Override
    public Set<String> getSupportedAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        attributes.put(MAX_CONNECTIONS_NAME, NumericField.format((Integer)((ConnectionGroupModel)this.getModel()).getMaxConnections()));
        attributes.put(MAX_CONNECTIONS_PER_USER_NAME, NumericField.format((Integer)((ConnectionGroupModel)this.getModel()).getMaxConnectionsPerUser()));
        attributes.put(ENABLE_SESSION_AFFINITY, ((ConnectionGroupModel)this.getModel()).isSessionAffinityEnabled() ? "true" : "");
        return attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        try {
            ((ConnectionGroupModel)this.getModel()).setMaxConnections(NumericField.parse((String)attributes.get(MAX_CONNECTIONS_NAME)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting maximum connections: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        try {
            ((ConnectionGroupModel)this.getModel()).setMaxConnectionsPerUser(NumericField.parse((String)attributes.get(MAX_CONNECTIONS_PER_USER_NAME)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting maximum connections per user: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        ((ConnectionGroupModel)this.getModel()).setSessionAffinityEnabled("true".equals(attributes.get(ENABLE_SESSION_AFFINITY)));
    }

    public int getMaxConnections() throws GuacamoleException {
        Integer value = ((ConnectionGroupModel)this.getModel()).getMaxConnections();
        if (value == null) {
            return this.environment.getDefaultMaxGroupConnections();
        }
        return value;
    }

    public int getMaxConnectionsPerUser() throws GuacamoleException {
        Integer value = ((ConnectionGroupModel)this.getModel()).getMaxConnectionsPerUser();
        if (value == null) {
            return this.environment.getDefaultMaxGroupConnectionsPerUser();
        }
        return value;
    }

    public boolean isSessionAffinityEnabled() {
        return ((ConnectionGroupModel)this.getModel()).isSessionAffinityEnabled();
    }
}

