#
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the sonic_bgp_neighbors module
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class Bgp_neighborsArgs(object):  # pylint: disable=R0903
    """The arg spec for the sonic_bgp_neighbors module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        'config': {
            'elements': 'dict',
            'options': {
                'bgp_as': {'required': True, 'type': 'str'},
                'neighbors': {
                    'elements': 'dict',
                    'options': {
                        'neighbor': {'required': True, 'type': 'str'},
                        'remote_as': {
                            'mutually_exclusive': [['peer_type', 'peer_as']],
                            'options': {
                                'peer_type': {'type': 'str', 'choices': ['internal', 'external']},
                                'peer_as': {'type': 'int'},
                            },
                            'type': 'dict'
                        },
                        'peer_group': {'type': 'str'},
                        'bfd': {'type': 'bool'},
                        'advertisement_interval': {'type': 'int'},
                        'timers': {
                            'options': {
                                'holdtime': {'type': 'int'},
                                'keepalive': {'type': 'int'},
                            },
                            'type': 'dict'
                        },
                        'capability': {
                            'options': {
                                'dynamic': {'type': 'bool'},
                                'extended_nexthop': {'type': 'bool'},
                            },
                            'type': 'dict'
                        },
                        'auth_pwd': {
                            'options': {
                                'pwd': {'type': 'str'},
                                'encrypted': {'default': 'False', 'type': 'bool'},
                            },
                            'type': 'dict'
                        },
                        'nbr_description': {'type': 'str'}
                    },
                    'type': 'list'
                },
                'peer_group': {
                    'elements': 'dict',
                    'options': {
                        'name': {'required': True, 'type': 'str'},
                        'remote_as': {
                            'mutually_exclusive': [['peer_type', 'peer_as']],
                            'options': {
                                'peer_type': {'type': 'str', 'choices': ['internal', 'external']},
                                'peer_as': {'type': 'int'},
                            },
                            'type': 'dict'
                        },
                        'address_family': {
                            'options': {
                                'afis': {
                                    'elements': 'dict',
                                    'options': {
                                        'activate': {'type': 'bool'},
                                        'afi': {
                                            'choices': ['ipv4', 'ipv6', 'l2vpn'],
                                            'type': 'str'
                                        },
                                        'allowas_in': {
                                            'mutually_exclusive': [['origin', 'value']],
                                            'options': {
                                                'origin': {'type': 'bool'},
                                                'value': {'type': 'int'}
                                            },
                                            'type': 'dict'
                                        },
                                        'safi': {
                                            'choices': ['unicast', 'evpn'],
                                            'type': 'str'
                                        },
                                    },
                                    'required_together': [['afi', 'safi']],
                                    'type': 'list'
                                },
                            },
                            'type': 'dict'
                        },
                        'bfd': {'type': 'bool'},
                        'advertisement_interval': {'type': 'int'},
                        'timers': {
                            'options': {
                                'holdtime': {'type': 'int'},
                                'keepalive': {'type': 'int'},
                            },
                            'type': 'dict'
                        },
                        'capability': {
                            'options': {
                                'dynamic': {'type': 'bool'},
                                'extended_nexthop': {'type': 'bool'},
                            },
                            'type': 'dict'
                        },
                    },
                    'type': 'list'
                },
                'vrf_name': {'default': 'default', 'type': 'str'}
            },
            'type': 'list'
        },
        'state': {
            'choices': ['merged', 'deleted'],
            'default': 'merged'
        }
    }  # pylint: disable=C0301
