#!/usr/bin/python
#
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for ios_ospfv2
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: ios_ospfv2
short_description: Resource module to configure OSPFv2.
description: This module configures and manages the Open Shortest Path First (OSPF)
  version 2 on IOS platforms.
version_added: 1.0.0
author: Sumit Jaiswal (@justjais)
notes:
  - Tested against Cisco IOSv Version 15.2 on VIRL.
  - This module works with connection C(network_cli).
    See U(https://docs.ansible.com/ansible/latest/network/user_guide/platform_ios.html)
options:
  config:
    description: A dictionary of OSPF options.
    type: dict
    suboptions:
      processes:
        description:
          - List of OSPF instance configurations.
        type: list
        elements: dict
        suboptions:
          process_id:
            description: Process ID
            required: true
            type: int
          vrf:
            description: Specify parameters for a VPN Routing/Forwarding instance
            type: str
          address_family:
            description: Router Address Family configuration mode
            type: dict
            suboptions:
              default:
                description: Set a command to its defaults
                type: bool
              snmp_context:
                description:
                  - Modify snmp parameters
                  - Configure SNMP context name
                type: str
              topology:
                description: Associate the routing protocol to a topology instance
                type: dict
                suboptions:
                  name:
                    description: Routing topology instance name
                    type: str
                  base:
                    description: Entering router topology sub mode
                    type: bool
                  tid:
                    description:
                      - Configuring the routing protocol topology tid
                      - Note, please refer vendor documentation for valid values
                    type: bool
          adjacency:
            description: To configure control adjacency formation
            type: dict
            suboptions:
              min_adjacency:
                description:
                  - Initial number of adjacencies allowed to be forming in an area
                  - Please refer vendor documentation for valid values
                type: int
              max_adjacency:
                description:
                  - Maximum number of adjacencies allowed to be forming
                  - Please refer vendor documentation for valid values
                type: int
              none:
                description: No initial
                type: bool
          areas:
            description: OSPF area parameters
            type: list
            elements: dict
            suboptions:
              area_id:
                description:
                  - OSPF area ID as a decimal value. Please refer vendor documentation
                    of Valid values.
                  - OSPF area ID in IP address format(e.g. A.B.C.D)
                type: str
              authentication:
                description: Area authentication
                type: dict
                suboptions:
                  enable:
                    description: Enable area authentication
                    type: bool
                  message_digest:
                    description: Use IPsec authentication
                    type: bool
              capability:
                description:
                  - Enable area specific capability
                  - Enable exclusion of links from base topology
                type: bool
              default_cost:
                description:
                  - Set the summary default-cost of a NSSA/stub area
                  - Stub's advertised external route metric
                  - Note, please refer vendor documentation for respective valid values
                type: int
              filter_list:
                description: Filter networks between OSPF areas
                type: list
                elements: dict
                suboptions:
                  name:
                    description: Name of an IP prefix-list
                    type: str
                  direction:
                    description: The direction to apply on the filter networks sent to and from this area.
                    type: str
                    choices: ['in', 'out']
                    required: true
              nssa:
                description: Specify a NSSA area
                type: dict
                suboptions:
                  set:
                    description: Enable a NSSA area
                    type: bool
                  default_information_originate:
                    description: Originate Type 7 default into NSSA area
                    type: dict
                    suboptions:
                      metric:
                        description: OSPF default metric
                        type: int
                      metric_type:
                        description:
                          - OSPF metric type for default routes
                          - OSPF Link State type
                        type: int
                        choices: [1, 2]
                      nssa_only:
                        description: Limit default advertisement to this NSSA area
                        type: bool
                  no_ext_capability:
                    description: Do not send domain specific capabilities into NSSA
                    type: bool
                  no_redistribution:
                    description: No redistribution into this NSSA area
                    type: bool
                  no_summary:
                    description: Do not send summary LSA into NSSA
                    type: bool
                  translate:
                    description:
                      - Translate LSA
                      - Always translate LSAs on this ABR
                      - Suppress forwarding address in translated LSAs
                    type: str
                    choices: ['always', 'suppress-fa']
              ranges:
                description: Summarize routes matching address/mask (border routers only)
                type: list
                elements: dict
                suboptions:
                  address:
                    description: IP address to match
                    type: str
                  netmask:
                    description: IP mask for address
                    type: str
                  advertise:
                    description:
                      - Advertise this range (default)
                      - Since, advertise when enabled is not shown in running-config
                        idempotency won't be maintained for the play in the second or
                        next run of the play.
                    type: bool
                  cost:
                    description: User specified metric for this range
                    type: int
                  not_advertise:
                    description: DoNotAdvertise this range
                    type: bool
              sham_link:
                description: Define a sham link and its parameters
                type: dict
                suboptions:
                  source:
                    description: IP addr associated with sham-link source (A.B.C.D)
                    type: str
                  destination:
                    description: IP addr associated with sham-link destination (A.B.C.D)
                    type: str
                  cost:
                    description:
                      - Associate a cost with the sham-link
                      - Cost of the sham-link
                      - Note, please refer vendor documentation for respective valid values
                    type: int
                  ttl_security:
                    description:
                      - TTL security check
                      - Maximum number of IP hops allowed
                    type: int
              stub:
                description:
                  - Specify a stub area
                  - Backbone can not be configured as stub area
                type: dict
                suboptions:
                  set:
                    description: Enable a stub area
                    type: bool
                  no_ext_capability:
                    description: Do not send domain specific capabilities into stub area
                    type: bool
                  no_summary:
                    description: Do not send summary LSA into stub area
                    type: bool
          auto_cost:
            description: Calculate OSPF interface cost according to bandwidth
            type: dict
            suboptions:
              set:
                description: Enable OSPF auto-cost
                type: bool
              reference_bandwidth:
                description:
                  - Use reference bandwidth method to assign OSPF cost
                  - Note, refer vendor documentation for respective valid values
                type: int
          bfd:
            description:
              - BFD configuration commands
              - Enable BFD on all interfaces
            type: bool
          capability:
            description: Enable specific OSPF feature
            type: dict
            suboptions:
              lls:
                description: Link-local Signaling (LLS) support
                type: bool
              opaque:
                description: Opaque LSA
                type: bool
              transit:
                description: Transit Area
                type: bool
              vrf_lite:
                description: Do not perform PE specific checks
                type: bool
          compatible:
            description: OSPF router compatibility list
            type: dict
            suboptions:
              rfc1583:
                description: compatible with RFC 1583
                type: bool
              rfc1587:
                description: compatible with RFC 1587
                type: bool
              rfc5243:
                description: supports DBD exchange optimization
                type: bool
          default_information:
            description: Control distribution of default information
            type: dict
            suboptions:
              originate:
                description: Distribute a default route
                type: bool
              always:
                description: Always advertise default route
                type: bool
              metric:
                description:
                  - OSPF default metric
                  - Note, refer vendor documentation for respective valid values
                type: int
              metric_type:
                description:
                  - OSPF metric type for default routes
                  - Note, please refer vendor documentation for respective valid range
                type: int
              route_map:
                description: Route-map reference name
                type: str
          default_metric:
            description: Set metric of redistributed routes
            type: int
          discard_route:
            description: Enable or disable discard-route installation
            type: dict
            suboptions:
              set:
                description: Enable discard-route installation
                type: bool
              external:
                description:
                  - Discard route for redistributed summarised routes
                  - Administrative distance for redistributed summarised routes
                  - Note, please refer vendor documentation for respective valid range
                type: int
              internal:
                description:
                  - Discard route for summarised internal routes
                  - Administrative distance for summarised internal routes
                  - Note, please refer vendor documentation for respective valid range
                type: int
          distance:
            description: Define an administrative distance
            type: dict
            suboptions:
              admin_distance:
                description: OSPF Administrative distance
                type: dict
                suboptions:
                  distance:
                    description: Administrative distance
                    type: int
                  address:
                    description: IP Source address
                    type: str
                  wildcard_bits:
                    description: Wildcard bits
                    type: str
                  acl:
                    description: Access-list name/number
                    type: str
              ospf:
                description: OSPF distance
                type: dict
                suboptions:
                  external:
                    description: External type 5 and type 7 routes
                    type: int
                  inter_area:
                    description: Inter-area routes
                    type: int
                  intra_area:
                    description: Intra-area routes
                    type: int
          distribute_list:
            description: Filter networks in routing updates
            type: dict
            suboptions:
              acls:
                description: IP access list
                type: list
                elements: dict
                suboptions:
                  name:
                    description: IP access list name/number
                    type: str
                    required: true
                  direction:
                    description: Filter incoming and outgoing routing updates.
                    type: str
                    required: true
                    choices: ['in', 'out']
                  interface:
                    description:
                      - Interface configuration (GigabitEthernet A/B)
                      - Valid with incoming traffic
                    type: str
                  protocol:
                    description:
                      - Protocol config (bgp 1).
                      - Valid with outgoing traffic
                    type: str
              prefix:
                description: Filter prefixes in routing updates
                type: dict
                suboptions:
                  name:
                    description: Name of an IP prefix-list
                    type: str
                    required: true
                  gateway_name:
                    description: Gateway name for filtering incoming updates based on gateway
                    type: str
                  direction:
                    description: Filter incoming and outgoing routing updates.
                    type: str
                    required: true
                    choices: ['in', 'out']
                  interface:
                    description:
                      - Interface configuration (GigabitEthernet A/B)
                      - Valid with incoming traffic
                    type: str
                  protocol:
                    description:
                      - Protocol config (bgp 1).
                      - Valid with outgoing traffic
                    type: str
              route_map:
                description: Filter prefixes in routing updates
                type: dict
                suboptions:
                  name:
                    description: Route-map name
                    type: str
                    required: true
          domain_id:
            description: OSPF domain-id
            type: dict
            suboptions:
              ip_address:
                description: IP address
                type: dict
                suboptions:
                  address:
                    description: OSPF domain ID in IP address format
                    type: str
                  secondary:
                    description: Secondary Domain-ID
                    type: bool
              'null':
                description: Null Domain-ID
                type: bool
          domain_tag:
            description:
              - OSPF domain-tag which is OSPF domain tag - 32-bit value
              - Note, please refer vendor documentation for respective valid range
            type: int
          event_log:
            description: Event Logging
            type: dict
            suboptions:
              enable:
                description: Enable event Logging
                type: bool
              one_shot:
                description: Disable Logging When Log Buffer Becomes Full
                type: bool
              pause:
                description: Pause Event Logging
                type: bool
              size:
                description:
                  - Maximum Number of Events Stored in the Event Log
                  - Note, refer vendor documentation for respective valid values
                type: int
          help:
            description: Description of the interactive help system
            type: bool
          ignore:
            description:
              - Do not complain about specific event
              - Do not complain upon receiving LSA of the specified type, MOSPF Type 6 LSA
            type: bool
          interface_id:
            description:
              - Source of the interface ID
              - SNMP MIB ifIndex
            type: bool
          ispf:
            description: Enable incremental SPF computation
            type: bool
          limit:
            description: Limit a specific OSPF feature and LS update, DBD, and LS request retransmissions
            type: dict
            suboptions:
              dc:
                description: Demand circuit retransmissions
                type: dict
                suboptions:
                  number:
                    description: The maximum number of retransmissions
                    type: int
                  disable:
                    description: Disble the feature
                    type: bool
              non_dc:
                description: Non-demand-circuit retransmissions
                type: dict
                suboptions:
                  number:
                    description: The maximum number of retransmissions
                    type: int
                  disable:
                    description: Disble the feature
                    type: bool
          local_rib_criteria:
            description: Enable or disable usage of local RIB as route criteria
            type: dict
            suboptions:
              enable:
                description: Enable usage of local RIB as route criteria
                type: bool
              forwarding_address:
                description: Local RIB used to validate external/NSSA forwarding addresses
                type: bool
              inter_area_summary:
                description: Local RIB used as criteria for inter-area summaries
                type: bool
              nssa_translation:
                description: Local RIB used as criteria for NSSA translation
                type: bool
          log_adjacency_changes:
            description: Log changes in adjacency state
            type: dict
            suboptions:
              set:
                description: Log changes in adjacency state
                type: bool
              detail:
                description: Log all state changes
                type: bool
          max_lsa:
            description: Maximum number of non self-generated LSAs to accept
            type: dict
            suboptions:
              number:
                description:
                  - Maximum number of non self-generated LSAs to accept
                  - Note, refer vendor documentation for respective valid values
                type: int
              threshold_value:
                description:
                  - Threshold value (%) at which to generate a warning msg
                  - Note, refer vendor documentation for respective valid values
                type: int
              ignore_count:
                description:
                  - Maximum number of times adjacencies can be suppressed
                  - Note, refer vendor documentation for respective valid values
                type: int
              ignore_time:
                description:
                  - Number of minutes during which all adjacencies are suppressed
                  - Note, refer vendor documentation for respective valid values
                type: int
              reset_time:
                description:
                  - Number of minutes after which ignore-count is reset to zero
                  - Note, refer vendor documentation for respective valid values
                type: int
              warning_only:
                description: Only give a warning message when limit is exceeded
                type: bool
          max_metric:
            description: Set maximum metric
            type: dict
            suboptions:
              router_lsa:
                description: Maximum metric in self-originated router-LSAs
                type: bool
                required: true
              external_lsa:
                description:
                  - Override external-lsa metric with max-metric value
                  - Overriding metric in external-LSAs
                  - Note, refer vendor documentation for respective valid values
                type: int
              include_stub:
                description: Set maximum metric for stub links in router-LSAs
                type: bool
              on_startup:
                description: Set maximum metric temporarily after reboot
                type: dict
                suboptions:
                  time:
                    description:
                      - Time, in seconds, router-LSAs are originated with max-metric
                      - Note, please refer vendor documentation for respective valid range
                    type: int
                  wait_for_bgp:
                    description: Let BGP decide when to originate router-LSA with normal metric
                    type: bool
              summary_lsa:
                description:
                  - Override summary-lsa metric with max-metric value
                  - Note, please refer vendor documentation for respective valid range
                type: int
          maximum_paths:
            description:
              - Forward packets over multiple paths
              - Number of paths
            type: int
          mpls:
            description: Configure MPLS routing protocol parameters
            type: dict
            suboptions:
              ldp:
                description: routing protocol commands for MPLS LDP
                type: dict
                suboptions:
                  autoconfig:
                    description: routing protocol commands for MPLS LDP
                    type: dict
                    suboptions:
                      set:
                        description: Configure LDP automatic configuration and set the config
                        type: bool
                      area:
                        description: Configure an OSPF area to run MPLS LDP
                        type: str
                  sync:
                    description: Configure LDP-IGP Synchronization
                    type: bool
              traffic_eng:
                description: Let BGP decide when to originate router-LSA with normal metric
                type: dict
                suboptions:
                  area:
                    description:
                      - Configure an ospf area to run MPLS Traffic Engineering
                      - OSPF area ID as a decimal value or in IP address format
                    type: str
                  autoroute_exclude:
                    description:
                      - MPLS TE autoroute exclude
                      - Filter prefixes based on name of an IP prefix-list
                    type: str
                  interface:
                    description: MPLS TE interface configuration for this OSPF process
                    type: dict
                    suboptions:
                      interface_type:
                        description: TE Interface configuration (GigabitEthernet A/B)
                        type: str
                      area:
                        description:
                          - Advertise MPLS TE information for this interface into area
                          - OSPF area ID as a decimal value
                        type: int
                  mesh_group:
                    description: Traffic Engineering Mesh-Group advertisement
                    type: dict
                    suboptions:
                      id:
                        description: Mesh Group Id
                        type: int
                      interface:
                        description: Interface configuration (GigabitEthernet A/B)
                        type: str
                      area:
                        description: configure flooding scope as area
                        type: str
                  multicast_intact:
                    description: MPLS TE and PIM interaction
                    type: bool
                  router_id_interface:
                    description: Router Interface configuration (GigabitEthernet A/B)
                    type: str
          neighbor:
            description: Specify a neighbor router
            type: dict
            suboptions:
              address:
                description: Neighbor address (A.B.C.D)
                type: str
              cost:
                description:
                  - OSPF cost for point-to-multipoint neighbor metric
                  - Note, please refer vendor documentation for respective valid range
                type: int
              database_filter:
                description:
                  - Filter OSPF LSA during synchronization and flooding for point-to-multipoint neighbor
                  - Filter all outgoing LSA
                type: bool
              poll_interval:
                description: OSPF dead-router polling interval of non-broadcast neighbor in Seconds
                type: int
              priority:
                description: OSPF priority of non-broadcast neighbor priority
                type: int
          network:
            description: Enable routing on an IP network
            type: list
            elements: dict
            suboptions:
              address:
                description: Network number
                type: str
              wildcard_bits:
                description: OSPF wild card bits
                type: str
              area:
                description: Set the OSPF area ID
                type: str
          nsf:
            description: Non-stop forwarding
            type: dict
            suboptions:
              cisco:
                description: Cisco Non-stop forwarding
                type: dict
                suboptions:
                  helper:
                    description: helper support
                    type: bool
                  disable:
                    description: disable helper support
                    type: bool
              ietf:
                description: IETF graceful restart
                type: dict
                suboptions:
                  helper:
                    description: helper support
                    type: bool
                  disable:
                    description: disable helper support
                    type: bool
                  strict_lsa_checking:
                    description: enable helper strict LSA checking
                    type: bool
          passive_interface:
            description:
              - passive_interface param is deprecated and a newer param passive_interfaces
                with added functionality's is introduced, please meke use of the new available
                passive_interfaces instead.
              - Suppress routing updates on an interface (GigabitEthernet A/B)
              - Interface name with respective interface number
            type: str
          passive_interfaces:
            description: Suppress routing updates on an interface
            type: dict
            suboptions:
              default:
                description: Suppress routing updates on all interfaces
                type: bool
              interface:
                description: Suppress/Un-Suppress routing updates on interface
                type: dict
                suboptions:
                  set_interface:
                    description: Suppress/Un-Suppress routing updates
                    type: bool
                  name:
                    description: Name of interface (GigabitEthernet A/B)
                    type: list
                    elements: str
          prefix_suppression:
            description: Enable prefix suppression
            type: bool
          priority:
            description:
              - OSPF topology priority
              - Note, refer vendor documentation for respective valid values
            type: int
          queue_depth:
            description: Hello/Router process queue depth
            type: dict
            suboptions:
              hello:
                description: OSPF Hello process queue depth
                type: dict
                suboptions:
                  max_packets:
                    description: maximum number of packets in the queue
                    type: int
                  unlimited:
                    description: Unlimited queue depth
                    type: bool
              update:
                description: OSPF Router process queue depth
                type: dict
                suboptions:
                  max_packets:
                    description: maximum number of packets in the queue
                    type: int
                  unlimited:
                    description: Unlimited queue depth
                    type: bool
          router_id:
            description:
              - Router-id address for this OSPF process
              - OSPF router-id in IP address format (A.B.C.D)
            type: str
          shutdown:
            description: Shutdown the router process
            type: bool
          summary_address:
            description: Configure IP address summaries
            type: dict
            suboptions:
              address:
                description: IP summary address
                type: str
              mask:
                description: IP Summary mask
                type: str
              not_advertise:
                description: Do not advertise or translate
                type: bool
              nssa_only:
                description: Limit summary to NSSA areas
                type: bool
              tag:
                description: Set tag
                type: int
          timers:
            description: Adjust routing timers
            type: dict
            suboptions:
              lsa:
                description:
                  - OSPF LSA timers, arrival timer
                  - The minimum interval in milliseconds between accepting the same LSA
                  - Note, refer vendor documentation for respective valid values
                type: int
              pacing:
                description: OSPF pacing timers
                type: dict
                suboptions:
                  flood:
                    description:
                      - OSPF flood pacing timer
                      - The minimum interval in msec to pace limit flooding on interface
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  lsa_group:
                    description:
                      - OSPF LSA group pacing timer
                      - Interval in sec between group of LSA being refreshed or maxaged
                      - Note, refer vendor documentation for respective valid values
                    type: int
                  retransmission:
                    description:
                      - OSPF retransmission pacing timer
                      - The minimum interval in msec between neighbor retransmissions
                      - Note, refer vendor documentation for respective valid values
                    type: int
              throttle:
                description: OSPF throttle timers
                type: dict
                suboptions:
                  lsa:
                    description: OSPF LSA throttle timers
                    type: dict
                    suboptions:
                      first_delay:
                        description:
                          - Delay to generate first occurrence of LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      min_delay:
                        description:
                          - Minimum delay between originating the same LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      max_delay:
                        description:
                          - Maximum delay between originating the same LSA in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                  spf:
                    description: OSPF SPF throttle timers
                      - Delay between receiving a change to SPF calculation in milliseconds
                      - Note, refer vendor documentation for respective valid values
                    type: dict
                    suboptions:
                      receive_delay:
                        description:
                          - Delay between receiving a change to SPF calculation in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      between_delay:
                        description:
                          - Delay between first and second SPF calculation in milliseconds
                          - Note, refer vendor documentation for respective valid values
                        type: int
                      max_delay:
                        description:
                          - Maximum wait time in milliseconds for SPF calculations
                          - Note, refer vendor documentation for respective valid values
                        type: int
          traffic_share:
            description:
              - How to compute traffic share over alternate paths
              - All traffic shared among min metric paths
              - Use different interfaces for equal-cost paths
            type: bool
          ttl_security:
            description: TTL security check
            type: dict
            suboptions:
              set:
                description: Enable TTL Security on all interfaces
                type: bool
              hops:
                description:
                  - Maximum number of IP hops allowed
                  - Note, refer vendor documentation for respective valid values
                type: int
  running_config:
    description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the IOS
        device by executing the command B(sh running-config | section ^router ospf).
      - The state I(parsed) reads the configuration from C(running_config)
        option and transforms it into Ansible structured data as per the
        resource module's argspec and the value is then returned in the
        I(parsed) key within the result.
    type: str
  state:
    description:
      - The state the configuration should be left in
      - The states I(rendered), I(gathered) and I(parsed) does not perform any change
        on the device.
      - The state I(rendered) will transform the configuration in C(config) option to
        platform specific CLI commands which will be returned in the I(rendered) key
        within the result. For state I(rendered) active connection to remote host is
        not required.
      - The state I(gathered) will fetch the running configuration from device and transform
        it into structured data in the format as per the resource module argspec and
        the value is returned in the I(gathered) key within the result.
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into JSON format as per the resource module parameters and the
        value is returned in the I(parsed) key within the result. The value of C(running_config)
        option should be the same format as the output of command I(show running-config
        | include ip route|ipv6 route) executed on device. For state I(parsed) active
        connection to remote host is not required.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - parsed
    - rendered
    default: merged

"""
EXAMPLES = """

# Using deleted

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

- name: Delete provided OSPF V2 processes
  cisco.ios.ios_ospfv2:
    config:
      processes:
      - process_id: 1
      - process_id: 200
        vrf: blue
    state: deleted

# Commands Fired:
# ---------------
#
# "commands": [
#        "no router ospf 1"
#    ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in

# Using deleted without any config passed (NOTE: This will delete all OSPFV2 configuration from device)

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

- name: Delete all OSPF processes
  cisco.ios.ios_ospfv2:
    state: deleted

# Commands Fired:
# ---------------
#
# "commands": [
#        "no router ospf 200 vrf blue",
#        "no router ospf 1"
#    ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospf
# router-ios#

# Using merged

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router-ios#

- name: Merge provided OSPF V2 configuration
  cisco.ios.ios_ospfv2:
    config:
      processes:
      - process_id: 1
        max_metric:
          router_lsa: true
          on_startup:
            time: 110
        areas:
        - area_id: '5'
          capability: true
          authentication:
            enable: true
        - area_id: '10'
          authentication:
            message_digest: true
          nssa:
            default_information_originate:
              metric: 10
            translate: suppress-fa
          default_cost: 10
          filter_list:
          - name: test_prefix_in
            direction: in
          - name: test_prefix_out
            direction: out
        network:
          address: 198.51.100.0
          wildcard_bits: 0.0.0.255
          area: 5
        default_information:
          originate: true
        passive_interfaces:
          default: true
          interface:
            set_interface: False
            name:
              - GigabitEthernet0/1
              - GigabitEthernet0/2
      - process_id: 200
        vrf: blue
        domain_id:
          ip_address:
            address: 192.0.3.1
        max_metric:
          router_lsa: true
          on_startup:
            time: 100
        auto_cost:
          reference_bandwidth: 4
        areas:
        - area_id: '10'
          capability: true
        distribute_list:
          acls:
          - name: 10
            direction: out
          - name: 123
            direction: in
    state: merged

# Commands Fired:
# ---------------
#
#  "commands": [
#         "router ospf 200 vrf blue",
#         "auto-cost reference-bandwidth 4",
#         "distribute-list 10 out",
#         "distribute-list 123 in",
#         "domain-id 192.0.3.1",
#         "max-metric router-lsa on-startup 100",
#         "area 10 capability default-exclusion",
#         "router ospf 1",
#         "default-information originate",
#         "max-metric router-lsa on-startup 110",
#         "network 198.51.100.0 0.0.0.255 area 5",
#         "area 10 authentication message-digest",
#         "area 10 default-cost 10",
#         "area 10 nssa translate type7 suppress-fa",
#         "area 10 nssa default-information-originate metric 10",
#         "area 10 filter-list prefix test_prefix_out out",
#         "area 10 filter-list prefix test_prefix_in in",
#         "area 5 authentication",
#         "area 5 capability default-exclusion"
#         "passive-interface default"
#         "no passive-interface GigabitEthernet0/1"
#     ]

# After state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate
#  passive-interface default
#  no passive-interface GigabitEthernet0/1
#  no passive-interface GigabitEthernet0/2

# Using overridden

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

- name: Override provided OSPF V2 configuration
  cisco.ios.ios_ospfv2:
    config:
      processes:
      - process_id: 200
        vrf: blue
        domain_id:
          ip_address:
            address: 192.0.4.1
        max_metric:
          router_lsa: true
          on_startup:
            time: 200
        maximum_paths: 15
        ttl_security:
          hops: 7
        areas:
        - area_id: '10'
          default_cost: 10
          authentication:
            message_digest: true
      - process_id: 100
        vrf: ospf_vrf
        domain_id:
          ip_address:
            address: 192.0.5.1
        auto_cost:
          reference_bandwidth: 5
        areas:
        - area_id: '5'
          authentication:
            message_digest: true
          nssa:
            default_information_originate:
              metric: 10
            translate: suppress-fa
    state: overridden

# Commands Fired:
# ---------------
#
# "commands": [
#         "no router ospf 1",
#         "router ospf 100 vrf ospf_vrf",
#         "auto-cost reference-bandwidth 5",
#         "domain-id 192.0.5.1",
#         "area 5 authentication message-digest",
#         "area 5 nssa translate type7 suppress-fa",
#         "area 5 nssa default-information-originate metric 10",
#         "router ospf 200 vrf blue",
#         "no auto-cost reference-bandwidth 4",
#         "no distribute-list 10 out",
#         "no distribute-list 123 in",
#         "domain-id 192.0.4.1",
#         "max-metric router-lsa on-startup 200",
#         "maximum-paths 15",
#         "ttl-security all-interfaces hops 7",
#         "area 10 authentication message-digest",
#         "no area 10 capability default-exclusion",
#         "area 10 default-cost 10"
#     ]

# After state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.4.1
#  max-metric router-lsa on-startup 200
#  ttl-security all-interfaces hops 7
#  area 10 authentication message-digest
#  area 10 default-cost 10
#  maximum-paths 15
# router ospf 100 vrf ospf_vrf
#  domain-id 192.0.5.1
#  auto-cost reference-bandwidth 5
#  area 5 authentication message-digest
#  area 5 nssa default-information-originate metric 10
#  area 5 nssa translate type7 suppress-fa

# Using replaced

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

- name: Replaced provided OSPF V2 configuration
  cisco.ios.ios_ospfv2:
    config:
      processes:
      - process_id: 200
        vrf: blue
        domain_id:
          ip_address:
            address: 192.0.4.1
        max_metric:
          router_lsa: true
          on_startup:
            time: 200
        maximum_paths: 15
        ttl_security:
          hops: 7
        areas:
        - area_id: '10'
          default_cost: 10
          authentication:
            message_digest: true
      - process_id: 100
        vrf: ospf_vrf
        domain_id:
          ip_address:
            address: 192.0.5.1
        auto_cost:
          reference_bandwidth: 5
        areas:
        - area_id: '5'
          authentication:
            message_digest: true
          nssa:
            default_information_originate:
              metric: 10
            translate: suppress-fa
    state: replaced

# Commands Fired:
# ---------------
# "commands": [
#         "router ospf 100 vrf ospf_vrf",
#         "auto-cost reference-bandwidth 5",
#         "domain-id 192.0.5.1",
#         "area 5 authentication message-digest",
#         "area 5 nssa translate type7 suppress-fa",
#         "area 5 nssa default-information-originate metric 10",
#         "router ospf 200 vrf blue",
#         "no auto-cost reference-bandwidth 4",
#         "no distribute-list 10 out",
#         "no distribute-list 123 in",
#         "domain-id 192.0.4.1",
#         "max-metric router-lsa on-startup 200",
#         "maximum-paths 15",
#         "ttl-security all-interfaces hops 7",
#         "area 10 authentication message-digest",
#         "no area 10 capability default-exclusion",
#         "area 10 default-cost 10"
#     ]

# After state:
# -------------
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.4.1
#  max-metric router-lsa on-startup 200
#  ttl-security all-interfaces hops 7
#  area 10 authentication message-digest
#  area 10 default-cost 10
#  maximum-paths 15
# router ospf 100 vrf ospf_vrf
#  domain-id 192.0.5.1
#  auto-cost reference-bandwidth 5
#  area 5 authentication message-digest
#  area 5 nssa default-information-originate metric 10
#  area 5 nssa translate type7 suppress-fa
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 5 capability default-exclusion
#  area 5 authentication
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_in in
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

# Using Gathered

# Before state:
# -------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

- name: Gather OSPFV2 provided configurations
  cisco.ios.ios_ospfv2:
    config:
    state: gathered

# Module Execution Result:
# ------------------------
#
# "gathered": {
#         "processes": [
#             {
#                 "areas": [
#                     {
#                         "area_id": "5",
#                         "authentication": {
#                             "enable": true
#                         },
#                         "capability": true
#                     },
#                     {
#                         "area_id": "10",
#                         "authentication": {
#                             "message_digest": true
#                         },
#                         "default_cost": 10,
#                         "filter_list": [
#                             {
#                                 "direction": "in",
#                                 "name": "test_prefix_in"
#                             },
#                             {
#                                 "direction": "out",
#                                 "name": "test_prefix_out"
#                             }
#                         ],
#                         "nssa": {
#                             "default_information_originate": {
#                                 "metric": 10
#                             },
#                             "translate": "suppress-fa"
#                         }
#                     }
#                 ],
#                 "default_information": {
#                     "originate": true
#                 },
#                 "max_metric": {
#                     "on_startup": {
#                         "time": 110
#                     },
#                     "router_lsa": true
#                 },
#                 "network": {
#                     "address": "198.51.100.0",
#                     "area": "5",
#                     "wildcard_bits": "0.0.0.255"
#                 },
#                 "process_id": 1
#             },
#             {
#                 "areas": [
#                     {
#                         "area_id": "10",
#                         "capability": true
#                     }
#                 ],
#                 "auto_cost": {
#                     "reference_bandwidth": 4
#                 },
#                 "distribute_list": {
#                     "acls": [
#                         {
#                             "direction": "out",
#                             "name": "10"
#                         },
#                         {
#                             "direction": "in",
#                             "name": "123"
#                         }
#                     ]
#                 },
#                 "domain_id": {
#                     "ip_address": {
#                         "address": "192.0.3.1"
#                     }
#                 },
#                 "max_metric": {
#                     "on_startup": {
#                         "time": 100
#                     },
#                     "router_lsa": true
#                 },
#                 "process_id": 200,
#                 "vrf": "blue"
#             }
#         ]
#      }

# After state:
# ------------
#
# router-ios#sh running-config | section ^router ospf
# router ospf 200 vrf blue
#  domain-id 192.0.3.1
#  max-metric router-lsa on-startup 100
#  auto-cost reference-bandwidth 4
#  area 10 capability default-exclusion
#  distribute-list 10 out
#  distribute-list 123 in
# router ospf 1
#  max-metric router-lsa on-startup 110
#  area 10 authentication message-digest
#  area 10 nssa default-information-originate metric 10
#  area 10 nssa translate type7 suppress-fa
#  area 10 default-cost 10
#  area 10 filter-list prefix test_prefix_out out
#  network 198.51.100.0 0.0.0.255 area 5
#  default-information originate

# Using Rendered

- name: Render the commands for provided  configuration
  cisco.ios.ios_ospfv2:
    config:
      processes:
      - process_id: 1
        max_metric:
          router_lsa: true
          on_startup:
            time: 110
        areas:
        - area_id: '5'
          capability: true
          authentication:
            enable: true
        - area_id: '10'
          authentication:
            message_digest: true
          nssa:
            default_information_originate:
              metric: 10
            translate: suppress-fa
          default_cost: 10
          filter_list:
          - name: test_prefix_in
            direction: in
          - name: test_prefix_out
            direction: out
        network:
          address: 198.51.100.0
          wildcard_bits: 0.0.0.255
          area: 5
        default_information:
          originate: true
      - process_id: 200
        vrf: blue
        domain_id:
          ip_address:
            address: 192.0.3.1
        max_metric:
          router_lsa: true
          on_startup:
            time: 100
        auto_cost:
          reference_bandwidth: 4
        areas:
        - area_id: '10'
          capability: true
        distribute_list:
          acls:
          - name: 10
            direction: out
          - name: 123
            direction: in
    state: rendered

# Module Execution Result:
# ------------------------
#
# "rendered": [
#         "router ospf 200 vrf blue",
#         "auto-cost reference-bandwidth 4",
#         "distribute-list 10 out",
#         "distribute-list 123 in",
#         "domain-id 192.0.3.1",
#         "max-metric router-lsa on-startup 100",
#         "area 10 capability default-exclusion",
#         "router ospf 1",
#         "default-information originate",
#         "max-metric router-lsa on-startup 110",
#         "network 198.51.100.0 0.0.0.255 area 5",
#         "area 10 authentication message-digest",
#         "area 10 default-cost 10",
#         "area 10 nssa translate type7 suppress-fa",
#         "area 10 nssa default-information-originate metric 10",
#         "area 10 filter-list prefix test_prefix_out out",
#         "area 10 filter-list prefix test_prefix_in in",
#         "area 5 authentication",
#         "area 5 capability default-exclusion"
#     ]

# Using Parsed

# File: parsed.cfg
# ----------------
#
# router ospf 100
#  auto-cost reference-bandwidth 5
#  domain-id 192.0.5.1
#  area 5 authentication message-digest
#  area 5 nssa translate type7 suppress-fa
#  area 5 nssa default-information-originate metric 10

- name: Parse the provided configuration with the existing running configuration
  cisco.ios.ios_ospfv2:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Module Execution Result:
# ------------------------
#
# "parsed": {
#         "processes": [
#             {
#                 "areas": [
#                     {
#                         "area_id": "5",
#                         "authentication": {
#                             "message_digest": true
#                         },
#                         "nssa": {
#                             "default_information_originate": {
#                                 "metric": 10
#                             },
#                             "translate": "suppress-fa"
#                         }
#                     }
#                 ],
#                 "auto_cost": {
#                     "reference_bandwidth": 5
#                 },
#                 "domain_id": {
#                     "ip_address": {
#                         "address": "192.0.5.1"
#                     }
#                 },
#                 "process_id": 100
#             }
#         ]
#     }

"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['router ospf 200 vrf blue', 'auto-cost reference-bandwidth 5', 'domain-id 192.0.4.1']
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.cisco.ios.plugins.module_utils.network.ios.argspec.ospfv2.ospfv2 import (
    Ospfv2Args,
)
from ansible_collections.cisco.ios.plugins.module_utils.network.ios.config.ospfv2.ospfv2 import (
    Ospfv2,
)


def main():
    """
    Main entry point for module execution
    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Ospfv2Args.argument_spec,
        required_if=required_if,
        mutually_exclusive=mutually_exclusive,
        supports_check_mode=True,
    )

    result = Ospfv2(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
