/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class CodeLinesInfo {
    private final NavigableMap<Integer, JavaNode> map = new TreeMap<Integer, JavaNode>();

    public CodeLinesInfo(JavaClass cls) {
        this.addClass(cls);
    }

    public void addClass(JavaClass cls) {
        this.map.put(cls.getDecompiledLine(), (JavaNode)cls);
        for (JavaClass innerCls : cls.getInnerClasses()) {
            this.map.put(innerCls.getDecompiledLine(), (JavaNode)innerCls);
            this.addClass(innerCls);
        }
        for (JavaMethod mth : cls.getMethods()) {
            this.map.put(mth.getDecompiledLine(), (JavaNode)mth);
        }
    }

    public JavaNode getJavaNodeByLine(int line) {
        Map.Entry<Integer, JavaNode> entry = this.map.floorEntry(line);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }
}

