"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@popperjs/core");
var react_1 = require("react");
var react_dom_1 = require("react-dom");
var commons_1 = require("../../utils/commons");
var utils_1 = require("./utils");
var TooltipPortalComponent = function (_a) {
    var anchor = _a.anchor, scope = _a.scope, settings = _a.settings, children = _a.children, visible = _a.visible, chartId = _a.chartId;
    var _b, _c, _d, _e, _f, _g, _h;
    var anchorNode = react_1.useRef(utils_1.isHTMLElement(anchor)
        ? anchor
        : utils_1.getOrCreateNode("echAnchor" + scope + "__" + chartId, undefined, (_c = (_b = anchor) === null || _b === void 0 ? void 0 : _b.ref, (_c !== null && _c !== void 0 ? _c : undefined))));
    var portalNodeElement = utils_1.getOrCreateNode("echTooltipPortal" + scope + "__" + chartId, 'echTooltipPortal__invisible');
    var portalNode = react_1.useRef(portalNodeElement);
    var popper = react_1.useRef(null);
    var popperSettings = react_1.useMemo(function () { return commons_1.mergePartial(utils_1.DEFAULT_POPPER_SETTINGS, settings, { mergeOptionalPartialValues: true }); }, [settings]);
    var anchorPosition = (_d = anchor) === null || _d === void 0 ? void 0 : _d.position;
    var position = react_1.useMemo(function () { return (utils_1.isHTMLElement(anchor) ? null : anchorPosition); }, [anchor, anchorPosition]);
    var destroyPopper = react_1.useCallback(function () {
        if (popper.current) {
            popper.current.destroy();
            popper.current = null;
        }
    }, []);
    var setPopper = react_1.useCallback(function () {
        if (!commons_1.isDefined(anchorNode.current) || !visible) {
            return;
        }
        var fallbackPlacements = popperSettings.fallbackPlacements, placement = popperSettings.placement, boundary = popperSettings.boundary, offset = popperSettings.offset;
        popper.current = core_1.createPopper(anchorNode.current, portalNode.current, {
            strategy: 'absolute',
            placement: placement,
            modifiers: [
                {
                    name: 'offset',
                    options: {
                        offset: [0, offset],
                    },
                },
                {
                    name: 'preventOverflow',
                    options: {
                        boundary: boundary,
                    },
                },
                {
                    name: 'flip',
                    options: {
                        fallbackPlacements: fallbackPlacements.filter(function (p) { return p !== placement; }),
                        boundary: boundary,
                        altAxis: false,
                        padding: offset || 10,
                    },
                },
            ],
        });
    }, [
        visible,
        popperSettings.fallbackPlacements,
        popperSettings.placement,
        popperSettings.boundary,
        popperSettings.offset,
    ]);
    react_1.useEffect(function () {
        setPopper();
        var nodeCopy = portalNode.current;
        return function () {
            if (nodeCopy.parentNode) {
                nodeCopy.parentNode.removeChild(nodeCopy);
            }
            destroyPopper();
        };
    }, []);
    react_1.useEffect(function () {
        destroyPopper();
        setPopper();
    }, [destroyPopper, setPopper, popperSettings]);
    react_1.useEffect(function () {
        if (!visible) {
            destroyPopper();
        }
        else if (!popper.current) {
            setPopper();
        }
    }, [destroyPopper, setPopper, visible]);
    var updateAnchorDimensions = react_1.useCallback(function () {
        if (!position || !visible) {
            return;
        }
        var left = position.left, top = position.top, width = position.width, height = position.height;
        anchorNode.current.style.left = left + "px";
        anchorNode.current.style.top = top + "px";
        if (commons_1.isDefined(width)) {
            anchorNode.current.style.width = width + "px";
        }
        if (commons_1.isDefined(height)) {
            anchorNode.current.style.height = height + "px";
        }
    }, [visible, anchorNode, (_e = position) === null || _e === void 0 ? void 0 : _e.left, (_f = position) === null || _f === void 0 ? void 0 : _f.top, (_g = position) === null || _g === void 0 ? void 0 : _g.width, (_h = position) === null || _h === void 0 ? void 0 : _h.height]);
    react_1.useEffect(function () {
        if (!position) {
            portalNode.current.classList.add('echTooltipPortal__invisible');
            return;
        }
        portalNode.current.classList.remove('echTooltipPortal__invisible');
    }, [position]);
    react_1.useEffect(function () {
        if (popper.current) {
            updateAnchorDimensions();
            void popper.current.update();
        }
    }, [updateAnchorDimensions, popper]);
    return react_dom_1.createPortal(children, portalNode.current);
};
TooltipPortalComponent.displayName = 'TooltipPortal';
exports.TooltipPortal = TooltipPortalComponent;
//# sourceMappingURL=tooltip_portal.js.map