"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var accessor_1 = require("../../../utils/accessor");
var commons_1 = require("../../../utils/commons");
var geometry_1 = require("../../../utils/geometry");
var axis_utils_1 = require("../utils/axis_utils");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
exports.Y0_ACCESSOR_POSTFIX = ' - lower';
exports.Y1_ACCESSOR_POSTFIX = ' - upper';
function getHighligthedValues(tooltipValues, defaultValue) {
    var seriesTooltipValues = new Map();
    tooltipValues.forEach(function (_a) {
        var formattedValue = _a.formattedValue, seriesIdentifier = _a.seriesIdentifier, valueAccessor = _a.valueAccessor;
        var _b;
        var seriesValue = defaultValue || formattedValue;
        var current = (_b = seriesTooltipValues.get(seriesIdentifier.key), (_b !== null && _b !== void 0 ? _b : new Map()));
        if (defaultValue) {
            if (!current.has(geometry_1.BandedAccessorType.Y0)) {
                current.set(geometry_1.BandedAccessorType.Y0, defaultValue);
            }
            if (!current.has(geometry_1.BandedAccessorType.Y1)) {
                current.set(geometry_1.BandedAccessorType.Y1, defaultValue);
            }
        }
        if (valueAccessor != null && (valueAccessor === geometry_1.BandedAccessorType.Y0 || valueAccessor === geometry_1.BandedAccessorType.Y1)) {
            current.set(valueAccessor, seriesValue);
        }
        seriesTooltipValues.set(seriesIdentifier.key, current);
    });
    return seriesTooltipValues;
}
exports.getHighligthedValues = getHighligthedValues;
function formatTooltip(_a, spec, isHeader, isHighlighted, hasSingleSeries, axisSpec) {
    var color = _a.color, _b = _a.value, x = _b.x, y = _b.y, mark = _b.mark, accessor = _b.accessor, seriesIdentifier = _a.seriesIdentifier;
    var _c, _d, _e, _f;
    var label = series_1.getSeriesName(seriesIdentifier, hasSingleSeries, true, spec);
    if (specs_1.isBandedSpec(spec.y0Accessors) && (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec))) {
        var _g = spec.y0AccessorFormat, y0AccessorFormat = _g === void 0 ? exports.Y0_ACCESSOR_POSTFIX : _g, _h = spec.y1AccessorFormat, y1AccessorFormat = _h === void 0 ? exports.Y1_ACCESSOR_POSTFIX : _h;
        var formatter = accessor === geometry_1.BandedAccessorType.Y0 ? y0AccessorFormat : y1AccessorFormat;
        label = accessor_1.getAccessorFormatLabel(formatter, label);
    }
    var isFiltered = spec.filterSeriesInTooltip !== undefined ? spec.filterSeriesInTooltip(seriesIdentifier) : true;
    var isVisible = label === '' ? false : isFiltered;
    var value = isHeader ? x : y;
    var markValue = isHeader || mark === null ? null : mark;
    var tickFormatOptions = spec.timeZone ? { timeZone: spec.timeZone } : undefined;
    var tickFormatter = (_f = (isHeader ? (_c = axisSpec) === null || _c === void 0 ? void 0 : _c.tickFormat : (_d = spec.tickFormat, (_d !== null && _d !== void 0 ? _d : (_e = axisSpec) === null || _e === void 0 ? void 0 : _e.tickFormat))), (_f !== null && _f !== void 0 ? _f : axis_utils_1.defaultTickFormatter));
    return __assign(__assign({ seriesIdentifier: seriesIdentifier, valueAccessor: accessor, label: label,
        value: value, formattedValue: tickFormatter(value, tickFormatOptions), markValue: markValue }, (commons_1.isDefined(markValue) && {
        formattedMarkValue: spec.markFormat
            ? spec.markFormat(markValue, tickFormatOptions)
            : axis_utils_1.defaultTickFormatter(markValue),
    })), { color: color, isHighlighted: isHeader ? false : isHighlighted, isVisible: isVisible });
}
exports.formatTooltip = formatTooltip;
//# sourceMappingURL=tooltip.js.map