"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../utils/commons");
var config_1 = require("../../layout/config/config");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
var measure_1 = require("../../layout/utils/measure");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
function rawTextGetter(layers) {
    return function (node) {
        var accessorFn = layers[node[group_by_rollup_1.DEPTH_KEY] - 1].nodeLabel || commons_1.identity;
        return "" + accessorFn(node.dataName);
    };
}
function valueGetterFunction(valueGetter) {
    return typeof valueGetter === 'function' ? valueGetter : config_1.VALUE_GETTERS[valueGetter];
}
exports.valueGetterFunction = valueGetterFunction;
function render(partitionSpec, parentDimensions, tree, containerBackgroundColor) {
    var width = parentDimensions.width, height = parentDimensions.height;
    var layers = partitionSpec.layers, topGroove = partitionSpec.topGroove, specConfig = partitionSpec.config;
    var textMeasurer = document.createElement('canvas');
    var textMeasurerCtx = textMeasurer.getContext('2d');
    var partialConfig = __assign(__assign({}, specConfig), { width: width, height: height });
    var config = commons_1.mergePartial(config_1.config, partialConfig);
    if (!textMeasurerCtx) {
        return viewmodel_types_1.nullShapeViewModel(config, { x: width / 2, y: height / 2 });
    }
    var valueGetter = valueGetterFunction(partitionSpec.valueGetter);
    return viewmodel_1.shapeViewModel(measure_1.measureText(textMeasurerCtx), config, layers, rawTextGetter(layers), partitionSpec.valueFormatter, partitionSpec.percentFormatter, valueGetter, tree, topGroove, containerBackgroundColor);
}
exports.render = render;
//# sourceMappingURL=scenegraph.js.map