"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "WizardPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.WizardPluginSetup;
  }
});
Object.defineProperty(exports, "WizardPluginStart", {
  enumerable: true,
  get: function () {
    return _types.WizardPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;

var _config = require("../config");

var _plugin = require("./plugin");

var _types = require("./types");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// This exports static code and TypeScript types,
// as well as the OpenSearch Dashboards Platform `plugin()` initializer.
function plugin(initializerContext) {
  return new _plugin.WizardPlugin(initializerContext);
}

const config = {
  exposeToBrowser: {
    enabled: true
  },
  schema: _config.configSchema
};
exports.config = config;