/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int UNIT;

    public YGValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return YGValue.nvalue(this.address());
    }

    @NativeType(value="YGUnit")
    public int unit() {
        return YGValue.nunit(this.address());
    }

    public YGValue value(float value) {
        YGValue.nvalue(this.address(), value);
        return this;
    }

    public YGValue unit(@NativeType(value="YGUnit") int value) {
        YGValue.nunit(this.address(), value);
        return this;
    }

    public YGValue set(float value, int unit) {
        this.value(value);
        this.unit(unit);
        return this;
    }

    public YGValue set(YGValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGValue malloc() {
        return (YGValue)YGValue.wrap(YGValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static YGValue calloc() {
        return (YGValue)YGValue.wrap(YGValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static YGValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (YGValue)YGValue.wrap(YGValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static YGValue create(long address) {
        return (YGValue)YGValue.wrap(YGValue.class, (long)address);
    }

    @Nullable
    public static YGValue createSafe(long address) {
        return address == 0L ? null : (YGValue)YGValue.wrap(YGValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)YGValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)YGValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)YGValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)YGValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static YGValue mallocStack() {
        return YGValue.mallocStack(MemoryStack.stackGet());
    }

    public static YGValue callocStack() {
        return YGValue.callocStack(MemoryStack.stackGet());
    }

    public static YGValue mallocStack(MemoryStack stack) {
        return (YGValue)YGValue.wrap(YGValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGValue callocStack(MemoryStack stack) {
        return (YGValue)YGValue.wrap(YGValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)YGValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nvalue(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VALUE);
    }

    public static int nunit(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNIT);
    }

    public static void nvalue(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VALUE, value);
    }

    public static void nunit(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNIT, value);
    }

    static {
        Struct.Layout layout = YGValue.__struct((Struct.Member[])new Struct.Member[]{YGValue.__member((int)4), YGValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(0);
        UNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGValue, Buffer>
    implements NativeResource {
        private static final YGValue ELEMENT_FACTORY = YGValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float value() {
            return YGValue.nvalue(this.address());
        }

        @NativeType(value="YGUnit")
        public int unit() {
            return YGValue.nunit(this.address());
        }

        public Buffer value(float value) {
            YGValue.nvalue(this.address(), value);
            return this;
        }

        public Buffer unit(@NativeType(value="YGUnit") int value) {
            YGValue.nunit(this.address(), value);
            return this;
        }
    }
}

