/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InsnRemover {
    private final MethodNode mth;
    private final List<InsnNode> toRemove;
    @Nullable
    private List<InsnNode> instrList;

    public InsnRemover(MethodNode mth) {
        this(mth, null);
    }

    public InsnRemover(MethodNode mth, BlockNode block) {
        this.mth = mth;
        this.toRemove = new ArrayList<InsnNode>();
        if (block != null) {
            this.instrList = block.getInstructions();
        }
    }

    public void setBlock(BlockNode block) {
        this.instrList = block.getInstructions();
    }

    public void addAndUnbind(InsnNode insn) {
        this.toRemove.add(insn);
        InsnRemover.unbindInsn(this.mth, insn);
    }

    public void addWithoutUnbind(InsnNode insn) {
        this.toRemove.add(insn);
        insn.add(AFlag.REMOVE);
        insn.add(AFlag.DONT_GENERATE);
    }

    public void perform() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        if (this.instrList == null) {
            for (InsnNode remInsn : this.toRemove) {
                InsnRemover.remove(this.mth, remInsn);
            }
        } else {
            InsnRemover.removeAll(this.mth, this.instrList, this.toRemove);
        }
        this.toRemove.clear();
    }

    public static void unbindInsn(@Nullable MethodNode mth, InsnNode insn) {
        InsnRemover.unbindAllArgs(mth, insn);
        InsnRemover.unbindResult(mth, insn);
        insn.add(AFlag.REMOVE);
        insn.add(AFlag.DONT_GENERATE);
    }

    public static void unbindAllArgs(@Nullable MethodNode mth, InsnNode insn) {
        for (InsnArg arg : insn.getArguments()) {
            InsnRemover.unbindArgUsage(mth, arg);
        }
        if (insn.getType() == InsnType.PHI) {
            for (InsnArg arg : insn.getArguments()) {
                if (!(arg instanceof RegisterArg)) continue;
                ((RegisterArg)arg).getSVar().updateUsedInPhiList();
            }
        }
        insn.add(AFlag.REMOVE);
        insn.add(AFlag.DONT_GENERATE);
    }

    public static void unbindResult(@Nullable MethodNode mth, InsnNode insn) {
        SSAVar ssaVar;
        RegisterArg r = insn.getResult();
        if (r != null && mth != null && (ssaVar = r.getSVar()) != null && ssaVar.getAssign() == insn.getResult()) {
            InsnRemover.removeSsaVar(mth, ssaVar);
        }
    }

    private static void removeSsaVar(MethodNode mth, SSAVar ssaVar) {
        InsnNode parentInsn;
        int useCount = ssaVar.getUseCount();
        if (useCount == 0) {
            mth.removeSVar(ssaVar);
            return;
        }
        boolean allPhis = true;
        for (RegisterArg arg : ssaVar.getUseList()) {
            parentInsn = arg.getParentInsn();
            if (parentInsn != null && parentInsn.getType() == InsnType.PHI) continue;
            allPhis = false;
            break;
        }
        if (allPhis) {
            for (RegisterArg arg : new ArrayList<RegisterArg>(ssaVar.getUseList())) {
                parentInsn = arg.getParentInsn();
                if (parentInsn == null) continue;
                ((PhiInsn)parentInsn).removeArg(arg);
            }
            mth.removeSVar(ssaVar);
            return;
        }
    }

    public static void unbindArgUsage(@Nullable MethodNode mth, InsnArg arg) {
        if (arg instanceof RegisterArg) {
            RegisterArg reg = (RegisterArg)arg;
            SSAVar sVar = reg.getSVar();
            if (sVar != null) {
                sVar.removeUse(reg);
            }
        } else if (arg instanceof InsnWrapArg) {
            InsnWrapArg wrap = (InsnWrapArg)arg;
            InsnRemover.unbindInsn(mth, wrap.getWrapInsn());
        }
    }

    private static void removeAll(MethodNode mth, List<InsnNode> insns, List<InsnNode> toRemove) {
        if (toRemove == null || toRemove.isEmpty()) {
            return;
        }
        for (InsnNode rem : toRemove) {
            int insnsCount = insns.size();
            boolean found = false;
            for (int i = 0; i < insnsCount; ++i) {
                if (insns.get(i) != rem) continue;
                insns.remove(i);
                InsnRemover.unbindInsn(mth, rem);
                found = true;
                break;
            }
            if (found) continue;
        }
    }

    public static void remove(MethodNode mth, InsnNode insn) {
        BlockNode block = BlockUtils.getBlockByInsn(mth, insn);
        if (block != null) {
            InsnRemover.remove(mth, block, insn);
        }
    }

    public static void remove(MethodNode mth, BlockNode block, InsnNode insn) {
        InsnRemover.unbindInsn(mth, insn);
        Iterator<InsnNode> it = block.getInstructions().iterator();
        while (it.hasNext()) {
            InsnNode ir = it.next();
            if (ir != insn) continue;
            it.remove();
            return;
        }
    }

    public static void removeAllAndUnbind(MethodNode mth, BlockNode block, List<InsnNode> insns) {
        for (InsnNode insn : insns) {
            InsnRemover.unbindInsn(mth, insn);
        }
        InsnRemover.removeAll(mth, block.getInstructions(), insns);
    }

    public static void remove(MethodNode mth, BlockNode block, int index) {
        List<InsnNode> instructions = block.getInstructions();
        InsnRemover.unbindInsn(mth, instructions.get(index));
        instructions.remove(index);
    }

    private static /* synthetic */ String lambda$removeSsaVar$0(RegisterArg arg) {
        return arg + " from " + arg.getParentInsn();
    }
}

