/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class FloodThrottler {
    private final ObjectCounter<Hash> counter = new ObjectCounter();
    private static final int MAX_FLOODS = 3;
    private static final long CLEAN_TIME = 60000L;

    FloodThrottler() {
        SimpleTimer2.getInstance().addPeriodicEvent(new Cleaner(), 60000L);
    }

    boolean shouldThrottle(Hash h) {
        return this.counter.increment(h) > 3;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            FloodThrottler.this.counter.clear();
        }
    }
}

