'''OpenGL extension NV.texture_rectangle_compressed

This module customises the behaviour of the 
OpenGL.raw.GL.NV.texture_rectangle_compressed to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows applications to use compressed texture formats
	with the TEXTURE_RECTANGLE texture target, removing an old limitation
	that prohibited such usage globally for rectangle textures.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/texture_rectangle_compressed.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.texture_rectangle_compressed import *
from OpenGL.raw.GL.NV.texture_rectangle_compressed import _EXTENSION_NAME

def glInitTextureRectangleCompressedNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION