/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivePump
implements Runnable {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ReceivePump.class);
    private final IPartitionReceiver receiver;
    private final PartitionReceiveHandler onReceiveHandler;
    private final boolean invokeOnTimeout;
    private final CompletableFuture<Void> stopPump;
    private final Executor executor;
    private final ProcessAndReschedule processAndReschedule;
    private final String eventHubName;
    private final String consumerGroupName;
    private AtomicBoolean stopPumpRaised;
    private volatile boolean isPumpHealthy = true;

    public ReceivePump(String eventHubName, String consumerGroupName, IPartitionReceiver receiver, PartitionReceiveHandler receiveHandler, boolean invokeOnReceiveWithNoEvents, Executor executor) {
        this.eventHubName = eventHubName;
        this.consumerGroupName = consumerGroupName;
        this.receiver = receiver;
        this.onReceiveHandler = receiveHandler;
        this.invokeOnTimeout = invokeOnReceiveWithNoEvents;
        this.stopPump = new CompletableFuture();
        this.executor = executor;
        this.processAndReschedule = new ProcessAndReschedule();
        this.stopPumpRaised = new AtomicBoolean(false);
    }

    @Override
    public void run() {
        try {
            this.receiveAndProcess();
        }
        catch (Exception exception) {
            if (TRACE_LOGGER.isErrorEnabled()) {
                TRACE_LOGGER.error(String.format("Receive pump for eventHub (%s), consumerGroup (%s), partition (%s) encountered unrecoverable error and exited with exception %s.", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId(), exception.toString()));
            }
            throw exception;
        }
    }

    public void receiveAndProcess() {
        if (this.shouldContinue()) {
            this.receiver.receive(this.onReceiveHandler.getMaxEventCount()).handleAsync((BiFunction)this.processAndReschedule, this.executor);
        } else {
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format("Stopping receive pump for eventHub (%s), consumerGroup (%s), partition (%s) as %s", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId(), this.stopPumpRaised.get() ? "per the request." : "pump ran into errors."));
            }
            this.stopPump.complete(null);
        }
    }

    public CompletableFuture<Void> stop() {
        this.stopPumpRaised.set(true);
        return this.stopPump;
    }

    public boolean isRunning() {
        return !this.stopPump.isDone();
    }

    private boolean shouldContinue() {
        return this.isPumpHealthy && !this.stopPumpRaised.get();
    }

    private void handleClientExceptions(Throwable clientException) {
        if (clientException != null) {
            this.isPumpHealthy = false;
            if (TRACE_LOGGER.isWarnEnabled()) {
                TRACE_LOGGER.warn(String.format("Receive pump for eventHub (%s), consumerGroup (%s), partition (%s) exiting after receive exception %s", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId(), clientException.toString()));
            }
            this.onReceiveHandler.onError(clientException);
        }
    }

    private void handleUserCodeExceptions(Throwable userCodeException) {
        this.isPumpHealthy = false;
        if (TRACE_LOGGER.isErrorEnabled()) {
            TRACE_LOGGER.error(String.format("Receive pump for eventHub (%s), consumerGroup (%s), partition (%s) exiting after user-code exception %s", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId(), userCodeException.toString()));
        }
        this.onReceiveHandler.onError(userCodeException);
        if (userCodeException instanceof InterruptedException) {
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format("Interrupting receive pump for eventHub (%s), consumerGroup (%s),  partition (%s)", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId()));
            }
            Thread.currentThread().interrupt();
        }
    }

    private void schedulePump() {
        try {
            this.executor.execute(this);
        }
        catch (RejectedExecutionException rejectedException) {
            this.isPumpHealthy = false;
            if (TRACE_LOGGER.isWarnEnabled()) {
                TRACE_LOGGER.warn(String.format("Receive pump for eventHub (%s), consumerGroup (%s), partition (%s) exiting with error: %s", this.eventHubName, this.consumerGroupName, this.receiver.getPartitionId(), rejectedException.toString()));
            }
            this.onReceiveHandler.onError(rejectedException);
        }
    }

    private final class ProcessAndReschedule
    implements BiFunction<Iterable<EventData>, Throwable, Void> {
        private ProcessAndReschedule() {
        }

        @Override
        public Void apply(Iterable<EventData> receivedEvents, Throwable clientException) {
            ReceivePump.this.handleClientExceptions(clientException);
            try {
                if (ReceivePump.this.shouldContinue() && (receivedEvents != null || receivedEvents == null && ReceivePump.this.invokeOnTimeout)) {
                    ReceivePump.this.onReceiveHandler.onReceive(receivedEvents);
                }
            }
            catch (Throwable userCodeError) {
                ReceivePump.this.handleUserCodeExceptions(userCodeError);
            }
            ReceivePump.this.schedulePump();
            return null;
        }
    }

    public static interface IPartitionReceiver {
        public String getPartitionId();

        public CompletableFuture<Iterable<EventData>> receive(int var1);
    }
}

