/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.factory;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.plugins.ConfigurationImpl;
import org.logstash.plugins.PluginLookup;
import org.logstash.plugins.PluginUtil;
import org.logstash.plugins.factory.PluginFactoryExt;

abstract class AbstractPluginCreator<T extends Plugin> {
    protected PluginFactoryExt pluginsFactory = null;

    AbstractPluginCreator() {
    }

    abstract IRubyObject createDelegator(String var1, Map<String, Object> var2, String var3, AbstractNamespacedMetricExt var4, PluginLookup.PluginClass var5, Context var6);

    protected T instantiateAndValidate(Map<String, Object> pluginArgs, String id, Context pluginContext, PluginLookup.PluginClass pluginClass) {
        Class cls = (Class)pluginClass.klass();
        if (cls == null) {
            throw new IllegalStateException("Unable to instantiate type: " + pluginClass);
        }
        try {
            Constructor ctor = cls.getConstructor(String.class, Configuration.class, Context.class);
            ConfigurationImpl config = new ConfigurationImpl(pluginArgs, this.pluginsFactory);
            Plugin plugin = (Plugin)ctor.newInstance(id, config, pluginContext);
            PluginUtil.validateConfig(plugin, config);
            return (T)plugin;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                throw new IllegalStateException(ex.getCause());
            }
            throw new IllegalStateException(ex);
        }
    }
}

