/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlBasicAggFunction
extends SqlAggFunction {
    private final Optionality distinctOptionality;
    private final SqlSyntax syntax;
    private final boolean allowsNullTreatment;
    private final boolean allowsSeparator;

    private SqlBasicAggFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType, boolean requiresOrder, boolean requiresOver, Optionality requiresGroupOrder, Optionality distinctOptionality, SqlSyntax syntax, boolean allowsNullTreatment, boolean allowsSeparator) {
        super(name, sqlIdentifier, kind, Objects.requireNonNull(returnTypeInference, "returnTypeInference"), operandTypeInference, Objects.requireNonNull(operandTypeChecker, "operandTypeChecker"), Objects.requireNonNull(funcType, "funcType"), requiresOrder, requiresOver, requiresGroupOrder);
        this.distinctOptionality = Objects.requireNonNull(distinctOptionality, "distinctOptionality");
        this.syntax = Objects.requireNonNull(syntax, "syntax");
        this.allowsNullTreatment = allowsNullTreatment;
        this.allowsSeparator = allowsSeparator;
    }

    public static SqlBasicAggFunction create(SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return SqlBasicAggFunction.create(kind.name(), kind, returnTypeInference, operandTypeChecker);
    }

    public static SqlBasicAggFunction create(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlBasicAggFunction(name, null, kind, returnTypeInference, null, operandTypeChecker, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN, Optionality.OPTIONAL, SqlSyntax.FUNCTION, false, false);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlCall strippedCall = call;
        if (this.syntax == SqlSyntax.ORDERED_FUNCTION) {
            if (this.allowsSeparator) {
                strippedCall = ReturnTypes.stripSeparator(strippedCall);
            }
            strippedCall = ReturnTypes.stripOrderBy(strippedCall);
        }
        RelDataType derivedType = super.deriveType(validator, scope, strippedCall);
        for (int i = 0; i < strippedCall.getOperandList().size(); ++i) {
            call.setOperand(i, strippedCall.getOperandList().get(i));
        }
        return derivedType;
    }

    @Override
    public Optionality getDistinctOptionality() {
        return this.distinctOptionality;
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return Objects.requireNonNull(super.getReturnTypeInference(), "returnTypeInference");
    }

    @Override
    public SqlOperandTypeChecker getOperandTypeChecker() {
        return Objects.requireNonNull(super.getOperandTypeChecker(), "operandTypeChecker");
    }

    SqlBasicAggFunction withDistinct(Optionality distinctOptionality) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType(), this.requiresOrder(), this.requiresOver(), this.requiresGroupOrder(), distinctOptionality, this.syntax, this.allowsNullTreatment, this.allowsSeparator);
    }

    public SqlBasicAggFunction withFunctionType(SqlFunctionCategory category) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), category, this.requiresOrder(), this.requiresOver(), this.requiresGroupOrder(), this.distinctOptionality, this.syntax, this.allowsNullTreatment, this.allowsSeparator);
    }

    @Override
    public SqlSyntax getSyntax() {
        return this.syntax;
    }

    public SqlBasicAggFunction withSyntax(SqlSyntax syntax) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType(), this.requiresOrder(), this.requiresOver(), this.requiresGroupOrder(), this.distinctOptionality, syntax, this.allowsNullTreatment, this.allowsSeparator);
    }

    @Override
    public boolean allowsNullTreatment() {
        return this.allowsNullTreatment;
    }

    public SqlBasicAggFunction withAllowsNullTreatment(boolean allowsNullTreatment) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType(), this.requiresOrder(), this.requiresOver(), this.requiresGroupOrder(), this.distinctOptionality, this.syntax, allowsNullTreatment, this.allowsSeparator);
    }

    public boolean allowsSeparator() {
        return this.allowsSeparator;
    }

    public SqlBasicAggFunction withAllowsSeparator(boolean allowsSeparator) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType(), this.requiresOrder(), this.requiresOver(), this.requiresGroupOrder(), this.distinctOptionality, this.syntax, this.allowsNullTreatment, allowsSeparator);
    }

    public SqlBasicAggFunction withGroupOrder(Optionality groupOrder) {
        return new SqlBasicAggFunction(this.getName(), this.getSqlIdentifier(), this.kind, this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType(), this.requiresOrder(), this.requiresOver(), groupOrder, this.distinctOptionality, this.syntax, this.allowsNullTreatment, this.allowsSeparator);
    }
}

